/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.net.SocketType;
import tigase.server.Packet;
import tigase.server.ext.ComponentIOService;
import tigase.server.ext.ComponentProtocolHandler;
import tigase.server.ext.ExtProcessor;
import tigase.server.ext.StreamOpenHandler;
import tigase.xml.Element;

public class StartTLSProcessor
implements ExtProcessor {
    private static final Logger log = Logger.getLogger(StartTLSProcessor.class.getName());
    private static final String EL_NAME = "starttls";
    private static final String ID = "starttls";
    private static final Element FEATURES = new Element("starttls", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"});
    private static final Element FEATURES_REQUIRED = new Element("starttls", new Element[]{new Element("required")}, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"});

    @Override
    public String getId() {
        return "starttls";
    }

    @Override
    public List<Element> getStreamFeatures(ComponentIOService serv, ComponentProtocolHandler handler) {
        if (serv.getSessionData().get("starttls") != null) {
            return null;
        }
        switch ((SocketType)((Object)serv.getSessionData().get("socket"))) {
            case ssl: {
                return null;
            }
            case plain: {
                return Collections.singletonList(FEATURES);
            }
            case tls: {
                return Collections.singletonList(FEATURES_REQUIRED);
            }
        }
        return null;
    }

    @Override
    public boolean process(Packet p, ComponentIOService serv, ComponentProtocolHandler handler, Queue<Packet> results) {
        if (p.getElemName() == "starttls") {
            serv.getSessionData().put("starttls", "starttls");
            String data = "<proceed xmlns='urn:ietf:params:xml:ns:xmpp-tls'/>";
            this.initTLS(serv, data, false);
            log.fine("Started server side TLS.");
            return true;
        }
        if (p.getElemName() == "proceed") {
            serv.getSessionData().put("starttls", "starttls");
            this.initTLS(serv, null, true);
            log.fine("Started client side TLS.");
            StreamOpenHandler soh = handler.getStreamOpenHandler("jabber:client");
            String data = soh.serviceStarted(serv);
            serv.xmppStreamOpen(data);
            log.fine("New stream opened: " + data);
            return true;
        }
        return false;
    }

    @Override
    public void startProcessing(Packet p, ComponentIOService serv, ComponentProtocolHandler handler, Queue<Packet> results) {
        results.offer(Packet.packetInstance(new Element("starttls", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"}), null, null));
    }

    private void initTLS(ComponentIOService serv, String data, boolean client) {
        try {
            serv.writeRawData(data);
            Thread.sleep(10L);
            while (serv.waitingToSend()) {
                serv.writeRawData(null);
                Thread.sleep(10L);
            }
            serv.startTLS(client, false, false);
        }
        catch (Exception e) {
            log.warning("TLS mode start failed: " + e.getMessage());
            serv.forceStop();
        }
    }
}

