/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.net.IOService;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.bosh.BoshIOService;
import tigase.server.bosh.BoshSendQueueTask;
import tigase.server.bosh.BoshSession;
import tigase.server.bosh.BoshSessionTaskHandler;
import tigase.server.bosh.BoshSidLoggerFilter;
import tigase.server.bosh.BoshTask;
import tigase.server.bosh.Constants;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppclient.SeeOtherHostIfc;
import tigase.stats.StatisticsList;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.StreamError;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="bosh", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.ConnectionManagersMode})
@ClusterModeRequired(active=false)
public class BoshConnectionManager
extends ClientConnectionManager
implements BoshSessionTaskHandler,
BoshIOService.ConfigProvider {
    public static final String BOSH_CLOSE_CONNECTION_PROP_KEY = "bosh-close-connection";
    public static final String BOSH_EXTRA_HEADERS_FILE_PROP_KEY = "bosh-extra-headers-file";
    public static final String BOSH_EXTRA_HEADERS_FILE_PROP_VAL = "etc/bosh-extra-headers.txt";
    public static final String CLIENT_ACCESS_POLICY_FILE_PROP_KEY = "client-access-policy-file";
    public static final String CLIENT_ACCESS_POLICY_FILE_PROP_VAL = "etc/client-access-policy.xml";
    private static final Logger log = Logger.getLogger(BoshConnectionManager.class.getName());
    private static final int DEF_PORT_NO = 5280;
    private static Handler sidFilehandler;
    protected final Map<UUID, BoshSession> sessions = new ConcurrentSkipListMap<UUID, BoshSession>();
    private int[] PORTS = new int[]{5280};
    @ConfigField(desc="Batch queue timeout", alias="batch-queue-timeout")
    private long batch_queue_timeout = 100L;
    @ConfigField(desc="Delay before closing BOSH session", alias="bosh-session-close-delay")
    private long bosh_session_close_delay = 0L;
    private String clientAccessPolicy = null;
    @ConfigField(desc="Client access policy file", alias="client-access-policy-file")
    private String clientAccessPolicyFile = "etc/client-access-policy.xml";
    @ConfigField(desc="Close BOSH connections", alias="bosh-close-connection")
    private boolean closeConnections = false;
    @ConfigField(desc="Maximal number of concurrent quests", alias="concurrent-requests")
    private int concurrent_requests = 2;
    private String extraHeaders = null;
    @ConfigField(desc="Extra headers file", alias="bosh-extra-headers-file")
    private String extraHeadersFile = "etc/bosh-extra-headers.txt";
    @ConfigField(desc="Maximal number of hold requests", alias="hold-requests")
    private int hold_requests = 1;
    @ConfigField(desc="Limit of number of packets waiting to send for a single session", alias="max-session-waiting-packets")
    private int maxSessionWaitingPackets = 100;
    @ConfigField(desc="Maximal size of batch", alias="max-batch-size")
    private int max_batch_size = 15;
    @ConfigField(desc="Maximal allowed time of inactivity", alias="max-inactivity")
    private long max_inactivity = 10L;
    @ConfigField(desc="Maximal allowed pause time", alias="max-inactivity")
    private long max_pause = 10L;
    @ConfigField(desc="Maximal allowed wait time", alias="max-wait")
    private long max_wait = 30L;
    @ConfigField(desc="Minimal allowed polling time", alias="min-polling")
    private long min_polling = 10L;
    @ConfigField(desc="Should send node hostname a BOSH element attribute", alias="send-node-hostname")
    private boolean sendNodeHostname = true;
    @ConfigField(desc="SID logger level", alias="sid-logger-level")
    private String sidLoggerLevel = Constants.SID_LOGGER_VAL;
    private ReceiverTimeoutHandler startedHandler = this.newStartedHandler();
    private ReceiverTimeoutHandler stoppedHandler = this.newStoppedHandler();

    protected static void setupSidlogger(Level lvl) {
        if (!Level.OFF.equals(lvl)) {
            BoshSidLoggerFilter bslf = new BoshSidLoggerFilter();
            Logger BoshConnectionManagerLogger = Logger.getLogger(BoshConnectionManager.class.getName());
            Logger BoshSessionLogger = Logger.getLogger(BoshSession.class.getName());
            if (BoshConnectionManagerLogger.getLevel() == null || BoshSessionLogger.getLevel() == null || BoshConnectionManagerLogger.getLevel().intValue() < lvl.intValue()) {
                BoshConnectionManagerLogger.setLevel(lvl);
                BoshConnectionManagerLogger.setFilter(bslf);
                BoshSessionLogger.setLevel(lvl);
                BoshSessionLogger.setFilter(bslf);
                BoshConnectionManagerLogger.getParent().setFilter(bslf);
            }
            try {
                if (null == sidFilehandler) {
                    sidFilehandler = new FileHandler("logs/bosh_sid.log", 10000000, 5, false);
                    sidFilehandler.setLevel(lvl);
                    sidFilehandler.setFilter(bslf);
                    BoshConnectionManagerLogger.getParent().addHandler(sidFilehandler);
                }
            }
            catch (IOException ex) {
                log.log(Level.CONFIG, "Error creating BOSH SID logger" + ex);
            }
        }
    }

    @Override
    public boolean addOutStreamClosed(Packet packet, BoshSession bs, boolean withTimeout) {
        packet.setPacketFrom(this.getFromAddress(bs.getSid().toString()));
        packet.setPacketTo(bs.getDataReceiver());
        packet.initVars(packet.getPacketFrom(), packet.getPacketTo());
        bs.close();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.REMOVE, bs.getSid(), "Closing bosh session"});
        }
        this.sessions.remove(bs.getSid());
        if (withTimeout) {
            return this.addOutPacketWithTimeout(packet, this.stoppedHandler, 15L, TimeUnit.SECONDS);
        }
        return this.addOutPacket(packet);
    }

    @Override
    public boolean addOutStreamOpen(Packet packet, BoshSession bs) {
        packet.initVars(this.getFromAddress(bs.getSid().toString()), bs.getDataReceiver());
        return this.addOutPacketWithTimeout(packet, this.startedHandler, 15L, TimeUnit.SECONDS);
    }

    @Override
    public void cancelSendQueueTask(BoshSendQueueTask tt) {
        tt.cancel();
    }

    @Override
    public void cancelTask(BoshTask tt) {
        tt.cancel();
    }

    @Override
    protected boolean enableServiceConnectedTimeout(XMPPIOService<Object> service) {
        return false;
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet.toString());
        }
        super.processPacket(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue<Packet> processSocketData(XMPPIOService<Object> srv) {
        BoshIOService serv = (BoshIOService)srv;
        Packet p = null;
        while ((p = serv.getReceivedPackets().poll()) != null) {
            ArrayDeque<Packet> out_results = new ArrayDeque<Packet>(2);
            BoshSession bs = null;
            String sid_str = null;
            Object object = this.sessions;
            synchronized (object) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Processing packet: {0}, type: {1}", new Object[]{p.getElemName(), p.getType()});
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Processing socket data: {0}", p);
                }
                sid_str = p.getAttributeStaticStr("sid");
                UUID sid = null;
                if (sid_str == null) {
                    String hostname = p.getAttributeStaticStr("to");
                    if (hostname != null && this.isLocalDomain(hostname)) {
                        if (!this.isAllowed(srv, hostname)) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Policy violation. Closing connection: {0}", p);
                            }
                            try {
                                serv.sendErrorAndStop(Authorization.NOT_ALLOWED, StreamError.PolicyViolation, p, "Policy violation.");
                            }
                            catch (IOException e) {
                                log.log(Level.WARNING, "Problem sending invalid hostname error for sid =  " + sid, e);
                            }
                        } else {
                            bs = new BoshSession(this.getDefVHostItem().getDomain(), JID.jidInstanceNS((String)this.routings.computeRouting(hostname)), this, this.sendNodeHostname ? this.getDefHostName().getDomain() : null, this.maxSessionWaitingPackets);
                            sid = bs.getSid();
                            this.sessions.put(sid, bs);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.CREATE, sid, "Socket bosh session"});
                            }
                        }
                    } else {
                        try {
                            serv.sendErrorAndStop(Authorization.NOT_ALLOWED, hostname == null ? StreamError.ImproperAddressing : StreamError.HostUnknown, p, "Invalid hostname.");
                        }
                        catch (IOException e) {
                            log.log(Level.WARNING, "Problem sending invalid hostname error for sid =  " + sid, e);
                        }
                    }
                } else {
                    try {
                        sid = UUID.fromString(sid_str);
                        bs = this.sessions.get(sid);
                    }
                    catch (IllegalArgumentException e) {
                        log.log(Level.WARNING, "Problem processing socket data, sid =  " + sid_str + " does not conform to the UUID string representation.", e);
                    }
                }
            }
            try {
                if (bs != null) {
                    object = bs;
                    synchronized (object) {
                        if (sid_str == null) {
                            bs.init(p, serv, this.max_wait, this.min_polling, this.max_inactivity, this.concurrent_requests, this.hold_requests, this.max_pause, this.max_batch_size, this.batch_queue_timeout, out_results);
                        } else {
                            bs.processSocketPacket(p, serv, out_results);
                        }
                    }
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.INVALID_SID, sid_str, "Invalid SID"});
                    }
                    serv.sendErrorAndStop(Authorization.ITEM_NOT_FOUND, null, p, "Invalid SID");
                }
                this.addOutPackets(out_results, bs);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Problem processing socket data for sid =  " + sid_str, e);
            }
        }
        return null;
    }

    @Override
    public BoshSendQueueTask scheduleSendQueueTask(BoshSession bs, long delay) {
        BoshSendQueueTask bt = new BoshSendQueueTask(bs);
        this.addTimerTask(bt, delay);
        return bt;
    }

    @Override
    public BoshTask scheduleTask(BoshSession bs, long delay) {
        BoshTask bt = new BoshTask(bs, this);
        this.addTimerTask(bt, delay);
        return bt;
    }

    @Override
    public void serviceStarted(XMPPIOService<Object> service) {
        super.serviceStarted(service);
    }

    @Override
    public boolean serviceStopped(XMPPIOService<Object> xmppService) {
        BoshSession bs;
        BoshIOService service = (BoshIOService)xmppService;
        boolean result = super.serviceStopped(service);
        UUID sid = service.getSid();
        if (sid != null && (bs = this.sessions.get(sid)) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.REMOVE, bs.getSid(), "Closing bosh session"});
            }
            bs.disconnected(service);
        }
        return result;
    }

    @Override
    public void writeRawData(BoshIOService ios, String data) {
        super.writeRawData(ios, data);
    }

    @Override
    public void xmppStreamClosed(XMPPIOService<Object> serv) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Stream closed.");
        }
    }

    @Override
    public String[] xmppStreamOpened(XMPPIOService<Object> serv, Map<String, String> attribs) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ups, what just happened? Stream open. Hey, this is a Bosh connection manager. c2s and s2s are not supported on the same port as Bosh yet.");
        }
        return new String[]{"<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='1' from='" + this.getDefVHostItem() + "' version='1.0' xml:lang='en'><stream:error><invalid-namespace xmlns='urn:ietf:params:xml:ns:xmpp-streams'/><text xmlns='urn:ietf:params:xml:ns:xmpp-streams' xml:lang='langcode'>Ups, what just happened? Stream open. Hey, this is a Bosh connection manager. c2s and s2s are not supported on the same port... yet.</text></stream:error></stream:stream>"};
    }

    @Override
    public String getDiscoCategoryType() {
        return "c2s";
    }

    @Override
    public String getDiscoDescription() {
        return "Bosh connection manager";
    }

    @Override
    public JID getJidForBoshSession(BoshSession bs) {
        return this.getFromAddress(bs.getSid().toString());
    }

    @Override
    public Element getSeeOtherHostError(Packet packet, BareJID destination) {
        Object xmppioService = this.getXMPPIOService(packet);
        Integer redirect_port = (Integer)((IOService)xmppioService).getSessionData().get("force-redirect-to");
        return this.see_other_host_strategy.getStreamError("urn:ietf:params:xml:ns:xmpp-streams", destination, redirect_port);
    }

    @Override
    public BareJID getSeeOtherHostForJID(Packet packet, BareJID fromJID, SeeOtherHostIfc.Phase ph) {
        Object xmppioService;
        if (this.see_other_host_strategy == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("no see-other-host implementation set");
            }
            return null;
        }
        if (!this.see_other_host_strategy.isEnabled(this.vHostManager.getVHostItem(fromJID.getDomain()), ph)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("see-other-host not enabled for the Phase: " + ph.toString());
            }
            return null;
        }
        BareJID see_other_host = this.see_other_host_strategy.findHostForJID(fromJID, this.getDefHostName());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("using = " + this.see_other_host_strategy.getClass().getCanonicalName() + "for jid = " + fromJID.toString() + " got = " + (see_other_host != null ? see_other_host.toString() : "null") + " in phase: " + ph.toString());
        }
        Integer redirect_port = (xmppioService = this.getXMPPIOService(packet)) != null ? (Integer)((IOService)xmppioService).getSessionData().getOrDefault("force-redirect-to", -1) : -1;
        return see_other_host != null && (redirect_port > 0 || this.see_other_host_strategy.isRedirectionRequired(this.getDefHostName(), see_other_host)) ? see_other_host : null;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        if (list.checkLevel(Level.FINEST)) {
            list.add(this.getName(), "Bosh sessions", this.sessions.size(), Level.FINEST);
        }
    }

    public void setSidLoggerLevel(String loggerLevel) {
        Level level = Level.OFF;
        if (loggerLevel != null) {
            level = Level.parse(loggerLevel);
        }
        this.sidLoggerLevel = level.getName();
        BoshConnectionManager.setupSidlogger(level);
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("boshCM", (Object)this);
    }

    @Override
    public void initialize() {
        if (this.extraHeaders == null && this.extraHeadersFile != null) {
            this.setExtraHeadersFile(this.extraHeadersFile);
        }
        if (this.clientAccessPolicy == null && this.clientAccessPolicyFile != null) {
            this.setClientAccessPolicyFile(this.clientAccessPolicyFile);
        }
        super.initialize();
    }

    @Override
    public boolean isCloseConnections() {
        return this.closeConnections;
    }

    @Override
    public String getClientAccessPolicy() {
        return this.clientAccessPolicy;
    }

    public void setClientAccessPolicyFile(String clientAccessPolicyFile) {
        this.clientAccessPolicyFile = clientAccessPolicyFile;
        try {
            BufferedReader br = new BufferedReader(new FileReader(clientAccessPolicyFile));
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line).append("\r\n");
                line = br.readLine();
            }
            br.close();
            this.clientAccessPolicy = sb.toString();
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem reading client access policy file: " + clientAccessPolicyFile, ex);
        }
    }

    @Override
    public String getExtraHeaders() {
        return this.extraHeaders;
    }

    public void setExtraHeadersFile(String extraHeadersFile) {
        this.extraHeadersFile = extraHeadersFile;
        try {
            BufferedReader br = new BufferedReader(new FileReader(extraHeadersFile));
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line).append("\r\n");
                line = br.readLine();
            }
            br.close();
            this.extraHeaders = sb.toString();
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem reading Bosh extra headers file: " + extraHeadersFile, ex);
        }
    }

    @Override
    protected void setupWatchdogThread() {
    }

    protected Map<String, String> preBindSession(Map<String, String> attr) {
        String hostname = attr.get("to");
        ArrayDeque<Packet> out_results = new ArrayDeque<Packet>(2);
        BoshSession bs = new BoshSession(this.getDefVHostItem().getDomain(), JID.jidInstanceNS((String)this.routings.computeRouting(hostname)), this, this.sendNodeHostname ? this.getDefHostName().getDomain() : null, this.maxSessionWaitingPackets);
        String jid = attr.get("from");
        String uuid = UUID.randomUUID().toString();
        JID userId = JID.jidInstanceNS((String)jid);
        if (null == userId.getResource()) {
            userId = userId.copyWithResourceNS(uuid);
            attr.put("from", userId.toString());
            bs.setUserJid(jid);
        }
        long rid = (long)(Math.random() * 1.0E7);
        attr.put("rid", Long.toString(rid));
        UUID sid = bs.getSid();
        this.sessions.put(sid, bs);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.CREATE, bs.getSid(), "Pre-bind"});
        }
        attr.put("sid", sid.toString());
        Packet p = null;
        try {
            Element el = new Element("body");
            el.setAttributes(attr);
            p = Packet.packetInstance(el);
            p.setPacketTo(this.getComponentId().copyWithResource(sid.toString()));
        }
        catch (TigaseStringprepException ex) {
            Logger.getLogger(BoshConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        bs.init(p, null, this.max_wait, this.min_polling, this.max_inactivity, this.concurrent_requests, this.hold_requests, this.max_pause, this.max_batch_size, this.batch_queue_timeout, out_results, true);
        this.addOutPackets(out_results, bs);
        attr.put("hostname", this.getDefHostName().toString());
        return attr;
    }

    protected void addOutPackets(Queue<Packet> out_results, BoshSession bs) {
        for (Packet res : out_results) {
            res.setPacketFrom(this.getFromAddress(bs.getSid().toString()));
            res.setPacketTo(bs.getDataReceiver());
            if (res.getCommand() != null) {
                switch (res.getCommand()) {
                    case STREAM_CLOSED: 
                    case GETFEATURES: {
                        res.initVars(res.getPacketFrom(), res.getPacketTo());
                        break;
                    }
                }
            }
            this.addOutPacket(res);
        }
        out_results.clear();
    }

    @Override
    protected JID changeDataReceiver(Packet packet, JID newAddress, String command_sessionId, XMPPIOService<Object> serv) {
        BoshSession session = this.getBoshSession(packet.getTo());
        if (session != null) {
            String sessionId = session.getSessionId();
            if (sessionId.equals(command_sessionId)) {
                JID old_receiver = session.getDataReceiver();
                session.setDataReceiver(newAddress);
                return old_receiver;
            }
            log.info("Incorrect session ID, ignoring data redirect for: " + newAddress);
        }
        return null;
    }

    @Override
    protected ReceiverTimeoutHandler newStartedHandler() {
        return new StartedHandler();
    }

    @Override
    protected void processCommand(Packet packet) {
        BoshSession session = this.getBoshSession(packet.getTo());
        switch (packet.getCommand()) {
            case USER_LOGIN: {
                String jid = Command.getFieldValue(packet, "user-jid");
                if (jid != null) {
                    if (session != null) {
                        try {
                            BareJID fromJID = BareJID.bareJIDInstance((String)jid);
                            BareJID hostJid = this.getSeeOtherHostForJID(packet, fromJID, SeeOtherHostIfc.Phase.LOGIN);
                            if (hostJid != null) {
                                Object xmppioService = this.getXMPPIOService(packet);
                                Integer port = (Integer)((IOService)xmppioService).getSessionData().get("force-redirect-to");
                                Element streamErrorElement = this.see_other_host_strategy.getStreamError("urn:ietf:params:xml:ns:xmpp-streams", hostJid, port);
                                Packet redirectPacket = Packet.packetInstance(streamErrorElement);
                                redirectPacket.setPacketTo(packet.getTo());
                                this.writePacketToSocket(redirectPacket);
                                session.sendWaitingPackets();
                                session.close();
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.REMOVE, session.getSid(), "See other host"});
                                }
                                this.sessions.remove(session.getSid());
                                break;
                            }
                            session.setUserJid(jid);
                        }
                        catch (TigaseStringprepException ex) {
                            log.log(Level.SEVERE, "user JID violates RFC6122 (XMPP:Address Format): ", ex);
                        }
                        break;
                    }
                    if (!log.isLoggable(Level.FINE)) break;
                    log.log(Level.FINE, "Missing XMPPIOService for USER_LOGIN command: {0}", packet);
                    break;
                }
                log.log(Level.WARNING, "Missing user-jid for USER_LOGIN command: {0}", packet);
                break;
            }
            case CLOSE: {
                if (session != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Closing session for command CLOSE: {0}", session.getSid());
                    }
                    try {
                        List err_el = packet.getElement().getChildrenStaticStr(Iq.IQ_COMMAND_PATH);
                        if (err_el != null && err_el.size() > 0) {
                            Element error = new Element("stream:error");
                            error.addChild((XMLNodeIfc)err_el.get(0));
                            Packet condition = Packet.packetInstance(error);
                            condition.setPacketTo(packet.getTo());
                            this.writePacketToSocket(condition);
                            session.sendWaitingPackets();
                            this.bosh_session_close_delay = 100L;
                        }
                    }
                    catch (TigaseStringprepException ex) {
                        Logger.getLogger(BoshConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (this.bosh_session_close_delay > 0L) {
                        try {
                            Thread.sleep(this.bosh_session_close_delay);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                    session.close();
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.REMOVE, session.getSid(), "Closing session for command CLOSE"});
                    }
                    this.sessions.remove(session.getSid());
                    break;
                }
                if (!log.isLoggable(Level.FINE)) break;
                log.log(Level.FINE, "Session does not exist for packet: {0}", packet);
                break;
            }
            case CHECK_USER_CONNECTION: {
                if (session != null) {
                    this.addOutPacket(packet.okResult((String)null, 0));
                    break;
                }
                try {
                    this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Connection gone.", false));
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.INFO, "Error packet is not really expected here: {0}", packet);
                }
                break;
            }
            default: {
                super.processCommand(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean writePacketToSocket(Packet packet) {
        BoshSession session = this.getBoshSession(packet.getTo());
        if (session != null) {
            BoshSession boshSession = session;
            synchronized (boshSession) {
                ArrayDeque<Packet> out_results = new ArrayDeque<Packet>();
                session.processPacket(packet, out_results);
                this.addOutPackets(out_results, session);
            }
            return true;
        }
        log.info("Session does not exist for packet: " + packet.toString());
        return false;
    }

    protected BoshSession getBoshSession(JID jid) {
        String res = jid.getResource();
        if (res != null) {
            UUID sid = UUID.fromString(res);
            return this.sessions.get(sid);
        }
        return null;
    }

    @Override
    protected int[] getDefPlainPorts() {
        return this.PORTS;
    }

    @Override
    protected int[] getDefSSLPorts() {
        return null;
    }

    @Override
    protected long getMaxInactiveTime() {
        return 600000L;
    }

    @Override
    protected BoshIOService getXMPPIOServiceInstance() {
        return new BoshIOService(this);
    }

    private JID getFromAddress(String id) {
        return JID.jidInstanceNS((String)this.getName(), (String)this.getDefHostName().getDomain(), (String)id);
    }

    private class StartedHandler
    implements ReceiverTimeoutHandler {
        private StartedHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            String pb = Command.getFieldValue(packet, "prebind");
            boolean prebind = Boolean.valueOf(pb);
            String sessionId = Command.getFieldValue(packet, "session-id");
            String userID = Command.getFieldValue(packet, "jid");
            if (prebind) {
                Packet packetOut = Command.USER_STATUS.getPacket(packet.getFrom(), packet.getTo(), StanzaType.get, UUID.randomUUID().toString());
                Command.addFieldValue(packetOut, "jid", userID);
                if (null != sessionId) {
                    Command.addFieldValue(packetOut, "session-id", sessionId);
                }
                Command.addFieldValue(packetOut, "prebind", String.valueOf(prebind));
                BoshConnectionManager.this.addOutPacket(packetOut);
            } else {
                BoshConnectionManager.this.addOutPacket(Command.GETFEATURES.getPacket(packet.getFrom(), packet.getTo(), StanzaType.get, UUID.randomUUID().toString(), null));
            }
        }

        @Override
        public void timeOutExpired(Packet packet) {
            log.warning("No response within time limit received for a packet: " + packet.toString());
            BoshSession session = BoshConnectionManager.this.getBoshSession(packet.getFrom());
            if (session != null) {
                log.fine("Closing session for timeout: " + session.getSid());
                session.close();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.REMOVE, session.getSid(), "Closing session for timeout"});
                }
                BoshConnectionManager.this.sessions.remove(session.getSid());
            } else {
                log.info("Session does not exist for packet: " + packet.toString());
            }
        }
    }

    protected static enum BOSH_OPERATION_TYPE {
        CREATE,
        REMOVE,
        INVALID_SID,
        TIMER;

        private static final Map<String, BOSH_OPERATION_TYPE> nameToValueMap;

        public static BOSH_OPERATION_TYPE forName(String name) {
            return nameToValueMap.get(name);
        }

        static {
            nameToValueMap = new HashMap<String, BOSH_OPERATION_TYPE>();
            for (BOSH_OPERATION_TYPE value : EnumSet.allOf(BOSH_OPERATION_TYPE.class)) {
                nameToValueMap.put(value.name(), value);
            }
        }
    }
}

