/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.Kernel;
import tigase.monitor.MonitorComponent;
import tigase.monitor.TasksScriptRegistrar;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="x-add-task", parent=MonitorComponent.class, active=true)
public class AddScriptTaskCommand
implements AdHocCommand {
    private static final Logger log = Logger.getLogger(AddScriptTaskCommand.class.getName());
    private static final Optional<String> GROUP = Optional.of("Monitor");
    @Inject
    private MonitorComponent component;
    @Inject(bean="kernel")
    private Kernel kernel;

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                Form form = new Form("form", "Add monitor script", null);
                List<ScriptEngineFactory> sef = this.kernel.getInstance(ScriptEngineManager.class).getEngineFactories();
                ArrayList<String> labels = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                for (ScriptEngineFactory scriptEngineFactory : sef) {
                    labels.add(scriptEngineFactory.getLanguageName());
                    values.add(scriptEngineFactory.getExtensions().get(0));
                }
                form.addField(Field.fieldTextSingle((String)"scriptName", (String)"", (String)"Script name"));
                form.addField(Field.fieldListSingle((String)"scriptExtension", (String)"", (String)"Script engine", (String[])labels.toArray(new String[0]), (String[])values.toArray(new String[0])));
                form.addField(Field.fieldTextMulti((String)"scriptContent", (String)"", (String)"Script"));
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    String scriptName = form.getAsString("scriptName");
                    String scriptExtension = form.getAsString("scriptExtension");
                    String scriptContent = form.getAsString("scriptContent");
                    ((TasksScriptRegistrar)this.kernel.getInstance("TasksScriptRegistrar")).registerScript(scriptName, scriptExtension, scriptContent);
                }
                form = new Form("form", "Completed", null);
                form.addField(Field.fieldFixed((String)"Script added."));
                response.getElements().add(form.getElement());
                response.completeSession();
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Error adding script", e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return "Add monitor task";
    }

    @Override
    public String getNode() {
        return "x-add-task";
    }

    @Override
    public Optional<String> getGroup() {
        return GROUP;
    }

    @Override
    public boolean isAllowedFor(JID jid) {
        return this.component.isAdmin(jid);
    }
}

