/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.security.KeyStore;
import java.security.cert.CertificateParsingException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.io.CertificateContainerIfc;
import tigase.io.SSLContextContainerIfc;
import tigase.osgi.ModulesManagerImpl;

public abstract class TLSUtil {
    private static final Logger log = Logger.getLogger(TLSUtil.class.getName());
    private static CertificateContainerIfc certificateContainer = null;
    private static SSLContextContainerIfc sslContextContainer = null;

    public static void addCertificate(Map<String, String> params) throws CertificateParsingException {
        sslContextContainer.addCertificates(params);
    }

    public static void configureSSLContext(Map<String, Object> params) {
        if (sslContextContainer != null) {
            return;
        }
        String sslCC_class = (String)params.get("ssl-container-class");
        String certC_class = (String)params.get("cert-container-class");
        if (sslCC_class == null) {
            sslCC_class = SSLContextContainerIfc.SSL_CONTAINER_CLASS_VAL;
        }
        if (sslCC_class.equals("tigase.io.jdk18.SNISSLContextContainer")) {
            log.log(Level.WARNING, "You are using '" + sslCC_class + "' as ssl-container-class.\nThis class is not available as SNI support was moved to SSLContextContainer");
            sslCC_class = SSLContextContainerIfc.SSL_CONTAINER_CLASS_VAL;
        }
        if (sslCC_class.equals("tigase.extras.io.PEMSSLContextContainer")) {
            log.log(Level.WARNING, "You are using '" + sslCC_class + "' as ssl-container-class.\nThis class is not available any more. To keep using this feature please replace configuration\nof ssl-container-class to " + sslCC_class + " with cert-container-class\nset to tigase.extras.io.PEMCertificateContainer");
            sslCC_class = SSLContextContainerIfc.SSL_CONTAINER_CLASS_VAL;
            certC_class = "tigase.extras.io.PEMCertificateContainer";
        }
        if (certC_class == null) {
            certC_class = CertificateContainerIfc.CERTIFICATE_CONTAINER_CLASS_VAL;
        }
        try {
            certificateContainer = (CertificateContainerIfc)ModulesManagerImpl.getInstance().forName(certC_class).newInstance();
            certificateContainer.init(params);
            sslContextContainer = (SSLContextContainerIfc)ModulesManagerImpl.getInstance().forName(sslCC_class).getDeclaredConstructor(CertificateContainerIfc.class).newInstance(certificateContainer);
            sslContextContainer.start();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not initialize SSL Container: " + sslCC_class, e);
            sslContextContainer = null;
        }
    }

    public static CertificateContainerIfc getCertificateContainer() {
        return certificateContainer;
    }

    public static SSLContextContainerIfc getRootSslContextContainer() {
        return sslContextContainer;
    }

    public static KeyStore getTrustStore() {
        return sslContextContainer.getTrustStore();
    }
}

