/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.conf.ConfigItem;
import tigase.conf.ConfigurationCache;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.util.repository.DataTypes;

@Deprecated
@TigaseDeprecated(since="8.0.0")
public class ConfigSQLRepository
extends ConfigurationCache {
    public static final String CONFIG_REPO_URI_PROP_KEY = "tigase-config-repo-uri";
    public static final String CONFIG_REPO_URI_INIT_KEY = "--tigase-config-repo-uri";
    private static final Logger log = Logger.getLogger(ConfigSQLRepository.class.getName());
    private JDBCAccess dbAccess = new JDBCAccess();

    @Override
    public void addItem(String compName, ConfigItem item) {
        this.dbAccess.addItem(item);
    }

    @Override
    public Collection<ConfigItem> allItems() throws TigaseDBException {
        return this.dbAccess.getAllItems();
    }

    @Override
    public String[] getCompNames() {
        return this.dbAccess.getComponentNames();
    }

    @Override
    public ConfigItem getItem(String compName, String node, String key) {
        return this.dbAccess.getItem(compName, node, key);
    }

    @Override
    public Set<ConfigItem> getItemsForComponent(String compName) {
        return this.dbAccess.getCompItems(compName);
    }

    @Override
    public String[] getKeys(String compName, String node) {
        return this.dbAccess.getKeys(compName, node);
    }

    @Override
    public void initRepository(String repo_uri, Map<String, String> params) throws DBInitException {
        String config_db_uri = System.getProperty(CONFIG_REPO_URI_PROP_KEY);
        if (config_db_uri == null) {
            config_db_uri = params.get(CONFIG_REPO_URI_INIT_KEY);
        }
        if (config_db_uri == null) {
            config_db_uri = params.get("--user-db-uri");
        }
        if (config_db_uri == null) {
            log.severe("Missing configuration database connection string.");
            log.severe("Tigase needs a database connection string to load configuration.");
            log.severe("You can provide it in a few ways and the Tigase server checks");
            log.severe("following parameters in the order below:");
            log.severe("1. System property: -Dtigase-config-repo-uri=db-connection-string");
            log.severe("2. init.properties file or command line parameter: --tigase-config-repo-uri=db-connection-string");
            log.severe("3. init.properties file or command line parameter: --user-db-uri=db-connection-string");
            log.severe("Please correct the error and restart the server.");
            System.exit(1);
        }
        try {
            this.dbAccess.initRepository(config_db_uri, null);
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, "Problem connecting to configuration database: ", ex);
            log.severe("Please check whether the database connection string is correct: " + config_db_uri);
            System.exit(1);
        }
    }

    @Override
    public void removeItem(String compName, ConfigItem item) {
        this.dbAccess.removeItem(item);
    }

    @Override
    public int size() {
        return this.dbAccess.getPropertiesCount();
    }

    private class JDBCAccess {
        public static final String TABLE_NAME = "tigase_configuration";
        private static final String CLUSTER_NODE_COLUMN = "cluster_node";
        private static final String COMPONENT_NAME_COLUMN = "component_name";
        private static final String NODE_NAME_COLUMN = "key_node";
        private static final String KEY_NAME_COLUMN = "key_name";
        private static final String VALUE_COLUMN = "value";
        private static final String FLAG_COLUMN = "flag";
        private static final String VALUE_TYPE_COLUMN = "value_type";
        private static final String LAST_UPDATE_COLUMN = "last_update";
        private static final String CREATE_TABLE_QUERY = "create table tigase_configuration (  component_name varchar(127) NOT NULL,  key_name varchar(127) NOT NULL,  value varchar(8191) NOT NULL,  cluster_node varchar(255) NOT NULL DEFAULT '',  key_node varchar(127) NOT NULL DEFAULT '',  flag varchar(32) NOT NULL DEFAULT 'DEFAULT',  value_type varchar(8) NOT NULL DEFAULT 'S',  last_update timestamp,  primary key(cluster_node, component_name, key_node, key_name, flag))";
        private static final String CLUSTER_NODE_WHERE_PART = " (cluster_node = ''  OR cluster_node = ?) ";
        private static final String ITEM_WHERE_PART = " where  (cluster_node = ''  OR cluster_node = ?)  AND (component_name = ?)  AND (key_node = ?)  AND (key_name = ?) ";
        private static final String GET_ITEM_QUERY = "select * from tigase_configuration where  (cluster_node = ''  OR cluster_node = ?)  AND (component_name = ?)  AND (key_node = ?)  AND (key_name = ?) ";
        private static final String ADD_ITEM_QUERY = "insert into tigase_configuration (cluster_node, component_name, key_node, key_name, value, value_type, flag)  values (?, ?, ?, ?, ?, ?, ?)";
        private static final String UPDATE_ITEM_QUERY = "update tigase_configuration set value = ?  where (cluster_node = ?)  AND (component_name = ?)  AND (key_node = ?)  AND (key_name = ?)";
        private static final String DELETE_ITEM_QUERY = "delete from tigase_configuration where  (cluster_node = ''  OR cluster_node = ?)  AND (component_name = ?)  AND (key_node = ?)  AND (key_name = ?) ";
        private static final String GET_ALL_ITEMS_QUERY = "select * from tigase_configuration where  (cluster_node = ''  OR cluster_node = ?) ";
        private static final String GET_COMPONENT_ITEMS_QUERY = "select * from tigase_configuration where  (cluster_node = ''  OR cluster_node = ?)  AND (component_name = ?)";
        private static final String GET_UPDATED_ITEMS_QUERY = "select * from tigase_configuration where  (cluster_node = ''  OR cluster_node = ?)  AND (flag <> 'INITIAL') AND (last_update > ?)";
        private static final String GET_COMPONENT_NAMES_QUERY = "select distinct(component_name) from tigase_configuration where cluster_node";
        private static final String GET_PROPERTIES_COUNT_QUERY = "select count(*) as count from tigase_configuration where cluster_node";
        private static final String GET_KEYS_QUERY = "select key_name from tigase_configuration where  (cluster_node = ''  OR cluster_node = ?)  AND (component_name = ?) AND (key_node = ?)";
        private DataRepository data_repo = null;

        private JDBCAccess() {
        }

        public void initRepository(String conn_str, Map<String, String> params) throws SQLException {
            try {
                this.data_repo = RepositoryFactory.getDataRepository(null, conn_str, params);
                this.checkDB();
                this.data_repo.initPreparedStatement(GET_ITEM_QUERY, GET_ITEM_QUERY);
                this.data_repo.initPreparedStatement(GET_ALL_ITEMS_QUERY, GET_ALL_ITEMS_QUERY);
                this.data_repo.initPreparedStatement(GET_COMPONENT_ITEMS_QUERY, GET_COMPONENT_ITEMS_QUERY);
                this.data_repo.initPreparedStatement(ADD_ITEM_QUERY, ADD_ITEM_QUERY);
                this.data_repo.initPreparedStatement(UPDATE_ITEM_QUERY, UPDATE_ITEM_QUERY);
                this.data_repo.initPreparedStatement(DELETE_ITEM_QUERY, DELETE_ITEM_QUERY);
                this.data_repo.initPreparedStatement(GET_UPDATED_ITEMS_QUERY, GET_UPDATED_ITEMS_QUERY);
                this.data_repo.initPreparedStatement(GET_COMPONENT_NAMES_QUERY, GET_COMPONENT_NAMES_QUERY);
                this.data_repo.initPreparedStatement(GET_PROPERTIES_COUNT_QUERY, GET_PROPERTIES_COUNT_QUERY);
                this.data_repo.initPreparedStatement(GET_KEYS_QUERY, GET_KEYS_QUERY);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addItem(ConfigItem item) {
            try {
                PreparedStatement addItemSt;
                PreparedStatement preparedStatement = addItemSt = this.data_repo.getPreparedStatement(null, ADD_ITEM_QUERY);
                synchronized (preparedStatement) {
                    addItemSt.setString(1, item.getClusterNode() != null ? item.getClusterNode() : "");
                    addItemSt.setString(2, item.getCompName());
                    addItemSt.setString(3, item.getNodeName() != null ? item.getNodeName() : "");
                    addItemSt.setString(4, item.getKeyName());
                    addItemSt.setString(5, item.getConfigValToString());
                    addItemSt.setString(6, "" + DataTypes.getTypeId(item.getConfigVal()));
                    addItemSt.setString(7, item.getFlag().name());
                    addItemSt.executeUpdate();
                }
            }
            catch (SQLException e) {
                try {
                    PreparedStatement updateItemSt;
                    PreparedStatement preparedStatement = updateItemSt = this.data_repo.getPreparedStatement(null, UPDATE_ITEM_QUERY);
                    synchronized (preparedStatement) {
                        updateItemSt.setString(1, item.getConfigValToString());
                        updateItemSt.setString(2, item.getClusterNode() != null ? item.getClusterNode() : "");
                        updateItemSt.setString(3, item.getCompName());
                        updateItemSt.setString(4, item.getNodeName() != null ? item.getNodeName() : "");
                        updateItemSt.setString(5, item.getKeyName());
                        updateItemSt.executeUpdate();
                    }
                }
                catch (SQLException ex) {
                    log.log(Level.WARNING, "Problem adding/updating an item to DB: " + item.toElement() + "\n", ex);
                }
            }
            catch (Exception e) {
                log.warning(e + "Exception while adding config item: " + item.toString());
            }
        }

        private void checkDB() throws SQLException {
            Object rs = null;
            Statement st = null;
            try {
                if (!this.data_repo.checkTable(TABLE_NAME)) {
                    st = this.data_repo.createStatement(null);
                    st.executeUpdate(CREATE_TABLE_QUERY);
                } else {
                    log.info("DB for server configuration OK.");
                }
                this.data_repo.release(st, rs);
                rs = null;
                st = null;
            }
            catch (Throwable throwable) {
                this.data_repo.release(st, rs);
                rs = null;
                st = null;
                throw throwable;
            }
        }

        private ConfigItem createItemFromRS(ResultSet rs) throws SQLException {
            ConfigItem result = ConfigSQLRepository.this.getItemInstance();
            String clusterNode = rs.getString(CLUSTER_NODE_COLUMN);
            String compName = rs.getString(COMPONENT_NAME_COLUMN);
            String nodeName = rs.getString(NODE_NAME_COLUMN);
            String keyName = rs.getString(KEY_NAME_COLUMN);
            String value_str = rs.getString(VALUE_COLUMN);
            String value_type = rs.getString(VALUE_TYPE_COLUMN);
            String flag_str = rs.getString(FLAG_COLUMN);
            result.set(clusterNode, compName, nodeName, keyName, value_str, value_type.charAt(0), flag_str);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<ConfigItem> getAllItems() {
            ArrayList<ConfigItem> result = new ArrayList<ConfigItem>();
            try {
                PreparedStatement getAllItemsSt;
                ResultSet rs = null;
                PreparedStatement preparedStatement = getAllItemsSt = this.data_repo.getPreparedStatement(null, GET_ALL_ITEMS_QUERY);
                synchronized (preparedStatement) {
                    try {
                        getAllItemsSt.setString(1, ConfigSQLRepository.this.getDefHostname());
                        rs = getAllItemsSt.executeQuery();
                        while (rs.next()) {
                            ConfigItem item = this.createItemFromRS(rs);
                            if (item.getFlag() == ConfigItem.FLAGS.INITIAL) continue;
                            result.add(item);
                        }
                        this.data_repo.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                }
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting elements from DB: ", e);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<ConfigItem> getCompItems(String compName) {
            LinkedHashSet<ConfigItem> result = new LinkedHashSet<ConfigItem>();
            try {
                PreparedStatement getCompItemsSt;
                ResultSet rs = null;
                PreparedStatement preparedStatement = getCompItemsSt = this.data_repo.getPreparedStatement(null, GET_COMPONENT_ITEMS_QUERY);
                synchronized (preparedStatement) {
                    try {
                        getCompItemsSt.setString(1, ConfigSQLRepository.this.getDefHostname());
                        getCompItemsSt.setString(2, compName);
                        rs = getCompItemsSt.executeQuery();
                        while (rs.next()) {
                            ConfigItem item = this.createItemFromRS(rs);
                            if (item.getFlag() == ConfigItem.FLAGS.INITIAL) continue;
                            result.add(item);
                        }
                        this.data_repo.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                }
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting elements from DB: ", e);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] getComponentNames() {
            ArrayList<String> result = new ArrayList<String>();
            try {
                PreparedStatement getCompNamesSt;
                ResultSet rs = null;
                PreparedStatement preparedStatement = getCompNamesSt = this.data_repo.getPreparedStatement(null, GET_COMPONENT_NAMES_QUERY);
                synchronized (preparedStatement) {
                    try {
                        getCompNamesSt.setString(1, ConfigSQLRepository.this.getDefHostname());
                        rs = getCompNamesSt.executeQuery();
                        while (rs.next()) {
                            result.add(rs.getString(COMPONENT_NAME_COLUMN));
                        }
                        this.data_repo.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                }
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting component names from DB: ", e);
            }
            return result.toArray(new String[result.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ConfigItem getItem(String compName, String node, String key) {
            ConfigItem result = null;
            try {
                PreparedStatement getItemSt;
                ResultSet rs = null;
                PreparedStatement preparedStatement = getItemSt = this.data_repo.getPreparedStatement(null, GET_ITEM_QUERY);
                synchronized (preparedStatement) {
                    try {
                        getItemSt.setString(1, ConfigSQLRepository.this.getDefHostname());
                        getItemSt.setString(2, compName);
                        getItemSt.setString(3, node);
                        getItemSt.setString(4, key);
                        rs = getItemSt.executeQuery();
                        while (rs.next()) {
                            ConfigItem item = this.createItemFromRS(rs);
                            if (item.getFlag() == ConfigItem.FLAGS.INITIAL) continue;
                            result = item;
                            break;
                        }
                        this.data_repo.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                }
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting elements from DB: ", e);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] getKeys(String compName, String node) {
            ArrayList<String> result = new ArrayList<String>();
            try {
                PreparedStatement getKeysSt;
                ResultSet rs = null;
                PreparedStatement preparedStatement = getKeysSt = this.data_repo.getPreparedStatement(null, GET_KEYS_QUERY);
                synchronized (preparedStatement) {
                    try {
                        getKeysSt.setString(1, ConfigSQLRepository.this.getDefHostname());
                        getKeysSt.setString(2, compName);
                        getKeysSt.setString(3, node);
                        rs = getKeysSt.executeQuery();
                        while (rs.next()) {
                            result.add(rs.getString(KEY_NAME_COLUMN));
                        }
                        this.data_repo.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                }
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting keys from DB: ", e);
            }
            return result.toArray(new String[result.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getPropertiesCount() {
            int result = 0;
            try {
                PreparedStatement getPropertiesCountSt;
                ResultSet rs = null;
                PreparedStatement preparedStatement = getPropertiesCountSt = this.data_repo.getPreparedStatement(null, GET_PROPERTIES_COUNT_QUERY);
                synchronized (preparedStatement) {
                    try {
                        getPropertiesCountSt.setString(1, ConfigSQLRepository.this.getDefHostname());
                        rs = getPropertiesCountSt.executeQuery();
                        while (rs.next()) {
                            result = rs.getInt("count");
                        }
                        this.data_repo.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                }
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting elements count from DB: ", e);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeItem(ConfigItem item) {
            try {
                PreparedStatement deleteItemSt;
                PreparedStatement preparedStatement = deleteItemSt = this.data_repo.getPreparedStatement(null, DELETE_ITEM_QUERY);
                synchronized (preparedStatement) {
                    deleteItemSt.setString(1, item.getClusterNode() != null ? item.getClusterNode() : "");
                    deleteItemSt.setString(2, item.getCompName());
                    deleteItemSt.setString(3, item.getNodeName() != null ? item.getNodeName() : "");
                    deleteItemSt.setString(4, item.getKeyName());
                    deleteItemSt.executeUpdate();
                }
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem removing an item from DB: " + item.toElement(), e);
            }
        }
    }
}

