/*
 * Decompiled with CFR 0.152.
 */
package tigase.component.modules.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocCommandManager;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.AbstractModule;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

@Bean(name="commands", active=true)
public class AdHocCommandModule
extends AbstractModule
implements Initializable {
    public static final String ID = "commands";
    public static final String XMLNS = "http://jabber.org/protocol/commands";
    protected static final String[] COMMAND_PATH = new String[]{"iq", "command"};
    protected static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"command", (String)"http://jabber.org/protocol/commands"));
    @Inject(nullAllowed=false)
    protected AdHocCommandManager commandsManager = new AdHocCommandManager();
    @Inject(nullAllowed=false)
    protected ScriptCommandProcessor scriptProcessor;

    public List<Element> getCommandListItems(JID senderJid, JID toJid) {
        ArrayList<Element> commandsList = new ArrayList<Element>();
        this.addCommandListItemsElements(XMLNS, toJid, senderJid, commandsList::add);
        return commandsList;
    }

    public AdHocCommandManager getCommandsManager() {
        return this.commandsManager;
    }

    public void setCommandsManager(AdHocCommandManager commandsManager) {
        this.commandsManager = commandsManager;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{XMLNS};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public List<Element> getScriptItems(String node, JID stanzaTo, JID stanzaFrom) {
        ArrayList<Element> result = new ArrayList<Element>();
        this.addCommandListItemsElements(node, stanzaTo, stanzaFrom, result::add);
        return result;
    }

    public void addCommandListItemsElements(String node, JID stanzaTo, JID stanzaFrom, Consumer<Element> collector) {
        for (AdHocCommand c : this.commandsManager.getAllCommands()) {
            if (!c.isAllowedFor(stanzaFrom)) continue;
            Element i = new Element("item", new String[]{"jid", "node", "name"}, new String[]{stanzaTo.toString(), c.getNode(), c.getName()});
            c.getGroup().ifPresent(group -> i.setAttribute("group", group));
            collector.accept(i);
        }
        List<Element> scripts = this.scriptProcessor.getScriptItems(node, stanzaTo, stanzaFrom);
        if (scripts != null) {
            scripts.forEach(collector);
        }
    }

    public ScriptCommandProcessor getScriptProcessor() {
        return this.scriptProcessor;
    }

    public void setScriptProcessor(ScriptCommandProcessor scriptProcessor) {
        this.scriptProcessor = scriptProcessor;
    }

    @Override
    public void initialize() {
        if (this.scriptProcessor == null) {
            throw new RuntimeException("scriptProcessor cannot be null!");
        }
    }

    @Override
    public void process(Packet packet) throws ComponentException {
        String node = packet.getAttributeStaticStr(COMMAND_PATH, "node");
        if (this.commandsManager.hasCommand(node)) {
            try {
                this.commandsManager.process(packet, this.writer::write);
            }
            catch (AdHocCommandException e) {
                throw new ComponentException(e.getErrorCondition(), e.getMessage());
            }
        } else {
            this.processScriptAdHoc(packet);
        }
    }

    public void register(AdHocCommand command2) {
        this.commandsManager.registerCommand(command2);
    }

    protected void processScriptAdHoc(Packet packet) {
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        if (this.scriptProcessor.processScriptCommand(packet, results)) {
            for (Packet p : results) {
                this.write(p);
            }
        }
    }

    public static interface ScriptCommandProcessor {
        public List<Element> getScriptItems(String var1, JID var2, JID var3);

        public boolean processScriptCommand(Packet var1, Queue<Packet> var2);

        public boolean isAllowed(String var1, JID var2);

        public boolean isAllowed(String var1, String var2, JID var3);
    }
}

