/*
 * Decompiled with CFR 0.152.
 */
package tigase.component;

import java.time.Duration;
import java.util.Collection;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.server.AbstractMessageReceiver;
import tigase.util.common.TimerTask;

public abstract class ScheduledTask
extends TimerTask
implements ConfigurationChangedAware,
Initializable,
UnregisterAware {
    @Inject(bean="service")
    protected AbstractMessageReceiver component;
    @ConfigField(desc="Delay", alias="delay")
    private Duration delay;
    @ConfigField(desc="Execution period", alias="period")
    private Duration period;

    public ScheduledTask(Duration delay, Duration period) {
        this.period = period;
        this.delay = delay;
    }

    @Override
    public void beanConfigurationChanged(Collection<String> changedFields) {
        if (changedFields.contains("period") || changedFields.contains("delay")) {
            this.reset(true);
            this.initialize();
        }
    }

    @Override
    public void initialize() {
        if (this.component == null || !this.component.isInitializationComplete()) {
            return;
        }
        if (this.delay == null && this.period == null) {
            return;
        }
        if (this.delay != null && this.delay.isZero() && this.period != null && this.period.isZero()) {
            return;
        }
        if (this.delay != null) {
            if (this.period != null) {
                this.component.addTimerTask((TimerTask)this, this.delay.toMillis(), this.period.toMillis());
            } else {
                this.component.addTimerTask(this, this.delay.toMillis());
            }
        }
    }

    @Override
    public void beforeUnregister() {
        this.cancel();
    }
}

