/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.credentials.entries;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import tigase.auth.CredentialsDecoderBean;
import tigase.auth.CredentialsEncoderBean;
import tigase.auth.credentials.Credentials;
import tigase.auth.credentials.entries.PlainCredentialsEntry;
import tigase.auth.credentials.entries.ScramCredentialsEntry;
import tigase.kernel.beans.Bean;

public class ScramSha1CredentialsEntry
extends ScramCredentialsEntry {
    private static final String ALGORITHM = "SHA1";

    public ScramSha1CredentialsEntry(PlainCredentialsEntry entry) throws NoSuchAlgorithmException, InvalidKeyException {
        super("SHA-1", entry);
    }

    public ScramSha1CredentialsEntry(byte[] salt, int iterations, byte[] saltedPassword) {
        super("SHA-1", salt, iterations, saltedPassword);
    }

    @Bean(name="SCRAM-SHA-1", parent=CredentialsEncoderBean.class, active=true)
    public static class Encoder
    extends ScramCredentialsEntry.Encoder {
        public Encoder() {
            super(ScramSha1CredentialsEntry.ALGORITHM);
        }
    }

    @Bean(name="SCRAM-SHA-1", parent=CredentialsDecoderBean.class, active=true)
    public static class Decoder
    extends ScramCredentialsEntry.Decoder {
        public Decoder() {
            super(ScramSha1CredentialsEntry.ALGORITHM);
        }

        @Override
        protected Credentials.Entry newInstance(byte[] salt, int iterations, byte[] saltedPassword) {
            return new ScramSha1CredentialsEntry(salt, iterations, saltedPassword);
        }
    }
}

