/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;

public class JceTlsSecret
extends AbstractTlsSecret {
    private final JcaTlsCrypto crypto;

    public JceTlsSecret(JcaTlsCrypto jcaTlsCrypto, byte[] byArray) {
        super(byArray);
        this.crypto = jcaTlsCrypto;
    }

    public synchronized TlsSecret deriveSSLKeyBlock(byte[] byArray, int n) {
        this.checkAlive();
        try {
            int n2 = (n + 16 - 1) / 16;
            byte[] byArray2 = this.prf_SSL(byArray, n2);
            JceTlsSecret jceTlsSecret = this.crypto.adoptLocalSecret(Arrays.copyOfRange((byte[])byArray2, (int)0, (int)n));
            Arrays.fill((byte[])byArray2, (byte)0);
            return jceTlsSecret;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException();
        }
    }

    public synchronized TlsSecret deriveSSLMasterSecret(byte[] byArray) {
        this.checkAlive();
        try {
            return this.crypto.adoptLocalSecret(this.prf_SSL(byArray, 3));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException();
        }
    }

    public synchronized TlsSecret deriveUsingPRF(int n, byte[] byArray, int n2) {
        this.checkAlive();
        try {
            byte[] byArray2 = n == 0 ? this.prf_1_0(this.data, byArray, n2) : this.prf_1_2(this.crypto.getDigestName(TlsUtils.getHashAlgorithmForPRFAlgorithm(n)), this.data, byArray, n2);
            return this.crypto.adoptLocalSecret(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException();
        }
    }

    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected void hmacHash(String string, byte[] byArray, byte[] byArray2, byte[] byArray3) throws GeneralSecurityException {
        String string2 = "Hmac" + string;
        Mac mac = this.crypto.getHelper().createMac(string2);
        mac.init(new SecretKeySpec(byArray, string2));
        byte[] byArray4 = byArray2;
        int n = mac.getMacLength();
        int n2 = (byArray3.length + n - 1) / n;
        byte[] byArray5 = new byte[mac.getMacLength()];
        byte[] byArray6 = new byte[mac.getMacLength()];
        for (int i = 0; i < n2; ++i) {
            mac.update(byArray4, 0, byArray4.length);
            mac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            mac.update(byArray4, 0, byArray4.length);
            mac.update(byArray2, 0, byArray2.length);
            mac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, n * i, Math.min(n, byArray3.length - n * i));
        }
    }

    protected byte[] prf_SSL(byte[] byArray, int n) throws GeneralSecurityException {
        MessageDigest messageDigest = this.crypto.getHelper().createDigest("MD5");
        MessageDigest messageDigest2 = this.crypto.getHelper().createDigest("SHA-1");
        int n2 = messageDigest.getDigestLength();
        byte[] byArray2 = new byte[n2 * n];
        int n3 = 0;
        byte[] byArray3 = new byte[messageDigest2.getDigestLength()];
        for (int i = 0; i < n; ++i) {
            byte[] byArray4 = SSL3_CONST[i];
            messageDigest2.update(byArray4, 0, byArray4.length);
            messageDigest2.update(this.data, 0, this.data.length);
            messageDigest2.update(byArray, 0, byArray.length);
            messageDigest2.digest(byArray3, 0, byArray3.length);
            messageDigest.update(this.data, 0, this.data.length);
            messageDigest.update(byArray3, 0, byArray3.length);
            messageDigest.digest(byArray2, n3, n2);
            n3 += n2;
        }
        return byArray2;
    }

    protected byte[] prf_1_0(byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException {
        int n2 = (byArray.length + 1) / 2;
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        System.arraycopy(byArray, byArray.length - n2, byArray4, 0, n2);
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n];
        this.hmacHash("MD5", byArray3, byArray2, byArray5);
        this.hmacHash("SHA1", byArray4, byArray2, byArray6);
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            byArray5[n3] = (byte)(byArray5[n3] ^ byArray6[i]);
        }
        return byArray5;
    }

    protected byte[] prf_1_2(String string, byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException {
        byte[] byArray3 = new byte[n];
        this.hmacHash(string.replace("-", ""), byArray, byArray2, byArray3);
        return byArray3;
    }
}

