/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDHDomain;

public class JceTlsDH
implements TlsAgreement {
    protected JceTlsDHDomain domain;
    protected KeyPair localKeyPair;
    protected DHPublicKey peerPublicKey;

    public JceTlsDH(JceTlsDHDomain jceTlsDHDomain) {
        this.domain = jceTlsDHDomain;
    }

    public byte[] generateEphemeral() throws IOException {
        this.localKeyPair = this.domain.generateKeyPair();
        return this.domain.encodePublicKey((DHPublicKey)this.localKeyPair.getPublic());
    }

    public void receivePeerValue(byte[] byArray) throws IOException {
        this.peerPublicKey = this.domain.decodePublicKey(byArray);
    }

    public TlsSecret calculateSecret() throws IOException {
        try {
            byte[] byArray = this.domain.calculateDHAgreement(this.peerPublicKey, (DHPrivateKey)this.localKeyPair.getPrivate());
            return this.domain.getCrypto().adoptLocalSecret(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("cannot calculate secret", generalSecurityException);
        }
    }
}

