/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.eventbus;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import tigase.jaxmpp.core.client.eventbus.DefaultEventBus;
import tigase.jaxmpp.core.client.eventbus.Event;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.eventbus.EventListener;
import tigase.jaxmpp.core.client.eventbus.JaxmppEventWithCallback;

public class ThreadSafeEventBus
extends DefaultEventBus {
    private static int threadCounter = 1;
    private final Executor executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("EventBus-Thread-" + ++threadCounter);
            t.setDaemon(true);
            return t;
        }
    });

    protected List<EventHandler> createHandlersArray() {
        return new ArrayList<EventHandler>();
    }

    protected Map<Object, Map<Class<? extends Event<?>>, List<EventHandler>>> createMainHandlersMap() {
        return new ConcurrentHashMap();
    }

    protected Map<Class<? extends Event<?>>, List<EventHandler>> createTypeHandlersMap() {
        return new ConcurrentHashMap();
    }

    protected void doFire(final Event<EventHandler> event, ArrayList<EventHandler> handlers) {
        final AtomicInteger counter = event instanceof JaxmppEventWithCallback ? new AtomicInteger(handlers.size() + 1) : null;
        for (final EventHandler eventHandler : handlers) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        ThreadSafeEventBus.this.log.finest("Calling handler class " + eventHandler.getClass() + " with event " + event.getClass());
                        if (eventHandler instanceof EventListener) {
                            ((EventListener)eventHandler).onEvent(event);
                        } else {
                            event.dispatch(eventHandler);
                        }
                    }
                    catch (Throwable e) {
                        if (ThreadSafeEventBus.this.log.isLoggable(Level.WARNING)) {
                            ThreadSafeEventBus.this.log.log(Level.WARNING, "", e);
                        }
                    }
                    finally {
                        ThreadSafeEventBus.this.doFireEventRunAfter(counter, (Event<EventHandler>)event);
                    }
                }
            };
            this.executor.execute(r);
        }
        this.doFireEventRunAfter(counter, event);
    }

    protected void doFireEventRunAfter(AtomicInteger counter, final Event<EventHandler> event) {
        JaxmppEventWithCallback.RunAfter run;
        if (counter != null && counter.decrementAndGet() == 0 && (run = ((JaxmppEventWithCallback)event).getRunAfter()) != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    run.after((Object)event);
                }
            });
        }
    }
}

