/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster.commands;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.cluster.ClusteredNodeStrategy;
import tigase.pubsub.cluster.PresenceCollectorRepositoryClustered;
import tigase.pubsub.repository.PresenceCollectorRepository;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.JID;

@Bean(name="request-caps-sync", parent=ClusteredNodeStrategy.class, active=true)
public class RequestCapsSyncCommand
extends CommandListenerAbstract {
    public static final String REQUEST_CAPS_SYNC_CMD = "request-caps-sync";
    private static final int a = 500;
    @Inject(nullAllowed=true)
    private PresenceCollectorRepositoryClustered presenceCollectorRepository;
    @Inject
    private ClusteredNodeStrategy strategy;

    public RequestCapsSyncCommand() {
        super(REQUEST_CAPS_SYNC_CMD, Priority.HIGH);
    }

    public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
        LinkedList<Object> linkedList = new LinkedList<Element>();
        Element element = null;
        int n = 0;
        for (PresenceCollectorRepository.ServiceEntry serviceEntry : this.presenceCollectorRepository.getServiceEntries()) {
            for (PresenceCollectorRepository.UserEntry userEntry : serviceEntry.getUserEntries()) {
                if (element == null || !element.getAttributeStaticStr("jid").equals(serviceEntry.getServiceJid().toString())) {
                    element = new Element("service").withAttribute("jid", serviceEntry.getServiceJid().toString());
                    linkedList.add(element);
                }
                Element element2 = new Element("item").withAttribute("jid", userEntry.getJid().toString());
                element2.addChildren(userEntry.mapEntries(userResourceEntry -> {
                    Element element = new Element("resource");
                    if (userResourceEntry.getResource() != null) {
                        element.withAttribute("name", userResourceEntry.getResource());
                    }
                    if (userResourceEntry.getCaps() != null) {
                        element.addChild((XMLNodeIfc)new Element("caps").withAttribute("node", userResourceEntry.getCaps()));
                    }
                    return element;
                }, userResourceEntry -> true));
                element.addChild((XMLNodeIfc)element2);
                if (++n < 500) continue;
                this.strategy.sendToNodes("response-caps-sync", linkedList, fromNode);
                linkedList = new LinkedList();
                element = null;
                n = 0;
            }
        }
        if (!linkedList.isEmpty()) {
            this.strategy.sendToNodes("response-caps-sync", linkedList, fromNode);
        }
    }
}

