/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster.commands;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.component.exceptions.RepositoryException;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.Affiliation;
import tigase.pubsub.Subscription;
import tigase.pubsub.cluster.AbstractStrategy;
import tigase.pubsub.cluster.IPubSubRepositoryClustered;
import tigase.pubsub.cluster.NotificationBroadcasterClustered;
import tigase.pubsub.cluster.PresenceCollectorRepositoryClustered;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.repository.cached.IAffiliationsCached;
import tigase.pubsub.repository.cached.ISubscriptionsCached;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.pubsub.utils.executors.Executor;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="nodesChangedCmd", parent=AbstractStrategy.class, active=true)
public class NodesChangedCommand
extends CommandListenerAbstract {
    public static final String CAPS_CHANGED = "caps-changed-cmd";
    public static final String CAPS_REMOVED = "caps-removed-cmd";
    public static final String NODES_CHANGED_CMD = "nodes-changed-cmd";
    public static final String USER_REMOVED = "user-removed";
    public static final String CHILD_NODE_ADDED = "child-node-added";
    public static final String CHILD_NODE_REMOVED = "child-node-removed";
    public static final String ROOT_NODE_ADDED = "root-node-added";
    public static final String ROOT_NODE_REMOVED = "root-node-removed";
    public static final String NODE_CONFIG_CHANGED = "node-config-changed";
    public static final String NODE_AFFILIATION_CHANGED = "node-affiliation-changed";
    public static final String NODE_SUBSCRIPTION_CHANGED = "node-subscription-changed";
    public static final String BROADCAST_NOTIFICATION = "broadcast-notification";
    @Deprecated
    public static final String NODE_ITEM_PUBLISHED = "item-published";
    @Deprecated
    public static final String NODE_ITEM_RETRACTED = "item-retracted";
    private static final Logger a = Logger.getLogger(NodesChangedCommand.class.getCanonicalName());
    @Inject
    private NotificationBroadcasterClustered notificationBroadcaster;
    @Inject
    private IPubSubRepositoryClustered repo;
    @Inject
    private StrategyIfc strategy;
    @Inject
    private PresenceCollectorRepositoryClustered presenceCollectorRepository;

    public NodesChangedCommand() {
        super(NODES_CHANGED_CMD, Priority.HIGH);
    }

    public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
        Element element;
        while ((element = packets.poll()) != null) {
            try {
                BareJID bareJID = BareJID.bareJIDInstanceNS((String)element.getAttributeStaticStr("service-jid"));
                String string = element.getAttributeStaticStr("node");
                this.executeAction(bareJID, string, element.getName(), element);
            }
            catch (RepositoryException repositoryException) {
                a.log(Level.WARNING, "execution of command nodes-changed-cmd for " + element + " failed", repositoryException);
            }
        }
    }

    protected void executeAction(BareJID serviceJid, String nodeName, String action, Element elem) throws RepositoryException {
        switch (action) {
            case "caps-changed-cmd": {
                JID jID = JID.jidInstanceNS((String)elem.getAttributeStaticStr("jid"));
                List list = elem.mapChildren(element -> element.getName() == "item", element -> element.getAttributeStaticStr("node"));
                this.presenceCollectorRepository.addNoEvent(serviceJid, jID, list == null || list.isEmpty() ? null : (String)list.get(0));
            }
            case "caps-removed-cmd": {
                JID jID = JID.jidInstanceNS((String)elem.getAttributeStaticStr("jid"));
                this.presenceCollectorRepository.removeNoEvent(serviceJid, jID);
                break;
            }
            case "child-node-added": {
                Node node = this.repo.getNodeFromCache(serviceJid, nodeName);
                if (node != null) {
                    node.childNodeAdded(elem.getAttributeStaticStr("child"));
                }
                this.repo.nodeAdded(serviceJid, nodeName);
                break;
            }
            case "child-node-removed": {
                Node node = this.repo.getNodeFromCache(serviceJid, nodeName);
                if (node != null) {
                    node.childNodeRemoved(elem.getAttributeStaticStr("child"));
                }
                this.repo.nodeRemoved(serviceJid, nodeName);
                break;
            }
            case "root-node-added": {
                this.repo.getRootCollectionSet(serviceJid).add(nodeName);
                this.repo.nodeAdded(serviceJid, nodeName);
                break;
            }
            case "root-node-removed": {
                this.repo.getRootCollectionSet(serviceJid).remove(nodeName);
                this.repo.nodeRemoved(serviceJid, nodeName);
                break;
            }
            case "node-config-changed": {
                Element element2 = elem.getChild("x", "jabber:x:data");
                this.repo.updateNodeConfiguration(serviceJid, nodeName, element2 == null ? null : new Form(element2));
                break;
            }
            case "node-affiliation-changed": {
                Node node = this.repo.getNodeFromCache(serviceJid, nodeName);
                if (node == null) break;
                BareJID bareJID = BareJID.bareJIDInstanceNS((String)elem.getAttributeStaticStr("jid"));
                Affiliation affiliation = Affiliation.valueOf((String)elem.getAttributeStaticStr("aff"));
                IAffiliationsCached iAffiliationsCached = node.getNodeAffiliations();
                iAffiliationsCached.changeAffiliation(bareJID, affiliation);
                iAffiliationsCached.merge();
                break;
            }
            case "node-subscription-changed": {
                Node node = this.repo.getNodeFromCache(serviceJid, nodeName);
                if (node == null) break;
                BareJID bareJID = BareJID.bareJIDInstanceNS((String)elem.getAttributeStaticStr("jid"));
                Subscription subscription = Subscription.valueOf((String)elem.getAttributeStaticStr("sub"));
                String string = elem.getAttributeStaticStr("id");
                ISubscriptionsCached iSubscriptionsCached = node.getNodeSubscriptions();
                iSubscriptionsCached.changeSubscription(new UsersSubscription(bareJID, string, subscription));
                iSubscriptionsCached.merge();
                break;
            }
            case "broadcast-notification": {
                if (!this.strategy.isLocalNode(serviceJid, nodeName)) break;
                Executor.Priority priority = Executor.Priority.valueof((String)elem.getAttributeStaticStr("priority"));
                this.notificationBroadcaster.broadcastNotificationLocally(priority, serviceJid, nodeName, elem.getChild("message"));
                break;
            }
            case "item-published": 
            case "item-retracted": {
                break;
            }
            case "user-removed": {
                this.repo.serviceRemoved(serviceJid);
                break;
            }
            default: {
                a.log(Level.FINER, "received unknown action: {0} as {1}", new Object[]{elem.getName(), elem});
            }
        }
    }
}

