/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import tigase.cluster.SessionManagerClustered;
import tigase.cluster.strategy.ConnectionRecordIfc;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.repository.PresenceCollectorRepository;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@ClusterModeRequired(active=true)
@Bean(name="presenceRepository", parent=PubSubComponent.class, active=true)
public class PresenceCollectorRepositoryClustered
extends PresenceCollectorRepository {
    @Inject(nullAllowed=true)
    private StrategyIfc strategy;
    @Inject
    private SessionManagerClustered sessionManager;

    public String add(BareJID serviceJid, JID jid, String caps) {
        this.strategy.presenceCapsChanged(serviceJid, jid, caps);
        return super.add(serviceJid, jid, caps);
    }

    public String addNoEvent(BareJID serviceJid, JID jid, String caps) {
        return super.add(serviceJid, jid, caps);
    }

    public boolean remove(BareJID serviceJid, JID jid) {
        this.strategy.presenceCapsRemoved(serviceJid, jid);
        return super.remove(serviceJid, jid);
    }

    public boolean removeNoEvent(BareJID serviceJid, JID jid) {
        return super.remove(serviceJid, jid);
    }

    public void nodeDisconnected(JID nodeJID) {
        for (PresenceCollectorRepository.ServiceEntry serviceEntry : super.getServiceEntries()) {
            for (PresenceCollectorRepository.UserEntry userEntry : serviceEntry.getUserEntries()) {
                if (!this.sessionManager.isLocalDomain(userEntry.getJid().getDomain())) continue;
                userEntry.userResourceEntriesStream().map(PresenceCollectorRepository.UserResourceEntry::getJid).filter(jID2 -> {
                    ConnectionRecordIfc connectionRecordIfc = this.sessionManager.getStrategy().getConnectionRecord(jID2);
                    return connectionRecordIfc == null || connectionRecordIfc.getNode().getDomain().equals(nodeJID.getDomain());
                }).forEach(jID -> this.remove(userEntry.getServiceJid(), (JID)jID));
            }
        }
    }
}

