/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.List;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.CommandListener;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.beans.selector.ServerBeanSelector;
import tigase.kernel.core.Kernel;
import tigase.licence.LicenceChecker;
import tigase.muc.MUCComponent;
import tigase.muc.cluster.StrategyIfc;
import tigase.server.ComponentInfo;
import tigase.server.Packet;
import tigase.sys.TigaseRuntime;
import tigase.xmpp.jid.JID;

@Bean(name="muc", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode})
@ClusterModeRequired(active=true)
public class MUCComponentClustered
extends MUCComponent
implements ClusteredComponentIfc,
Initializable {
    private static final Logger a = Logger.getLogger(MUCComponentClustered.class.getCanonicalName());
    protected LicenceChecker licenceChecker;
    private ClusterControllerIfc b;
    private ComponentInfo c = null;
    @Inject
    private List<CommandListener> commandListeners;
    @Inject
    private StrategyIfc strategy;

    public boolean addOutPacket(Packet packet) {
        return super.addOutPacket(packet);
    }

    public void onNodeDisconnected(JID jid) {
        super.onNodeDisconnected(jid);
        this.strategy.nodeDisconnected(jid);
    }

    public void processPacket(Packet packet) {
        boolean bl = this.strategy.processPacket(packet);
        if (!bl) {
            super.processPacket(packet);
        }
    }

    public void register(Kernel kernel) {
        if (!ServerBeanSelector.getClusterMode((Kernel)kernel)) {
            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"You've tried using Clustered version of the component but cluster-mode is disabled", "Shutting down system!"});
        }
        super.register(kernel);
    }

    public void setClusterController(ClusterControllerIfc cl_controller) {
        super.setClusterController(cl_controller);
        if (this.b != null && this.commandListeners != null) {
            for (CommandListener commandListener : this.commandListeners) {
                this.b.removeCommandListener(commandListener);
            }
        }
        this.b = cl_controller;
        if (this.b != null && this.commandListeners != null) {
            for (CommandListener commandListener : this.commandListeners) {
                this.b.setCommandListener(commandListener);
            }
        }
        if (this.strategy != null) {
            this.strategy.setClusterController(cl_controller);
        }
        this.kernel.registerBean("clusterController").asInstance((Object)cl_controller).exec();
    }

    public void setCommandListeners(List<CommandListener> commandListeners) {
        if (this.b != null && this.commandListeners != null) {
            for (CommandListener commandListener : commandListeners) {
                this.b.removeCommandListener(commandListener);
            }
        }
        this.commandListeners = commandListeners;
        if (this.b != null && commandListeners != null) {
            for (CommandListener commandListener : commandListeners) {
                this.b.setCommandListener(commandListener);
            }
        }
    }

    public void setStrategy(StrategyIfc strategy) {
        if (this.strategy != null) {
            strategy.setClusterController(null);
        }
        this.strategy = strategy;
        if (this.strategy != null) {
            this.strategy.setClusterController(this.b);
        }
    }

    public ComponentInfo getComponentInfo() {
        this.c = super.getComponentInfo();
        this.c.getComponentData().put("MUCClusteringStrategy", this.strategy != null ? this.strategy.getClass() : null);
        return this.c;
    }

    public void initialize() {
        super.initialize();
        this.licenceChecker = LicenceChecker.getLicenceChecker((String)"acs");
    }

    protected void onNodeConnected(JID jid) {
        super.onNodeConnected(jid);
        this.strategy.nodeConnected(jid);
    }
}

