/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.Affiliation;
import tigase.muc.MUCComponent;
import tigase.muc.Room;
import tigase.muc.RoomAffiliation;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractMucModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="register", parent=MUCComponent.class, active=true)
public class RegisterModule
extends AbstractMucModule {
    private static final String QUERY_NAME = "query";
    private static final String REGISTER_XMLNS = "jabber:iq:register";
    private static final String NICKNAME_FIELD_NAME = "muc#register_roomnick";
    private static final String OFFLINE_FIELD_NAME = "{http://tigase.org/protocol/muc}offline";
    private static final Criteria CRITERIA = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"query", (String)"jabber:iq:register"));
    @Inject
    private IMucRepository mucRepository;

    public String[] getFeatures() {
        return (String[])Stream.concat(Arrays.stream(super.getFeatures()), Stream.of("http://tigase.org/protocol/muc#offline")).toArray(String[]::new);
    }

    public Criteria getModuleCriteria() {
        return CRITERIA;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        block5: {
            try {
                StanzaType type = packet.getType();
                if (type == StanzaType.set) {
                    this.processSet(packet);
                    break block5;
                }
                if (type == StanzaType.get) {
                    this.processGet(packet);
                    break block5;
                }
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            catch (MUCException e1) {
                throw e1;
            }
            catch (Exception e) {
                this.log.log(Level.FINEST, "Error during registration of nickname", e);
                throw new RuntimeException(e);
            }
        }
    }

    protected void processGet(Packet packet) throws RepositoryException, MUCException {
        JID sender = packet.getStanzaFrom();
        Room room = this.getRoom(packet.getStanzaTo().getBareJID());
        this.checkPermission(room, sender);
        Element queryEl = packet.getElemChild(QUERY_NAME, REGISTER_XMLNS);
        Element resultEl = queryEl.clone();
        resultEl.setChildren(Collections.emptyList());
        this.addForm(resultEl, room, sender);
        this.write(packet.okResult(resultEl, 0));
    }

    protected void processSet(Packet packet) throws RepositoryException, MUCException {
        JID sender = packet.getStanzaFrom();
        Room room = this.getRoom(packet.getStanzaTo().getBareJID());
        this.checkPermission(room, sender);
        Element queryEl = packet.getElement().getChild(QUERY_NAME, REGISTER_XMLNS);
        if (queryEl.getChild("remove") != null) {
            RoomAffiliation roomAffiliation = room.getAffiliation(packet.getStanzaFrom().getBareJID());
            if (roomAffiliation != null) {
                Affiliation affiliation = roomAffiliation.getAffiliation();
                room.addAffiliationByJid(sender.getBareJID(), RoomAffiliation.from(affiliation, false, null));
            } else {
                room.addAffiliationByJid(sender.getBareJID(), RoomAffiliation.none);
            }
        } else {
            boolean changed;
            String nickname = Optional.ofNullable(DataForm.getFieldValue((Element)queryEl, (String)NICKNAME_FIELD_NAME)).map(String::trim).filter(s -> !s.isEmpty()).orElse(null);
            String currentNickname = room.getOccupantsNickname(packet.getStanzaFrom());
            boolean offline = Optional.ofNullable(DataForm.getFieldValue((Element)queryEl, (String)OFFLINE_FIELD_NAME)).map(String::trim).map(str -> "1".equals(str) || "true".equals(str)).orElse(false);
            if (!(nickname == null || currentNickname != null && currentNickname.equals(nickname))) {
                throw new MUCException(Authorization.NOT_ACCEPTABLE, "You may only register a nickname which you are using now.");
            }
            if (offline && nickname == null) {
                throw new MUCException(Authorization.NOT_ACCEPTABLE, "You need to register a nickname to enable push notifications.");
            }
            RoomAffiliation roomAffiliation = room.getAffiliation(packet.getStanzaFrom().getBareJID());
            boolean bl = changed = roomAffiliation.isPersistentOccupant() != offline;
            if (changed) {
                Affiliation affiliation = roomAffiliation.getAffiliation();
                if (offline && affiliation == Affiliation.none) {
                    affiliation = Affiliation.member;
                }
                RoomAffiliation newRoomAffiliation = RoomAffiliation.from(affiliation, offline, nickname);
                room.addAffiliationByJid(sender.getBareJID(), newRoomAffiliation);
            }
        }
        this.write(packet.okResult((String)null, 0));
    }

    protected Room getRoom(BareJID roomJID) throws MUCException, RepositoryException {
        Room room = this.mucRepository.getRoom(roomJID);
        if (room == null) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND, "Room does not exist.");
        }
        return room;
    }

    protected void checkPermission(Room room, JID jid) throws MUCException {
        Affiliation affiliation = room.getAffiliation(jid.getBareJID()).getAffiliation();
        if (affiliation != Affiliation.none && affiliation != Affiliation.outcast && !room.isOccupantInRoom(jid)) {
            throw new MUCException(Authorization.NOT_ALLOWED, "You are not allowed to register.");
        }
    }

    protected void addForm(Element parent, Room room, JID sender) {
        RoomAffiliation roomAffiliation = room.getAffiliation(sender.getBareJID());
        switch (roomAffiliation.getAffiliation()) {
            case none: 
            case outcast: {
                break;
            }
            default: {
                parent.addChild((XMLNodeIfc)new Element("registered"));
            }
        }
        new DataForm.Builder(parent, Command.DataType.form).addInstructions(new String[]{"Please provide following information to register with this room for offline message delivery."}).addTitle("Registration form").withFields(builder -> {
            builder.addField(DataForm.FieldType.Hidden, "FORM_TYPE").setValue("http://jabber.org/protocol/muc#register").build();
            builder.addField(DataForm.FieldType.TextSingle, NICKNAME_FIELD_NAME).setLabel("Nickname").setValue(Optional.ofNullable(roomAffiliation.getRegisteredNickname()).orElseGet(() -> room.getOccupantsNickname(sender))).build();
            if (!room.getConfig().isRoomModerated()) {
                builder.addField(DataForm.FieldType.Boolean, OFFLINE_FIELD_NAME).setLabel("Request offline message delivery").setValue(Boolean.valueOf(roomAffiliation.isPersistentOccupant())).build();
            }
        }).build();
    }
}

