/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.component.responses.AsyncCallback;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.workgroupqueues.data.Store;
import tigase.workgroupqueues.data.WorkgroupQueueEntity;
import tigase.workgroupqueues.modules.agent.OfferModule;
import tigase.workgroupqueues.modules.agent.PresenceModule;
import tigase.workgroupqueues.modules.muc.MucControllerModule;
import tigase.workgroupqueues.modules.user.JoinQueueModule;
import tigase.workgroupqueues.modules.user.QueueStatusModule;
import tigase.workgroupqueues.scheduler.Agent;
import tigase.workgroupqueues.scheduler.Controller;
import tigase.workgroupqueues.scheduler.Offer;
import tigase.workgroupqueues.scheduler.Queue;
import tigase.workgroupqueues.scheduler.Room;
import tigase.workgroupqueues.scheduler.Scheduler;
import tigase.workgroupqueues.scheduler.User;
import tigase.workgroupqueues.util.sequencer.Actions;
import tigase.workgroupqueues.util.sequencer.ISequenceAction;
import tigase.workgroupqueues.util.sequencer.Sequencer;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="Controller", active=true)
public class DefaultController
implements Initializable,
Controller {
    private final Logger a = Logger.getLogger(this.getClass().getName());
    private final ConcurrentHashMap<BareJID, Queue> b = new ConcurrentHashMap();
    private final ConcurrentHashMap<BareJID, Room> c = new ConcurrentHashMap();
    @Inject
    private PresenceModule agentPresenceModule;
    @Inject
    private EventBus eventBus;
    @Inject
    private JoinQueueModule joinQueueModule;
    @Inject
    private MucControllerModule mucController;
    @Inject
    private OfferModule offerModule;
    private int d = 60;
    @Inject
    private Scheduler scheduler;
    @Inject
    private Store store;
    @Inject
    private QueueStatusModule userQueueStatusModule;

    @Override
    public void addAgent(Agent agent) {
        if (this.a.isLoggable(Level.FINEST)) {
            this.a.finest("Adding agent " + agent.getJid() + " to queue " + agent.getWorkgroupQueue());
        }
        Queue queue = this.getQueue(agent.getWorkgroupQueue());
        queue.addAgent(agent);
        this.doSomething(queue);
    }

    @Override
    public void addUser(User user) {
        if (this.a.isLoggable(Level.FINEST)) {
            this.a.finest("Adding user " + user.getJid() + " to queue " + user.getWorkgroupQueue());
        }
        Queue queue = this.getQueue(user.getWorkgroupQueue());
        queue.addUser(user);
        this.scheduler.onUserJoinedQueue(queue, user);
        this.doSomething(queue);
    }

    @Override
    public Room createRoomInstance(Queue queue, User user) throws TigaseStringprepException {
        Room room;
        if (user.getRoom() == null) {
            room = new Room(BareJID.bareJIDInstance((String)this.mucController.generateRoomName(), (String)queue.getMucDomain()), queue.getJid());
            this.c.put(room.getRoomJID(), room);
        } else {
            room = user.getRoom();
        }
        return room;
    }

    public void doSomething(Queue queue) {
        if (this.a.isLoggable(Level.FINEST)) {
            this.a.finest("Trying to match member with agent");
        }
        try {
            Iterator iterator = this.a(queue).iterator();
            while (iterator.hasNext()) {
                Agent agent;
                User user = (User)iterator.next();
                if (user.getOffer() != null || (agent = this.scheduler.getBestAgent(queue, user)) == null) continue;
                this.a(queue, user, agent);
            }
        }
        catch (TigaseStringprepException tigaseStringprepException) {
            tigaseStringprepException.printStackTrace();
        }
    }

    @Override
    public Collection<ISequenceAction> getAddAgentToRoomActions(final Queue queue, final User user, final Agent agent, final Room room) {
        ArrayList<ISequenceAction> arrayList = new ArrayList<ISequenceAction>();
        arrayList.add(new Actions.CallAsyncMethod(){

            @Override
            public void proxy(AsyncCallback callback) {
                try {
                    DefaultController.this.mucController.addAgent(queue, room, agent, callback);
                }
                catch (TigaseStringprepException tigaseStringprepException) {
                    tigaseStringprepException.printStackTrace();
                }
            }

            @Override
            protected void onError(Packet responseStanza, String errorCondition) {
            }

            @Override
            protected void onSuccess(Packet responseStanza) {
            }

            @Override
            protected void onTimeout() {
            }
        });
        arrayList.add(new Actions.CallMethod(){

            @Override
            public void proxy() {
                try {
                    DefaultController.this.offerModule.sendAgentInvitation(room.getRoomJID(), agent, user, queue, null);
                }
                catch (TigaseStringprepException tigaseStringprepException) {
                    tigaseStringprepException.printStackTrace();
                }
            }
        });
        return arrayList;
    }

    public PresenceModule getAgentPresenceModule() {
        return this.agentPresenceModule;
    }

    public void setAgentPresenceModule(PresenceModule agentPresenceModule) {
        this.agentPresenceModule = agentPresenceModule;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public JoinQueueModule getJoinQueueModule() {
        return this.joinQueueModule;
    }

    public void setJoinQueueModule(JoinQueueModule joinQueueModule) {
        this.joinQueueModule = joinQueueModule;
    }

    public MucControllerModule getMucController() {
        return this.mucController;
    }

    public void setMucController(MucControllerModule mucController) {
        this.mucController = mucController;
    }

    public OfferModule getOfferModule() {
        return this.offerModule;
    }

    public void setOfferModule(OfferModule offerModule) {
        this.offerModule = offerModule;
    }

    @Override
    public Queue getQueue(BareJID jid) {
        Queue queue = this.b.get(jid);
        if (queue == null) {
            WorkgroupQueueEntity workgroupQueueEntity = this.store.getWorkgroupQueue(jid);
            queue = new Queue(workgroupQueueEntity.getJid(), workgroupQueueEntity.getMucDomain());
            this.b.put(queue.getJid(), queue);
        }
        return queue;
    }

    @Override
    public int getQueueUserPosition(User user) {
        Queue queue = this.getQueue(user.getWorkgroupQueue());
        List list = this.a(queue).collect(Collectors.toList());
        int n = list.indexOf(user);
        return n;
    }

    @Override
    public int getQueueUserWaitingTime(User user) {
        Queue queue = this.getQueue(user.getWorkgroupQueue());
        int n = this.getQueueUserPosition(user);
        int n2 = queue.getAverageWaitingTime();
        int n3 = (n2 + n2 * n) / 1000;
        return n3 >= 0 ? n3 : 0;
    }

    @Override
    public Collection<ISequenceAction> getRoomCreateActions(final Queue queue, final User user, final Room room) {
        ArrayList<ISequenceAction> arrayList = new ArrayList<ISequenceAction>();
        if (!room.isCreated()) {
            arrayList.add(new Actions.CallAsyncMethod(){

                @Override
                public void proxy(AsyncCallback callback) {
                    try {
                        DefaultController.this.mucController.createRoom(queue, room, callback);
                    }
                    catch (TigaseStringprepException tigaseStringprepException) {
                        tigaseStringprepException.printStackTrace();
                    }
                }

                @Override
                protected void onError(Packet responseStanza, String errorCondition) {
                }

                @Override
                protected void onSuccess(Packet responseStanza) {
                    room.setCreated(true);
                }

                @Override
                protected void onTimeout() {
                }
            });
            arrayList.add(new Actions.CallAsyncMethod(){

                @Override
                public void proxy(AsyncCallback callback) {
                    try {
                        DefaultController.this.mucController.addUser(queue, room, user, callback);
                    }
                    catch (TigaseStringprepException tigaseStringprepException) {
                        tigaseStringprepException.printStackTrace();
                    }
                }

                @Override
                protected void onError(Packet responseStanza, String errorCondition) {
                }

                @Override
                protected void onSuccess(Packet responseStanza) {
                    user.setRoom(room);
                }

                @Override
                protected void onTimeout() {
                }
            });
            arrayList.add(new Actions.CallMethod(){

                @Override
                public void proxy() {
                    try {
                        DefaultController.this.joinQueueModule.sendUserInvitation(room.getRoomJID(), user, queue, null);
                    }
                    catch (TigaseStringprepException tigaseStringprepException) {
                        tigaseStringprepException.printStackTrace();
                    }
                }
            });
        }
        return arrayList;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public QueueStatusModule getUserQueueStatusModule() {
        return this.userQueueStatusModule;
    }

    public void setUserQueueStatusModule(QueueStatusModule userQueueStatusModule) {
        this.userQueueStatusModule = userQueueStatusModule;
    }

    public void initialize() {
        this.eventBus.registerAll((Object)this);
        this.eventBus.addListener("RoomLeave", "tigase:events:muc", element -> {
            String string = element.getCDataStaticStr(new String[]{"RoomLeave", "room"});
            String string2 = element.getCDataStaticStr(new String[]{"RoomLeave", "nickname"});
            String string3 = element.getCDataStaticStr(new String[]{"RoomLeave", "jid"});
            this.a.info("Received RoomLeave: " + string + "   " + string2 + "    " + string3);
            this.b(string, string3);
        });
        this.eventBus.addListener("RoomDestroyed", "tigase:events:muc", element -> {
            String string = element.getCDataStaticStr(new String[]{"RoomDestroyed", "room"});
            this.a.info("Received RoomDestroyed: " + string);
            this.a(string);
        });
        this.eventBus.addListener("RoomCreated", "tigase:events:muc", element -> {
            String string = element.getCDataStaticStr(new String[]{"RoomCreated", "room"});
            String string2 = element.getCDataStaticStr(new String[]{"RoomCreated", "creatorJID"});
            this.a.info("Received RoomCreated: " + string);
            Room room = this.c.get(BareJID.bareJIDInstanceNS((String)string));
            if (room != null) {
                room.setCreated(true);
            }
        });
    }

    @Override
    public void offerAccepted(final Offer offer) {
        if (this.a.isLoggable(Level.FINEST)) {
            this.a.finest("Offer accepted. queue=" + offer.getQueue().getJid() + "; agent=" + offer.getAgent().getJid() + "; user=" + offer.getUser().getJid());
        }
        try {
            final Queue queue = offer.getQueue();
            final User user = offer.getUser();
            final Agent agent = offer.getAgent();
            final Room room = this.createRoomInstance(queue, user);
            Sequencer sequencer = new Sequencer(){

                @Override
                public void onFailure() {
                }

                @Override
                public void onFinish() {
                    queue.getStats().addHandledUser(user.getJoinTime(), new Date());
                    queue.removeUser(user);
                    user.setOffer(null);
                    agent.addRoom(room);
                    agent.removeOffer(offer);
                }
            };
            if (!room.isCreated()) {
                sequencer.add(this.getRoomCreateActions(queue, user, room));
            }
            sequencer.add(this.getAddAgentToRoomActions(queue, user, agent, room));
            sequencer.run();
        }
        catch (TigaseStringprepException tigaseStringprepException) {
            tigaseStringprepException.printStackTrace();
        }
    }

    @Override
    public void offerRejected(Offer offer) {
        if (this.a.isLoggable(Level.FINEST)) {
            this.a.finest("Offer rejected. queue=" + offer.getQueue().getJid() + "; agent=" + offer.getAgent().getJid() + "; user=" + offer.getUser().getJid());
        }
        Queue queue = offer.getQueue();
        User user = offer.getUser();
        Agent agent = offer.getAgent();
        agent.removeOffer(offer);
        user.setOffer(null);
        this.doSomething(queue);
    }

    @Override
    public void removeAgent(Agent agent) {
        if (this.a.isLoggable(Level.FINEST)) {
            this.a.finest("Removing agent " + agent.getJid() + " from queue " + agent.getWorkgroupQueue());
        }
        Queue queue = this.getQueue(agent.getWorkgroupQueue());
        queue.removeAgent(agent);
        for (Room object : agent.getRooms()) {
            queue.getUsers().stream().filter(user -> user.getRoom().equals(object)).forEach(user -> this.addUser((User)user));
        }
        for (Offer offer : agent.getOffers()) {
            offer.getUser().setOffer(null);
            queue.removeOffer(queue, offer.getUser().getJid(), agent);
            this.addUser(offer.getUser());
        }
    }

    @Override
    public void removeUser(User user) {
        if (this.a.isLoggable(Level.FINEST)) {
            this.a.finest("Removing user " + user.getJid() + " from queue " + user.getWorkgroupQueue());
        }
        Queue queue = this.getQueue(user.getWorkgroupQueue());
        queue.removeUser(user);
    }

    @Override
    public void sendNotifications() {
        this.a.finest("notify all");
        for (Queue queue : this.b.values()) {
            long l = System.currentTimeMillis() - 30000L;
            for (User user : queue.getUsers()) {
                if (user.getLastUpdateSendTime() != null && user.getLastUpdateSendTime().getTime() >= l) continue;
                this.a(queue, user);
            }
            for (Agent agent : queue.getAgents()) {
                if (agent.getLastUpdateSendTime() != null && agent.getLastUpdateSendTime().getTime() >= l) continue;
                this.a(queue, agent);
            }
        }
    }

    @Override
    public void updateAgent(Agent agent) {
        if (this.a.isLoggable(Level.FINEST)) {
            this.a.finest("Updating status of agent " + agent.getJid());
        }
        Queue queue = this.getQueue(agent.getWorkgroupQueue());
        this.doSomething(queue);
    }

    @Override
    public void updateUser(User user) {
        if (this.a.isLoggable(Level.FINEST)) {
            this.a.finest("Updating status of user " + user.getJid());
        }
        Queue queue = this.getQueue(user.getWorkgroupQueue());
        this.doSomething(queue);
    }

    private void a(String string) {
        Room room = this.c.remove(BareJID.bareJIDInstanceNS((String)string));
        if (room != null) {
            // empty if block
        }
    }

    private Stream<User> a(Queue queue) {
        return queue.getUsers().stream().sorted((user, user2) -> user.getJoinTime().compareTo(user2.getJoinTime()));
    }

    private void a(String string, String string2) {
        Room room = this.c.get(BareJID.bareJIDInstanceNS((String)string));
        if (room == null) {
            return;
        }
        Queue queue = this.b.get(room.getQueueJID());
        User user = queue.getUser(JID.jidInstanceNS((String)string2));
        if (user != null) {
            // empty if block
        }
    }

    private void b(String string, String string2) {
        Room room = this.c.get(BareJID.bareJIDInstanceNS((String)string));
        if (room == null) {
            return;
        }
        Queue queue = this.b.get(room.getQueueJID());
        Agent agent = queue.getAgent(JID.jidInstanceNS((String)string2));
        if (agent != null) {
            agent.removeRoom(room);
            try {
                this.mucController.destroyRoom(queue, room);
            }
            catch (TigaseStringprepException tigaseStringprepException) {
                this.a.log(Level.WARNING, "Something wrong with JID?", tigaseStringprepException);
            }
        }
        User user = queue.getUser(JID.jidInstanceNS((String)string2));
    }

    private void a(Queue queue, User user, Agent agent) throws TigaseStringprepException {
        Offer offer = new Offer(queue, user, agent);
        if (this.a.isLoggable(Level.FINEST)) {
            this.a.finest("Agent " + agent.getJid() + " will handle user " + user.getJid());
        }
        queue.addOffer(offer);
        if (this.a.isLoggable(Level.FINEST)) {
            this.a.finest("Sending offer to agent " + offer.getAgent() + " from queue " + offer.getQueue());
        }
        agent.addOffer(offer);
        user.setOffer(offer);
        this.offerModule.sendOffer(user, agent, this.d);
    }

    private void a(Queue queue, User user) {
        user.setLastUpdateSendTime(new Date());
        try {
            this.userQueueStatusModule.sendCurrentStatus(queue, user);
        }
        catch (TigaseStringprepException tigaseStringprepException) {
            this.a.log(Level.WARNING, "Cannot send status update to user", tigaseStringprepException);
        }
    }

    private void a(Queue queue, Agent agent) {
        agent.setLastUpdateSendTime(new Date());
        try {
            this.agentPresenceModule.sendAgentStatusUpdate(agent);
            this.agentPresenceModule.sendQueueStatusUpdate(agent);
        }
        catch (TigaseStringprepException tigaseStringprepException) {
            this.a.log(Level.WARNING, "Cannot send status update to agent", tigaseStringprepException);
        }
    }
}

