/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.modules.user;

import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.workgroupqueues.data.Store;
import tigase.workgroupqueues.data.WorkgroupQueueEntity;
import tigase.workgroupqueues.modules.AbstractModule;
import tigase.workgroupqueues.scheduler.Controller;
import tigase.workgroupqueues.scheduler.Queue;
import tigase.workgroupqueues.scheduler.User;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="QueueStatusModule", active=true)
public class QueueStatusModule
extends AbstractModule {
    public static final String ID = "QueueStatusModule";
    private static final Criteria a = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"queue-status", (String)"http://jabber.org/protocol/workgroup"));
    @Inject
    private Controller controller;
    @Inject
    private Store store;

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/workgroup"};
    }

    public Criteria getModuleCriteria() {
        return a;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        JID jID = JID.jidInstance((String)packet.getAttributeStaticStr("from"));
        BareJID bareJID = BareJID.bareJIDInstance((String)packet.getAttributeStaticStr("to"));
        WorkgroupQueueEntity workgroupQueueEntity = this.store.getWorkgroupQueue(bareJID);
        if (workgroupQueueEntity == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Workgroup not found");
        }
        Queue queue = this.controller.getQueue(bareJID);
        User user = queue.getUser(jID);
        if (user == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "The user is not in the queue");
        }
        Element element = this.a(user);
        this.write(packet.okResult(element, 0));
    }

    public void sendCurrentStatus(Queue queue, User user) throws TigaseStringprepException {
        Element element = new Element("message", new String[]{"from", "to"}, new String[]{queue.getJid().toString(), user.getJid().toString()});
        element.addChild((XMLNodeIfc)this.a(user));
        this.write(Packet.packetInstance((Element)element));
    }

    private Element a(User user) {
        Element element = new Element("queue-status", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/workgroup"});
        element.addChild((XMLNodeIfc)new Element("position", String.valueOf(this.controller.getQueueUserPosition(user))));
        element.addChild((XMLNodeIfc)new Element("time", String.valueOf(this.controller.getQueueUserWaitingTime(user))));
        return element;
    }
}

