/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.modules.user;

import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.workgroupqueues.data.Store;
import tigase.workgroupqueues.data.WorkgroupQueueEntity;
import tigase.workgroupqueues.modules.AbstractModule;
import tigase.workgroupqueues.scheduler.Controller;
import tigase.workgroupqueues.scheduler.Queue;
import tigase.workgroupqueues.scheduler.User;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="JoinQueueModule", active=true)
public class JoinQueueModule
extends AbstractModule {
    public static final String ID = "JoinQueueModule";
    private static final Criteria a = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"join-queue", (String)"http://jabber.org/protocol/workgroup"));
    @Inject
    private Controller controller;
    @Inject
    private Store store;

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/workgroup"};
    }

    public Criteria getModuleCriteria() {
        return a;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        JID jID = JID.jidInstance((String)packet.getAttributeStaticStr("from"));
        BareJID bareJID = BareJID.bareJIDInstance((String)packet.getAttributeStaticStr("to"));
        WorkgroupQueueEntity workgroupQueueEntity = this.store.getWorkgroupQueue(bareJID);
        if (workgroupQueueEntity == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Workgroup not found");
        }
        Queue queue = this.controller.getQueue(bareJID);
        if (queue.getUser(jID) != null) {
            throw new ComponentException(Authorization.CONFLICT);
        }
        Element element = packet.getElement().getChild("join-queue", "http://jabber.org/protocol/workgroup");
        boolean bl = element.getChild("queue-notifications") != null;
        User user = new User(jID, queue.getJid());
        user.setQueueNotifications(bl);
        this.controller.addUser(user);
        this.write(packet.okResult((Element)null, 0));
    }

    public void sendUserInvitation(BareJID roomJID, User user, Queue queue, String reason) throws TigaseStringprepException {
        Element element = new Element("message", new String[]{"from", "to"}, new String[]{roomJID.toString(), user.getJid().toString()});
        Element element2 = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        element.addChild((XMLNodeIfc)element2);
        Element element3 = new Element("invite", new String[]{"from"}, new String[]{queue.getJid().toString()});
        element2.addChild((XMLNodeIfc)element3);
        if (reason != null) {
            element3.addChild((XMLNodeIfc)new Element("reason", reason));
        }
        this.write(Packet.packetInstance((Element)element));
    }
}

