/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.modules.agent;

import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.workgroupqueues.data.Store;
import tigase.workgroupqueues.data.WorkgroupQueueEntity;
import tigase.workgroupqueues.modules.AbstractModule;
import tigase.workgroupqueues.scheduler.Agent;
import tigase.workgroupqueues.scheduler.Controller;
import tigase.workgroupqueues.scheduler.Queue;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="AgentStatusModule", active=true)
public class StatusModule
extends AbstractModule {
    public static final String ID = "AgentStatusModule";
    private static final Criteria a = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"agent-status-request", (String)"http://jabber.org/protocol/workgroup"));
    @Inject
    private Controller controller;
    @Inject
    private Store store;

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/workgroup"};
    }

    public Criteria getModuleCriteria() {
        return a;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        JID jID = JID.jidInstance((String)packet.getAttributeStaticStr("from"));
        BareJID bareJID = BareJID.bareJIDInstance((String)packet.getAttributeStaticStr("to"));
        WorkgroupQueueEntity workgroupQueueEntity = this.store.getWorkgroupQueue(bareJID);
        if (workgroupQueueEntity == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Workgroup not found");
        }
        Queue queue = this.controller.getQueue(bareJID);
        Agent agent = queue.getAgent(jID);
        if (agent == null) {
            throw new ComponentException(Authorization.NOT_AUTHORIZED, "Not authorized to send stanza as agent");
        }
        agent.setAgentStatusUpdateRequested(true);
        Element element = new Element("agent-status-request", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/workgroup"});
        for (Agent agent2 : queue.getAgents()) {
            if (agent2.equals(agent)) continue;
            element.addChild((XMLNodeIfc)new Element("agent", new String[]{"jid"}, new String[]{agent2.getJid().getBareJID().toString()}));
        }
        this.write(packet.okResult(element, 0));
    }
}

