/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.modules.agent;

import tigase.component.exceptions.ComponentException;
import tigase.component.responses.AsyncCallback;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.criteria.Or;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.workgroupqueues.data.Store;
import tigase.workgroupqueues.data.WorkgroupQueueEntity;
import tigase.workgroupqueues.modules.AbstractModule;
import tigase.workgroupqueues.scheduler.Agent;
import tigase.workgroupqueues.scheduler.Controller;
import tigase.workgroupqueues.scheduler.Offer;
import tigase.workgroupqueues.scheduler.Queue;
import tigase.workgroupqueues.scheduler.User;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="AgentOfferModule", active=true)
public class OfferModule
extends AbstractModule {
    public static final String ID = "AgentOfferModule";
    private static final Criteria a = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)new Or(new Criteria[]{ElementCriteria.name((String)"offer-accept", (String)"http://jabber.org/protocol/workgroup"), ElementCriteria.name((String)"offer-reject", (String)"http://jabber.org/protocol/workgroup")}));
    @Inject
    private Controller controller;
    @Inject
    private Store store;

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/workgroup"};
    }

    public Criteria getModuleCriteria() {
        return a;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        JID jID = JID.jidInstance((String)packet.getAttributeStaticStr("from"));
        BareJID bareJID = BareJID.bareJIDInstance((String)packet.getAttributeStaticStr("to"));
        WorkgroupQueueEntity workgroupQueueEntity = this.store.getWorkgroupQueue(bareJID);
        if (workgroupQueueEntity == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Workgroup not found");
        }
        Queue queue = this.controller.getQueue(bareJID);
        Agent agent = queue.getAgent(jID);
        if (agent == null) {
            throw new ComponentException(Authorization.NOT_AUTHORIZED, "Not authorized to send stanza as agent");
        }
        Element element = packet.getElement().getChild("offer-accept", "http://jabber.org/protocol/workgroup");
        Element element2 = packet.getElement().getChild("offer-reject", "http://jabber.org/protocol/workgroup");
        if (element != null) {
            this.a(queue, agent, element);
        } else if (element2 != null) {
            this.b(queue, agent, element2);
        }
        this.write(packet.okResult((Element)null, 0));
    }

    public void sendAgentInvitation(BareJID roomJID, Agent agent, User user, Queue queue, String reason) throws TigaseStringprepException {
        Element element = new Element("message", new String[]{"from", "to"}, new String[]{roomJID.toString(), agent.getJid().toString()});
        Element element2 = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        element.addChild((XMLNodeIfc)element2);
        Element element3 = new Element("invite", new String[]{"from"}, new String[]{queue.getJid().toString()});
        element2.addChild((XMLNodeIfc)element3);
        if (reason != null) {
            element3.addChild((XMLNodeIfc)new Element("reason", reason));
        }
        Element element4 = new Element("offer", new String[]{"xmlns", "jid"}, new String[]{"http://jabber.org/protocol/workgroup", user.getJid().toString()});
        element.addChild((XMLNodeIfc)element4);
        this.write(Packet.packetInstance((Element)element));
    }

    public void sendOffer(User user, Agent toAgent, int timeout) throws TigaseStringprepException {
        Queue queue = this.controller.getQueue(toAgent.getWorkgroupQueue());
        Element element = new Element("iq", new String[]{"type", "from", "to"}, new String[]{"set", queue.getJid().toString(), toAgent.getJid().toString()});
        Element element2 = new Element("offer", new String[]{"xmlns", "jid"}, new String[]{"http://jabber.org/protocol/workgroup", user.getJid().toString()});
        element2.addChild((XMLNodeIfc)new Element("timeout", String.valueOf(timeout)));
        element.addChild((XMLNodeIfc)element2);
        this.write(Packet.packetInstance((Element)element), new AsyncCallback(){

            public void onError(Packet packet, String s) {
            }

            public void onSuccess(Packet packet) {
            }

            public void onTimeout() {
            }
        });
    }

    public void sendOfferRevoke(User user, Agent toAgent, String reason) throws TigaseStringprepException {
        Queue queue = this.controller.getQueue(toAgent.getWorkgroupQueue());
        Element element = new Element("iq", new String[]{"type", "from", "to"}, new String[]{"set", queue.getJid().toString(), toAgent.getJid().toString()});
        Element element2 = new Element("offer-revoke", new String[]{"xmlns", "jid"}, new String[]{"http://jabber.org/protocol/workgroup", user.getJid().toString()});
        if (reason != null) {
            element2.addChild((XMLNodeIfc)new Element("reason", reason));
        }
        element.addChild((XMLNodeIfc)element2);
        this.write(Packet.packetInstance((Element)element), new AsyncCallback(){

            public void onError(Packet packet, String s) {
            }

            public void onSuccess(Packet packet) {
            }

            public void onTimeout() {
            }
        });
    }

    private void a(Queue queue, Agent agent, Element element) throws TigaseStringprepException, ComponentException {
        String string = element.getAttributeStaticStr("jid");
        if (string == null) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Missing JID in request");
        }
        JID jID = JID.jidInstance((String)string);
        Offer offer = queue.removeOffer(queue, jID, agent);
        if (offer == null) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Such offer was never sent");
        }
        this.controller.offerAccepted(offer);
    }

    private void b(Queue queue, Agent agent, Element element) throws TigaseStringprepException, ComponentException {
        String string = element.getAttributeStaticStr("jid");
        if (string == null) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Missing JID in request");
        }
        JID jID = JID.jidInstance((String)string);
        Offer offer = queue.removeOffer(queue, jID, agent);
        if (offer == null) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Such offer was never sent");
        }
        this.controller.offerRejected(offer);
    }
}

