/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.mix.model.MixLogic;
import tigase.mix.model.RoomGhostbuster;
import tigase.mix.modules.RoomPresenceModule;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@ClusterModeRequired(active=false)
@Bean(name="roomPresenceRepository", parent=RoomPresenceModule.class, active=true)
public class RoomPresenceRepository {
    private final Map<BareJID, Map<String, JID>> tempParticipants = new ConcurrentHashMap<BareJID, Map<String, JID>>();
    @Inject
    private MixLogic mixLogic;
    @Inject
    private RoomGhostbuster ghostbuster;

    public void addTempParticipant(BareJID channelJID, JID occupantJID, String nickname) {
        Map participants = this.tempParticipants.computeIfAbsent(channelJID, k -> new ConcurrentHashMap());
        participants.put(nickname, occupantJID);
        this.ghostbuster.register(channelJID, occupantJID);
    }

    public void removeTempParticipant(BareJID channelJID, JID occupantJID, String nickname) {
        Map<String, JID> participants = this.tempParticipants.get(channelJID);
        if (participants != null) {
            if (nickname != null) {
                JID removed = participants.remove(nickname);
                if (removed != null) {
                    this.ghostbuster.unregister(channelJID, removed);
                }
            } else {
                Optional<String> nicknameOptional = participants.entrySet().stream().filter(e -> occupantJID.equals(e.getValue())).map(Map.Entry::getKey).findFirst();
                nicknameOptional.ifPresent(nick -> participants.remove(nick));
                this.ghostbuster.unregister(channelJID, occupantJID);
            }
        }
    }

    public boolean isNicknameInUse(BareJID channelJID, JID occupantJID, String nickname) {
        Map<String, JID> participants = this.tempParticipants.get(channelJID);
        if (participants == null) {
            return false;
        }
        JID jid = participants.get(nickname);
        if (jid == null) {
            return false;
        }
        return !occupantJID.equals((Object)jid);
    }

    public Collection<JID> getRoomParticipantJids(BareJID channelJID) {
        return Optional.ofNullable(this.tempParticipants.get(channelJID)).map(Map::values).orElse(Collections.emptyList());
    }

    public Set<String> getRoomParticipantsIds(BareJID channelJID) {
        Map<String, JID> participants = this.tempParticipants.get(channelJID);
        if (participants == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (JID jid : participants.values()) {
            try {
                result.add(this.mixLogic.generateTempParticipantId(channelJID, jid));
            }
            catch (RepositoryException repositoryException) {}
        }
        return result;
    }

    public boolean isRoomParticipant(BareJID channelJID, JID jid) {
        Map<String, JID> participants = this.tempParticipants.get(channelJID);
        if (participants == null) {
            return false;
        }
        return participants.values().contains(jid);
    }

    public Set<Map.Entry<BareJID, Map<String, JID>>> getTempParticipantsPresence() {
        return this.tempParticipants.entrySet();
    }

    public boolean isParticipant(BareJID channelJID, JID sender) {
        return Optional.ofNullable(this.tempParticipants.get(channelJID)).map(Map::values).filter(set -> set.contains(sender)).isPresent();
    }
}

