/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix;

import java.util.Collections;
import java.util.Map;
import tigase.component.exceptions.RepositoryException;
import tigase.mix.model.ChannelConfiguration;
import tigase.mix.model.ChannelNodePermission;
import tigase.mix.model.IMixRepository;
import tigase.pubsub.Affiliation;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.cached.IAffiliationsCached;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.xmpp.jid.BareJID;

public class Affiliations
implements IAffiliationsCached {
    private final BareJID channelJID;
    private final String nodeName;
    private final IMixRepository mixRepository;

    public Affiliations(BareJID serviceJID, String nodeName, IMixRepository mixRepository) {
        this.channelJID = serviceJID;
        this.nodeName = nodeName;
        this.mixRepository = mixRepository;
    }

    public boolean isChanged() {
        return false;
    }

    public Map<BareJID, UsersAffiliation> getChanged() {
        return Collections.emptyMap();
    }

    public void resetChangedFlag() {
    }

    public void merge() {
    }

    public void addAffiliation(BareJID jid, Affiliation affiliation) {
    }

    public void changeAffiliation(BareJID jid, Affiliation affiliation) {
    }

    public UsersAffiliation[] getAffiliations() {
        return new UsersAffiliation[0];
    }

    public UsersAffiliation getSubscriberAffiliation(BareJID jid) {
        try {
            ChannelConfiguration channelConfiguration = this.mixRepository.getChannelConfiguration(this.channelJID);
            if (channelConfiguration == null) {
                return new UsersAffiliation(jid, Affiliation.none);
            }
            switch (this.nodeName) {
                case "urn:xmpp:mix:nodes:config": {
                    switch (channelConfiguration.getConfigurationNodeAccess()) {
                        case participants: {
                            if (channelConfiguration.isOwner(jid)) {
                                return new UsersAffiliation(jid, Affiliation.owner);
                            }
                            return new UsersAffiliation(jid, !this.isParticipant(jid) ? Affiliation.none : Affiliation.member);
                        }
                        case admins: {
                            if (channelConfiguration.isOwner(jid)) {
                                return new UsersAffiliation(jid, Affiliation.owner);
                            }
                            if (channelConfiguration.isAdministrator(jid)) {
                                return new UsersAffiliation(jid, !this.isParticipant(jid) ? Affiliation.none : Affiliation.member);
                            }
                            return new UsersAffiliation(jid, Affiliation.outcast);
                        }
                        case owners: {
                            if (channelConfiguration.isOwner(jid)) {
                                return new UsersAffiliation(jid, Affiliation.owner);
                            }
                            return new UsersAffiliation(jid, Affiliation.none);
                        }
                    }
                    return new UsersAffiliation(jid, Affiliation.outcast);
                }
                case "urn:xmpp:mix:nodes:info": {
                    if (channelConfiguration.isOwner(jid)) {
                        return new UsersAffiliation(jid, Affiliation.owner);
                    }
                    ChannelNodePermission updatePermission = channelConfiguration.getInformationNodeUpdateRights();
                    if (channelConfiguration.isAdministrator(jid) && updatePermission == ChannelNodePermission.admins) {
                        return new UsersAffiliation(jid, Affiliation.publisher);
                    }
                    switch (channelConfiguration.getInformationNodeSubscription()) {
                        case participants: 
                        case allowed: {
                            return new UsersAffiliation(jid, this.isParticipant(jid) ? (updatePermission == ChannelNodePermission.participants ? Affiliation.publisher : Affiliation.member) : Affiliation.none);
                        }
                        case anyone: {
                            return new UsersAffiliation(jid, Affiliation.member);
                        }
                    }
                    return new UsersAffiliation(jid, Affiliation.none);
                }
                case "urn:xmpp:avatar:data": 
                case "urn:xmpp:avatar:metadata": {
                    if (channelConfiguration.isOwner(jid)) {
                        return new UsersAffiliation(jid, Affiliation.owner);
                    }
                    ChannelNodePermission avatarUpdatePermission = channelConfiguration.getAvatarNodesUpdateRights();
                    if (channelConfiguration.isAdministrator(jid) && avatarUpdatePermission == ChannelNodePermission.admins) {
                        return new UsersAffiliation(jid, Affiliation.publisher);
                    }
                    return new UsersAffiliation(jid, this.isParticipant(jid) ? (avatarUpdatePermission == ChannelNodePermission.participants ? Affiliation.publisher : Affiliation.member) : Affiliation.none);
                }
                case "urn:xmpp:mix:nodes:messages": {
                    switch (channelConfiguration.getMessagesNodeSubscription()) {
                        case allowed: {
                            return new UsersAffiliation(jid, this.isParticipant(jid) ? Affiliation.member : Affiliation.none);
                        }
                        case participants: {
                            return new UsersAffiliation(jid, this.isParticipant(jid) ? Affiliation.member : Affiliation.none);
                        }
                        case anyone: {
                            return new UsersAffiliation(jid, Affiliation.member);
                        }
                    }
                    return new UsersAffiliation(jid, Affiliation.none);
                }
                case "urn:xmpp:mix:nodes:participants": {
                    switch (channelConfiguration.getParticipantsNodeSubscription()) {
                        case participants: {
                            return new UsersAffiliation(jid, this.isParticipant(jid) ? Affiliation.member : Affiliation.none);
                        }
                        case anyone: {
                            return new UsersAffiliation(jid, Affiliation.member);
                        }
                        case admins: {
                            return new UsersAffiliation(jid, channelConfiguration.isAdministrator(jid) ? Affiliation.member : Affiliation.none);
                        }
                        case owners: {
                            return new UsersAffiliation(jid, channelConfiguration.isOwner(jid) ? Affiliation.member : Affiliation.none);
                        }
                        case allowed: 
                        case nobody: {
                            return new UsersAffiliation(jid, Affiliation.none);
                        }
                    }
                }
                case "urn:xmpp:mix:nodes:allowed": 
                case "urn:xmpp:mix:nodes:banned": {
                    if (channelConfiguration.isOwner(jid)) {
                        return new UsersAffiliation(jid, Affiliation.owner);
                    }
                    return new UsersAffiliation(jid, channelConfiguration.isAdministrator(jid) ? Affiliation.publisher : Affiliation.none);
                }
            }
            return new UsersAffiliation(jid, Affiliation.none);
        }
        catch (RepositoryException ex) {
            return new UsersAffiliation(jid, Affiliation.none);
        }
    }

    protected boolean isParticipant(BareJID jid) throws RepositoryException {
        return this.mixRepository.getParticipant(this.channelJID, jid) != null;
    }

    protected boolean isSubscribed(BareJID jid) throws RepositoryException {
        ISubscriptions subscriptions = this.mixRepository.getNodeSubscriptions(this.channelJID, this.nodeName);
        if (subscriptions != null) {
            return subscriptions.getSubscription(jid) == Subscription.subscribed;
        }
        return false;
    }

    public int size() {
        return 0;
    }
}

