/*
 * Decompiled with CFR 0.152.
 */
package tigase.stun;

import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import tigase.osgi.ModulesManager;
import tigase.stun.StunComponent;

public class Activator
implements BundleActivator,
ServiceListener {
    private static final Logger log = Logger.getLogger(Activator.class.getCanonicalName());
    private BundleContext context = null;
    private ModulesManager serviceManager = null;
    private ServiceReference serviceReference = null;
    private Class<StunComponent> stunComponentClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bc) throws Exception {
        Activator activator = this;
        synchronized (activator) {
            this.context = bc;
            log.info("register service listener");
            bc.addServiceListener((ServiceListener)this, "(&(objectClass=" + ModulesManager.class.getName() + "))");
            log.info("create instance");
            this.stunComponentClass = StunComponent.class;
            this.serviceReference = bc.getServiceReference(ModulesManager.class.getName());
            if (this.serviceReference != null) {
                log.info("getting service manager");
                this.serviceManager = (ModulesManager)bc.getService(this.serviceReference);
                log.info("registering addons");
                this.registerAddons();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bc) throws Exception {
        Activator activator = this;
        synchronized (activator) {
            if (this.serviceManager != null) {
                this.unregisterAddons();
                this.context.ungetService(this.serviceReference);
                this.serviceManager = null;
                this.serviceReference = null;
            }
            this.stunComponentClass = null;
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            if (this.serviceReference == null) {
                this.serviceReference = event.getServiceReference();
                this.serviceManager = (ModulesManager)this.context.getService(this.serviceReference);
                this.registerAddons();
            }
        } else if (event.getType() == 4 && this.serviceReference == event.getServiceReference()) {
            this.unregisterAddons();
            this.context.ungetService(this.serviceReference);
            this.serviceManager = null;
            this.serviceReference = null;
        }
    }

    private void registerAddons() {
        if (this.serviceManager != null) {
            this.serviceManager.registerServerComponentClass(this.stunComponentClass);
            this.serviceManager.update();
        }
    }

    private void unregisterAddons() {
        if (this.serviceManager != null) {
            this.serviceManager.unregisterServerComponentClass(this.stunComponentClass);
            this.serviceManager.update();
        }
    }
}

