/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.http.upload;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.http.upload.store.Store;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.xmpp.jid.BareJID;

@Bean(name="store", active=true, exportable=true)
public class S3Store
implements Store,
ConfigurationChangedAware {
    private static Logger log = Logger.getLogger(S3Store.class.getCanonicalName());
    protected AmazonS3 s3;
    @ConfigField(desc="AWS region")
    private Regions region;
    @ConfigField(desc="S3 bucket")
    protected String bucket;
    @ConfigField(desc="S3 bucket key prefix")
    private String bucketKeyPrefix;
    @ConfigField(desc="Autocreate bucket")
    protected boolean autocreateBucket = false;
    @ConfigField(desc="S3 access key id")
    protected String accessKeyId;
    @ConfigField(desc="S3 secret key")
    protected String secretKey;
    @ConfigField(desc="S3 endpoint url")
    protected String endpointUrl;
    @ConfigField(desc="AWS path style access")
    protected Boolean pathStyleAccess = null;
    @ConfigField(desc="S3 signer override")
    protected String signerOverride;

    public String getRegion() {
        if (this.region != null) {
            return this.region.getName();
        }
        return null;
    }

    public void setRegion(String region) {
        this.region = region == null ? null : Regions.fromName((String)region);
    }

    public long count() throws IOException {
        try {
            return this.s3.listObjectsV2(this.bucket, this.bucketKeyPrefix).getKeyCount();
        }
        catch (AmazonServiceException ex) {
            throw new IOException("Could not count files", ex);
        }
    }

    public long size() throws IOException {
        try {
            return this.s3.listObjectsV2(this.bucket, this.bucketKeyPrefix).getObjectSummaries().stream().mapToLong(summary -> summary.getSize()).sum();
        }
        catch (AmazonServiceException ex) {
            throw new IOException("Could not count files", ex);
        }
    }

    public ReadableByteChannel getContent(BareJID uploader, String slotId, String filename) throws IOException {
        try {
            return Channels.newChannel((InputStream)this.s3.getObject(new GetObjectRequest(this.bucket, this.createKey(slotId, URLEncoder.encode(filename, StandardCharsets.UTF_8)))).getObjectContent());
        }
        catch (AmazonServiceException ex) {
            try {
                return Channels.newChannel((InputStream)this.s3.getObject(new GetObjectRequest(this.bucket, this.createKey(slotId, filename))).getObjectContent());
            }
            catch (AmazonServiceException ex1) {
                throw new IOException("Could not download the file " + slotId + " from S3", ex);
            }
        }
    }

    public void setContent(BareJID uploader, String slotId, String filename, long size, ReadableByteChannel source) throws IOException {
        File tmp = File.createTempFile("upload-", ".tmp");
        try (FileChannel destination = FileChannel.open(tmp.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            destination.transferFrom(source, 0L, size);
        }
        try {
            this.s3.putObject(this.bucket, this.createKey(slotId, URLEncoder.encode(filename, StandardCharsets.UTF_8)), tmp);
        }
        catch (AmazonServiceException ex) {
            tmp.delete();
            throw new IOException("Could not upload the file " + slotId + " to S3", ex);
        }
    }

    public void remove(BareJID uploader, String slotId) throws IOException {
        try {
            List toRemove = this.s3.listObjectsV2(this.bucket, this.createKeyPrefix(slotId)).getObjectSummaries().stream().map(S3ObjectSummary::getKey).map(DeleteObjectsRequest.KeyVersion::new).collect(Collectors.toList());
            if (!toRemove.isEmpty()) {
                this.s3.deleteObjects(new DeleteObjectsRequest(this.bucket).withKeys(toRemove));
            }
        }
        catch (AmazonServiceException ex) {
            throw new IOException("Could not remove file " + slotId + " from S3", ex);
        }
    }

    public void beanConfigurationChanged(Collection<String> collection) {
        block14: {
            log.log(Level.INFO, "Initiating S3 storage at " + this.region + ", collection: " + collection);
            AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
            if (this.pathStyleAccess != null) {
                builder.setPathStyleAccessEnabled(this.pathStyleAccess);
            }
            if (this.endpointUrl != null && !this.endpointUrl.isEmpty()) {
                builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpointUrl, Optional.ofNullable(this.region).orElse(Regions.US_EAST_1).getName()));
            } else if (this.region != null) {
                builder.withRegion(this.region);
            }
            if (this.signerOverride != null && !this.signerOverride.isEmpty()) {
                ClientConfiguration clientConfiguration = new ClientConfiguration();
                clientConfiguration.setSignerOverride(this.signerOverride);
                builder.withClientConfiguration(clientConfiguration);
            }
            if (this.accessKeyId != null && !this.accessKeyId.isEmpty() && this.secretKey != null && !this.secretKey.isEmpty()) {
                builder.setCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKeyId, this.secretKey)));
            }
            Optional.ofNullable(this.s3).ifPresent(AmazonS3::shutdown);
            this.s3 = (AmazonS3)builder.build();
            log.log(Level.INFO, "Initiated S3 storage at " + this.s3.getRegionName());
            if (!this.s3.doesBucketExistV2(this.bucket)) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "S3 bucket " + this.bucket + " does not exist");
                }
                if (!this.autocreateBucket) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.log(Level.WARNING, "S3 bucket " + this.bucket + " does not exist and automatic creation of bucket is not enabled. File storage in S3 will not work!");
                    }
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "S3 bucket " + this.bucket + " does not exist, trying automatic creation of a bucket..");
                    }
                    try {
                        CreateBucketRequest request = new CreateBucketRequest(this.bucket);
                        request.setCannedAcl(CannedAccessControlList.PublicRead);
                        this.s3.createBucket(request);
                    }
                    catch (AmazonServiceException ex) {
                        if (!log.isLoggable(Level.WARNING)) break block14;
                        log.log(Level.WARNING, "Automatic creation of S3 bucket " + this.bucket + " failed. File storage in S3 will not work!", ex);
                    }
                }
            }
        }
    }

    protected String createKeyPrefix(String slotId) {
        if (this.bucketKeyPrefix == null || this.bucketKeyPrefix.isBlank()) {
            return slotId;
        }
        return this.bucketKeyPrefix + "/" + slotId;
    }

    protected String createKey(String slotId, String filename) {
        return this.createKeyPrefix(slotId) + "/" + filename;
    }
}

