/*
 * Decompiled with CFR 0.152.
 */
package tigase.socks5.verifiers;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.socks5.Limits;
import tigase.socks5.QuotaException;
import tigase.socks5.Socks5ConnectionType;
import tigase.socks5.Socks5IOService;
import tigase.socks5.Socks5ProxyComponent;
import tigase.socks5.Stream;
import tigase.socks5.VerifierIfc;
import tigase.socks5.repository.Socks5Repository;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class LimitsVerifier
implements VerifierIfc {
    private static final Logger log = Logger.getLogger(LimitsVerifier.class.getCanonicalName());
    private static final String CONN_ID_KEY = "conn-id-key";
    private static final String LAST_TRANSFERRED_BYTES_KEY = "last-transferred-bytes";
    private static final int MB = 0x100000;
    private static final int TRANSFER_UPDATE_QUANTIZATION_VAL = 0x100000;
    private static final long DEFAULT_TRANSFER_LIMIT_PER_FILE_VAL = 0xA00000L;
    private static final long DEFAULT_TRANSFER_LIMIT_PER_USER_VAL = 0L;
    private static final long DEFAULT_TRANSFER_LIMIT_PER_DOMAIN_VAL = 0L;
    private static final long TRANSFER_GLOBAL_LIMIT_VAL = 0L;
    private static final long TRANSFER_INSTANCE_LIMIT_VAL = 0L;
    @ConfigField(desc="Transfer limit per domain", alias="default-domain-limit")
    private long defaultTransferLimitPerDomain = 0L;
    @ConfigField(desc="Transfer limit per file", alias="default-file-limit")
    private long defaultTransferLimitPerFile = 0xA00000L;
    @ConfigField(desc="Transfer limit per user", alias="default-user-limit")
    private long defaultTransferLimitPerUser = 0L;
    @Inject
    private Socks5ProxyComponent proxyComponent;
    @ConfigField(desc="Global transfer limit", alias="global-limit")
    private long transferGlobalLimit = 0L;
    @ConfigField(desc="Instance transfer limit", alias="instance-limit")
    private long transferInstanceLimit = 0L;
    @ConfigField(desc="Quantization", alias="transfer-update-quantization")
    private int transferUpdateQuantization = 0x100000;

    @Override
    public boolean isAllowed(Stream stream) throws TigaseDBException {
        if (!this.proxyComponent.isLocalDomain(stream.getRequester().getDomain()) && !this.proxyComponent.isLocalDomain(stream.getTarget().getDomain())) {
            return false;
        }
        try {
            this.updateTransfer(stream);
            return true;
        }
        catch (QuotaException ex) {
            return false;
        }
    }

    @Override
    public void updateTransfer(Socks5IOService service, boolean force) throws TigaseDBException, QuotaException {
        if (service == null) {
            return;
        }
        JID fullJID = service.getJID();
        if (fullJID == null) {
            return;
        }
        BareJID jid = service.getJID().getBareJID();
        String key = "limits-" + jid.toString();
        Limits limits = (Limits)service.getSessionData().get(key);
        if (limits == null) {
            limits = this.getLimits(jid);
            service.getSessionData().put(key, limits);
        }
        if (!(limits.getTransferLimitPerFile() != -1L && limits.getTransferLimitPerUser() != -1L && limits.getTransferLimitPerDomain() != -1L || force)) {
            throw new QuotaException("Transfer denied");
        }
        long transferred = service.getBytesReceived() + service.getBytesSent();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "updating service " + service.getUniqueId() + " transfer data received = " + service.getBytesReceived() + " sent = " + service.getBytesSent() + " transferred = " + transferred);
        }
        Socks5Repository repo = this.proxyComponent.getSock5Repository();
        if (limits.getTransferLimitPerFile() != 0L && limits.getTransferLimitPerFile() < transferred) {
            this.updateTransferUsedByConnection(repo, service, transferred, force);
            if (!force) {
                throw new QuotaException("Stream closed due to exceeded quota for single file transfer");
            }
        }
        if (!this.updateTransferUsedByConnection(repo, service, transferred, force)) {
            return;
        }
        if (limits.getTransferLimitPerUser() != 0L && limits.getTransferLimitPerUser() < repo.getTransferUsedByUser(jid) && !force) {
            throw new QuotaException("Stream closed due to exceeded transfer quota for user " + jid.toString());
        }
        if (limits.getTransferLimitPerDomain() != 0L && limits.getTransferLimitPerDomain() < repo.getTransferUsedByDomain(jid.getDomain()) && !force) {
            throw new QuotaException("Stream closed due to exceeded transfer quota for domain " + jid.getDomain());
        }
        if (this.transferInstanceLimit != 0L && this.transferInstanceLimit < repo.getTransferUsedByInstance(this.proxyComponent.getDefHostName().toString()) && !force) {
            throw new QuotaException("Stream closed due to exceeded transfer quota for instance " + this.proxyComponent.getDefHostName());
        }
        if (this.transferGlobalLimit != 0L && this.transferGlobalLimit < repo.getTransferUsed() && !force) {
            throw new QuotaException("Stream closed due to exceeded global transfer quota");
        }
    }

    private void updateTransfer(Stream stream) throws TigaseDBException, QuotaException {
        this.updateTransfer(stream.getConnection(Socks5ConnectionType.Requester), false);
        this.updateTransfer(stream.getConnection(Socks5ConnectionType.Target), false);
    }

    private boolean updateTransferUsedByConnection(Socks5Repository repo, Socks5IOService service, long transferred, boolean force) throws TigaseDBException {
        Long lastTransferred = (Long)service.getSessionData().get(LAST_TRANSFERRED_BYTES_KEY);
        if (lastTransferred == null) {
            lastTransferred = 0L;
            force = true;
        }
        if (!force && lastTransferred / (long)this.transferUpdateQuantization == transferred / (long)this.transferUpdateQuantization) {
            return false;
        }
        Long conn_id = (Long)service.getSessionData().get(CONN_ID_KEY);
        boolean isNew = false;
        if (conn_id == null) {
            conn_id = repo.createTransferUsedByConnection(service.getJID().getBareJID(), service.getSocks5ConnectionType(), this.proxyComponent.getDefHostName());
            service.getSessionData().put(CONN_ID_KEY, conn_id);
            isNew = true;
        }
        if (!isNew || force) {
            repo.updateTransferUsedByConnection(service.getJID().getBareJID(), conn_id, transferred);
        }
        service.getSessionData().put(LAST_TRANSFERRED_BYTES_KEY, transferred);
        return true;
    }

    private Limits getLimits(BareJID jid) throws TigaseDBException {
        Socks5Repository repo = this.proxyComponent.getSock5Repository();
        Limits limits = repo.getTransferLimits(jid);
        if (limits.getTransferLimitPerFile() == 0L || limits.getTransferLimitPerUser() == 0L || limits.getTransferLimitPerDomain() == 0L) {
            Limits domainLimits = repo.getTransferLimits(jid.getDomain());
            if (limits.getTransferLimitPerFile() == 0L) {
                limits.setTransferLimitPerFile(domainLimits.getTransferLimitPerFile());
            }
            if (limits.getTransferLimitPerUser() == 0L) {
                limits.setTransferLimitPerUser(domainLimits.getTransferLimitPerUser());
            }
            if (limits.getTransferLimitPerDomain() == 0L) {
                limits.setTransferLimitPerDomain(domainLimits.getTransferLimitPerDomain());
            }
        }
        if (limits.getTransferLimitPerFile() == 0L) {
            limits.setTransferLimitPerFile(this.defaultTransferLimitPerFile);
        }
        if (limits.getTransferLimitPerUser() == 0L) {
            limits.setTransferLimitPerUser(this.defaultTransferLimitPerUser);
        }
        if (limits.getTransferLimitPerDomain() == 0L) {
            limits.setTransferLimitPerDomain(this.defaultTransferLimitPerDomain);
        }
        return limits;
    }
}

