/*
 * Decompiled with CFR 0.152.
 */
package tigase.socks5.repository;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.TigaseDBException;
import tigase.db.beans.MDRepositoryBean;
import tigase.db.beans.MDRepositoryBeanWithStatistics;
import tigase.kernel.beans.Bean;
import tigase.osgi.ModulesManagerImpl;
import tigase.socks5.Limits;
import tigase.socks5.Socks5ConnectionType;
import tigase.socks5.Socks5ProxyComponent;
import tigase.socks5.repository.DummySocks5Repository;
import tigase.socks5.repository.Socks5Repository;
import tigase.xmpp.jid.BareJID;

@Bean(name="repository", parent=Socks5ProxyComponent.class, active=true)
public class Socks5RepositoryMDBean
extends MDRepositoryBeanWithStatistics<Socks5Repository>
implements Socks5Repository {
    private static final Logger log = Logger.getLogger(Socks5RepositoryMDBean.class.getCanonicalName());

    public Socks5RepositoryMDBean() {
        super(new Class[0]);
    }

    public Class<?> getDefaultBeanClass() {
        return Socks5RepositoryConfigBean.class;
    }

    @Override
    public Limits getTransferLimits() throws TigaseDBException {
        return ((Socks5Repository)this.getRepository("default")).getTransferLimits();
    }

    @Override
    public Limits getTransferLimits(String domain) throws TigaseDBException {
        return ((Socks5Repository)this.getRepository(domain)).getTransferLimits(domain);
    }

    @Override
    public Limits getTransferLimits(BareJID user_id) throws TigaseDBException {
        return ((Socks5Repository)this.getRepository(user_id.getDomain())).getTransferLimits();
    }

    @Override
    public long getTransferUsed() throws TigaseDBException {
        return this.repositoriesStream().mapToLong(repo -> {
            try {
                return repo.getTransferUsed();
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Could not retrieve transfer used", ex);
                return 0L;
            }
        }).sum();
    }

    @Override
    public long getTransferUsedByInstance(String instance) throws TigaseDBException {
        return this.repositoriesStream().mapToLong(repo -> {
            try {
                return repo.getTransferUsedByInstance(instance);
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Could not retrieve transfer used", ex);
                return 0L;
            }
        }).sum();
    }

    @Override
    public long getTransferUsedByDomain(String domain) throws TigaseDBException {
        return ((Socks5Repository)this.getRepository(domain)).getTransferUsedByDomain(domain);
    }

    @Override
    public long getTransferUsedByUser(BareJID user_id) throws TigaseDBException {
        return ((Socks5Repository)this.getRepository(user_id.getDomain())).getTransferUsedByUser(user_id);
    }

    @Override
    public long createTransferUsedByConnection(BareJID user_id, Socks5ConnectionType type, BareJID instance) throws TigaseDBException {
        return ((Socks5Repository)this.getRepository(user_id.getDomain())).createTransferUsedByConnection(user_id, type, instance);
    }

    @Override
    public void updateTransferUsedByConnection(BareJID user_id, long stream_id, long transferred_bytes) throws TigaseDBException {
        ((Socks5Repository)this.getRepository(user_id.getDomain())).updateTransferUsedByConnection(user_id, stream_id, transferred_bytes);
    }

    public void setDataSource(DataSource dataSource) {
    }

    protected Class<? extends Socks5Repository> findClassForDataSource(DataSource dataSource) throws DBInitException {
        return DataSourceHelper.getDefaultClass(Socks5Repository.class, (String)dataSource.getResourceUri());
    }

    public static class Socks5RepositoryConfigBean
    extends MDRepositoryBean.MDRepositoryConfigBean<Socks5Repository> {
        protected Class<?> getRepositoryClassName() throws DBInitException, ClassNotFoundException {
            String cls = this.getCls();
            if (cls == null) {
                return super.getRepositoryClassName();
            }
            switch (cls) {
                case "dummy": {
                    return DummySocks5Repository.class;
                }
            }
            return ModulesManagerImpl.getInstance().forName(cls);
        }
    }
}

