/*
 * Decompiled with CFR 0.152.
 */
package tigase.socks5;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.socks5.Socks5ConnectionManager;
import tigase.socks5.Socks5ConnectionType;
import tigase.socks5.Socks5IOService;
import tigase.xmpp.jid.JID;

public class Stream {
    private static final Logger log = Logger.getLogger(Stream.class.getCanonicalName());
    private final Socks5IOService[] conns = new Socks5IOService[2];
    private final Map<String, Object> data;
    private final Socks5ConnectionManager manager;
    private final String sid;
    private JID requester = null;
    private JID target = null;

    public Stream(String sid, Socks5ConnectionManager manager) {
        this.sid = sid;
        this.manager = manager;
        this.data = new HashMap<String, Object>();
    }

    public String getSID() {
        return this.sid;
    }

    public JID getRequester() {
        return this.requester;
    }

    public void setRequester(JID requester) {
        this.requester = requester;
    }

    public JID getTarget() {
        return this.target;
    }

    public void setTarget(JID target) {
        this.target = target;
    }

    public void setData(String key, Object value) {
        this.data.put(key, value);
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public void addConnection(Socks5IOService con) {
        int i = 0;
        con.setStream(this);
        if (this.conns[i] != null) {
            ++i;
        }
        con.setSocks5ConnectionType(i == 1 ? Socks5ConnectionType.Requester : Socks5ConnectionType.Target);
        this.conns[i] = con;
    }

    public Socks5IOService getConnection(Socks5ConnectionType connectionType) {
        return this.conns[connectionType == Socks5ConnectionType.Requester ? 1 : 0];
    }

    public void proxy(ByteBuffer buf, Socks5IOService con) throws IOException {
        if (!(con = this.conns[0] == con ? this.conns[1] : this.conns[0]).waitingToSend()) {
            con.writeBytes(buf);
        }
        buf.compact();
    }

    public boolean activate() {
        if (this.conns[0] == null || this.conns[1] == null) {
            return false;
        }
        this.conns[0].activate();
        this.conns[1].activate();
        return true;
    }

    public void close() {
        int bytesRead = 0;
        this.manager.unregisterStream(this);
        for (int i = 0; i < this.conns.length; ++i) {
            if (this.conns[i] == null) continue;
            bytesRead += this.conns[i].getBytesReceived();
            if (!this.conns[i].waitingToSend()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "stopping connection {0}, bytes read: {1}, written: {2}", new Object[]{this.conns[i], this.conns[i].getBytesReceived(), this.conns[i].getBytesSent()});
                }
                this.conns[i].stop();
                continue;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "stopping connection after flushing {0}, bytes read: {1}, written: {2}", new Object[]{this.conns[i], this.conns[i].getBytesReceived(), this.conns[i].getBytesSent()});
            }
            this.conns[i].writeData(null);
            this.conns[i].stop();
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "stream sid = {0} transferred {1} bytes", new Object[]{this.toString(), bytesRead});
        }
    }

    public int hashCodeForStream() {
        return this.sid.hashCode();
    }

    public Socks5IOService getSecondConnection(Socks5IOService con) {
        if (this.conns[0] == con) {
            return this.conns[1];
        }
        return this.conns[0];
    }

    public int getTransferredBytes() {
        int bytesTransferred = 0;
        for (Socks5IOService con : this.conns) {
            if (con == null) continue;
            bytesTransferred += con.getBytesReceived();
        }
        return bytesTransferred;
    }

    public String toString() {
        return this.sid;
    }
}

