/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.processors;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.dns.DNSResolverFactory;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.jid.JID;

@Id(value="login-history")
@Bean(name="login-history", parent=SessionManager.class, active=false)
public class LoginHistory
extends AnnotatedXMPPProcessor
implements XMPPPacketFilterIfc,
XMPPStopListenerIfc {
    protected static final String ID = "login-history";
    private static final Logger a = Logger.getLogger(LoginHistory.class.getCanonicalName());
    private static final String b = "urn:xmpp:archive";
    private final SimpleDateFormat c = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    @ConfigField(desc="Unified Archive component JID", alias="component-jid")
    private JID componentJid = JID.jidInstanceNS((String)"unified-archive", (String)DNSResolverFactory.getInstance().getDefaultHost(), null);

    public LoginHistory() {
        this.c.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public JID getComponentJid() {
        return this.componentJid;
    }

    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (packet == null) {
            return;
        }
        if (session == null) {
            return;
        }
        if (packet.getElement().findChildStaticStr(Iq.IQ_BIND_PATH) == null) {
            return;
        }
        if (session.getResource() == null) {
            return;
        }
        boolean bl = true;
        for (Packet packet2 : results) {
            Element element = packet2.getElement().findChildStaticStr(Iq.IQ_BIND_PATH);
            if (element == null || element.getChild("jid") == null) continue;
            bl = false;
        }
        if (!bl) {
            this.a(session, results, tigase.archive.unified.processors.LoginHistory$a.a);
        }
    }

    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null || session.isServerSession()) {
            return;
        }
        this.a(session, results, tigase.archive.unified.processors.LoginHistory$a.b);
    }

    private void a(XMPPResourceConnection xMPPResourceConnection, Queue<Packet> queue, a a2) {
        try {
            String string = this.c.format(new Date());
            Element element = new Element("from", new String[]{"secs", "item-type", "type"}, new String[]{"0", a2.name(), StanzaType.set.name()});
            Element element2 = new Element("bind", xMPPResourceConnection.getResource());
            element2.addAttribute("action", a2.name());
            element.addChild((XMLNodeIfc)element2);
            Packet packet = this.a(xMPPResourceConnection.getJID(), xMPPResourceConnection.getJID(), string, element);
            queue.offer(packet);
        }
        catch (NotAuthorizedException notAuthorizedException) {
            a.log(Level.FINE, "could not store info about login event, should not happen", notAuthorizedException);
        }
    }

    private Packet a(JID jID, JID jID2, String string, Element ... elementArray) {
        Element element = new Element("iq", new String[]{"from", "to", "type", "xmlns"}, new String[]{jID.toString(), this.componentJid.toString(), StanzaType.set.name(), "jabber:client"});
        Element element2 = new Element("save", new String[]{"xmlns", "auto"}, new String[]{b, "true"});
        element.addChild((XMLNodeIfc)element2);
        Element element3 = new Element("chat", new String[]{"with", "start"}, new String[]{jID2.toString(), string});
        element2.addChild((XMLNodeIfc)element3);
        for (Element element4 : elementArray) {
            element3.addChild((XMLNodeIfc)element4);
        }
        return new Iq(element, jID, this.componentJid);
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        private static final /* synthetic */ a[] c;

        public static a[] a() {
            return (a[])c.clone();
        }

        public static a a(String string) {
            return Enum.valueOf(a.class, string);
        }

        static {
            c = new a[]{a, b};
        }
    }
}

