/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.processors;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.xmppsession.PacketDefaultHandler;
import tigase.server.xmppsession.SessionManager;
import tigase.util.dns.DNSResolverFactory;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.jid.JID;

@Id(value="jingle-archive")
@Handles(value={@Handle(path={"iq", "jingle"}, xmlns="urn:xmpp:jingle:1"), @Handle(path={"message", "propose"}, xmlns="urn:xmpp:jingle-message:0"), @Handle(path={"message", "retract"}, xmlns="urn:xmpp:jingle-message:0"), @Handle(path={"message", "proceed"}, xmlns="urn:xmpp:jingle-message:0")})
@Bean(name="jingle-archive", parent=SessionManager.class, active=false)
public class JingleArchive
extends AnnotatedXMPPProcessor
implements XMPPPostprocessorIfc,
XMPPProcessorIfc {
    public static final String JINGLE_XMLNS = "urn:xmpp:jingle:1";
    public static final String TIGASE_ARCHIVE_JINGLE_XMLNS = "tigase:archive:jingle";
    public static final String OMIT_JINGLE_XMLNS_KEY = "omit-jingle-xmlns";
    public static final String[] OMIT_JINGLE_XMLNS_SUP_XMLNSS = new String[]{"urn:xmpp:jingle:1", "tigase:archive:jingle"};
    protected static final String ID = "jingle-archive";
    protected static final String JINGLE_EL = "jingle";
    protected static final String[] JINGLE_PATH = new String[]{"iq", "jingle"};
    public static final String[][] OMIT_JINGLE_XMLNS_SUP_PATHS = new String[][]{JINGLE_PATH, {"iq", "jingle"}};
    protected static final String JINGLE_MESSAGE_XMLNS = "urn:xmpp:jingle-message:0";
    private static final Logger a = Logger.getLogger(JingleArchive.class.getCanonicalName());
    private static final String b = "archive-jingle-message";
    private static final String c = "urn:xmpp:archive";
    private static final String d = "content";
    private static final String[] e = new String[]{"jingle", "content"};
    private static final String[] f = new String[]{"content", "description"};
    private final SimpleDateFormat g = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    @ConfigField(desc="Archive jingle messages", alias="archive-jingle-message")
    private Boolean archiveJingleMessage = true;
    @ConfigField(desc="Unified Archive component JID", alias="component-jid")
    private JID componentJid = JID.jidInstanceNS((String)"unified-archive", (String)DNSResolverFactory.getInstance().getDefaultHost(), null);
    private PacketDefaultHandler h = new PacketDefaultHandler();
    @ConfigField(desc="Replace Jingle XMLNS in stored entries with tigase:archive:jingle")
    private boolean omitJingleXMLNS = false;

    public JingleArchive() {
        this.g.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public Authorization canHandle(Packet packet, XMPPResourceConnection conn) {
        return conn == null ? null : super.canHandle(packet, conn);
    }

    public void process(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (conn != null) {
            Element element = packet.getElement().findChildStaticStr(JINGLE_PATH);
            if (element != null) {
                this.a(packet, conn, results, element);
            } else {
                Element element2 = this.a(packet);
                if (element2 != null) {
                    this.b(packet, conn, results, element2);
                }
            }
            this.h.process(packet, conn, repo, results);
        }
    }

    public void postProcess(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository repo, Queue<Packet> queue, Map<String, Object> settings) {
        if (conn == null) {
            try {
                Element element = packet.getElement().findChildStaticStr(JINGLE_PATH);
                if (element != null) {
                    this.a(packet, conn, queue, element);
                } else {
                    Element element2 = this.a(packet);
                    if (element2 != null) {
                        this.b(packet, conn, queue, element2);
                    }
                }
            }
            catch (NotAuthorizedException notAuthorizedException) {
                a.log(Level.SEVERE, "should not happen", notAuthorizedException);
            }
        }
    }

    public String[][] supElementNamePaths() {
        if (this.omitJingleXMLNS) {
            return OMIT_JINGLE_XMLNS_SUP_PATHS;
        }
        return super.supElementNamePaths();
    }

    public String[] supNamespaces() {
        if (this.omitJingleXMLNS) {
            return OMIT_JINGLE_XMLNS_SUP_XMLNSS;
        }
        return super.supNamespaces();
    }

    private void a(Packet packet, XMPPResourceConnection xMPPResourceConnection, Queue<Packet> queue, Element element2) throws NotAuthorizedException {
        Date date2;
        if (packet.getType() != StanzaType.set) {
            return;
        }
        String string = element2.getAttributeStaticStr("sid");
        String string2 = element2.getAttributeStaticStr("action");
        String string3 = element2.getAttributeStaticStr(d);
        List list = element2.findChildren(element -> element.getName() == d);
        if (list != null) {
            for (Date date2 : list) {
                String string4 = date2.getAttributeStaticStr(f, "media");
                if (string4 == null) {
                    string4 = date2.getAttributeStaticStr("name");
                }
                if (string4 == null || "video".equals(string3)) continue;
                string3 = string4;
            }
        }
        Element element3 = element2.findChild(element -> element.getName() == "reason");
        date2 = new Date();
        this.a(xMPPResourceConnection, queue, packet.getStanzaFrom(), packet.getStanzaTo(), packet.getAttributeStaticStr("id"), string, date2, string2, string3, element3, xMPPResourceConnection == null || element2.getAttributeStaticStr("offline") != null);
    }

    private void a(XMPPResourceConnection xMPPResourceConnection, Queue<Packet> queue, JID jID, JID jID2, String string, String string2, Date date, String string3, String string4, Element element2, boolean bl) throws NotAuthorizedException {
        if (!this.a(xMPPResourceConnection, string2, string3)) {
            return;
        }
        boolean bl2 = xMPPResourceConnection == null || !xMPPResourceConnection.isUserId(jID.getBareJID());
        String string5 = bl2 ? "from" : "to";
        String string6 = this.a(xMPPResourceConnection, string4);
        String string7 = this.b(xMPPResourceConnection, string2, string4);
        String string8 = this.g.format(date);
        Element element3 = new Element(string5, new String[]{"secs", "item-type", "type"}, new String[]{"0", string6, StanzaType.set.name()});
        if (string != null) {
            element3.addAttribute("id", string);
        }
        Element element4 = new Element(JINGLE_EL, new String[]{"sid", "action"}, new String[]{string2, string3});
        if (!this.omitJingleXMLNS) {
            element4.setXMLNS(JINGLE_XMLNS);
        } else {
            element4.setXMLNS(TIGASE_ARCHIVE_JINGLE_XMLNS);
        }
        if (string7 != null) {
            element4.addAttribute(d, string7);
        }
        if (bl) {
            element4.addAttribute("offline", "true");
        }
        if (xMPPResourceConnection == null) {
            element3.addAttribute("tigase-offline", "true");
        }
        if (element2 != null) {
            element2 = element2.clone();
            if (this.omitJingleXMLNS) {
                element2.setXMLNS(null);
                element2.findChildren(element -> element.getXMLNS() == JINGLE_XMLNS).forEach(element -> element.setXMLNS(null));
            }
            element4.addChild((XMLNodeIfc)element2);
        }
        element3.addChild((XMLNodeIfc)element4);
        Packet packet = this.a(bl2 ? jID2 : jID, bl2 ? jID : jID2, string8, element3);
        if (packet != null) {
            a.log(Level.FINEST, "{0}, sending to store {1}", new Object[]{xMPPResourceConnection, packet});
            queue.offer(packet);
        }
    }

    private boolean a(XMPPResourceConnection xMPPResourceConnection, String string, String string2) {
        if (string2 != null) {
            switch (string2) {
                case "session-initiate": 
                case "session-accept": 
                case "session-terminate": {
                    return true;
                }
                case "propose": 
                case "retract": 
                case "proceed": {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private String a(XMPPResourceConnection xMPPResourceConnection, String string) {
        return "call";
    }

    private String b(XMPPResourceConnection xMPPResourceConnection, String string, String string2) {
        return string2;
    }

    private Packet a(JID jID, JID jID2, String string, Element ... elementArray) {
        Element element = new Element("iq", new String[]{"from", "to", "type", "xmlns"}, new String[]{jID.toString(), this.componentJid.toString(), StanzaType.set.name(), "jabber:client"});
        Element element2 = new Element("save", new String[]{"xmlns", "auto"}, new String[]{c, "true"});
        element.addChild((XMLNodeIfc)element2);
        Element element3 = new Element("chat", new String[]{"with", "start"}, new String[]{jID2.toString(), string});
        element2.addChild((XMLNodeIfc)element3);
        for (Element element4 : elementArray) {
            element3.addChild((XMLNodeIfc)element4);
        }
        return new Iq(element, jID, this.componentJid);
    }

    private Element a(Packet packet) {
        if (packet.getElemName() != "message") {
            return null;
        }
        List list = packet.getElement().getChildren();
        if (list == null) {
            return null;
        }
        for (Element element : list) {
            if (JINGLE_MESSAGE_XMLNS != element.getXMLNS()) continue;
            return element;
        }
        return null;
    }

    private void b(Packet packet, XMPPResourceConnection xMPPResourceConnection, Queue<Packet> queue, Element element) throws NotAuthorizedException {
        String string = element.getAttributeStaticStr("id");
        String string2 = element.getName();
        String string3 = element.getChildAttributeStaticStr(string2, "media");
        Date date = new Date();
        this.a(xMPPResourceConnection, queue, packet.getStanzaFrom(), packet.getStanzaTo(), packet.getAttributeStaticStr("id"), string, date, string2, string3, null, xMPPResourceConnection == null);
    }
}

