/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db.derby;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;
import tigase.xmpp.jid.BareJID;

public class StoredProcedures
extends tigase.archive.db.derby.StoredProcedures {
    private static final Logger a = Logger.getLogger(StoredProcedures.class.getName());

    public static void addItem(String ownerJid, String buddyJid, Timestamp ts, String stableId, String stanzaId, String refStableId, String body, String msg, Integer itemType, Integer offline) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            long l = StoredProcedures.ensureJid((String)ownerJid);
            long l2 = StoredProcedures.ensureJid((String)buddyJid);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into tig_ma_msgs (owner_id, buddy_id, ts, stable_id, stanza_id, is_ref, ref_stable_id, body, msg, item_type, offline) select ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? from SYSIBM.SYSDUMMY1 where not exists ( select 1 from tig_ma_msgs where owner_id = ? and stable_id = ?)");
            int n = 0;
            preparedStatement.setLong(++n, l);
            preparedStatement.setLong(++n, l2);
            preparedStatement.setTimestamp(++n, ts);
            preparedStatement.setString(++n, stableId);
            preparedStatement.setString(++n, stanzaId);
            preparedStatement.setShort(++n, (short)(refStableId != null ? 1 : 0));
            preparedStatement.setString(++n, refStableId);
            preparedStatement.setString(++n, body);
            preparedStatement.setString(++n, msg);
            preparedStatement.setShort(++n, itemType.shortValue());
            preparedStatement.setInt(++n, offline);
            preparedStatement.setLong(++n, l);
            preparedStatement.setString(++n, stableId);
            preparedStatement.executeUpdate();
        }
    }

    public static void addItemJingle(String ownerJid, String stableId, String sid, String action, String reason, Integer offline, Integer direction) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            long l = StoredProcedures.ensureJid((String)ownerJid);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into tig_ua_jingle (owner_id, stable_id, sid, action, reason, offline, direction) select ?, ?, ?, ?, ?, ?, ? from SYSIBM.SYSDUMMY1 where not exists ( select 1 from tig_ma_msgs where owner_id = ? and stable_id = ?)");
            int n = 0;
            preparedStatement.setLong(++n, l);
            preparedStatement.setString(++n, stableId);
            preparedStatement.setString(++n, sid);
            preparedStatement.setString(++n, action);
            preparedStatement.setString(++n, reason);
            preparedStatement.setInt(++n, offline);
            preparedStatement.setInt(++n, direction);
            preparedStatement.setLong(++n, l);
            preparedStatement.setString(++n, stableId);
            preparedStatement.executeUpdate();
        }
    }

    public static void addItemOffline(String ownerJid, String stableId, String buddyRes) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            long l = StoredProcedures.ensureJid((String)ownerJid);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into tig_ua_for (owner_id, stable_id, buddy_res) select ?, ?, ? from SYSIBM.SYSDUMMY1 where not exists ( select 1 from tig_ma_msgs where owner_id = ? and stable_id = ?)");
            int n = 0;
            preparedStatement.setLong(++n, l);
            preparedStatement.setString(++n, stableId);
            preparedStatement.setString(++n, buddyRes);
            preparedStatement.setLong(++n, l);
            preparedStatement.setString(++n, stableId);
            preparedStatement.executeUpdate();
        }
    }

    public static void for_GetMessages(String ownerJid, String msgIds, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            Object object = "select m.msg as message, m.stable_id from tig_ma_msgs m inner join tig_ma_jids o on o.jid_id = m.owner_id where o.jid_sha1 = ? and m.offline >= 1";
            if (msgIds != null) {
                object = (String)object + " and m.stable_id in (" + msgIds + ")";
            }
            PreparedStatement preparedStatement = connection.prepareStatement((String)object);
            preparedStatement.setString(1, StoredProcedures.sha1OfLower((String)ownerJid));
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void for_GetMessagesCount(String ownerJid, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("select item_type, count(1) from tig_ma_msgs m inner join tig_ma_jids o on o.jid_id = m.owner_id where o.jid_sha1 = ? and m.offline >= 1 group by item_type");
            preparedStatement.setString(1, StoredProcedures.sha1OfLower((String)ownerJid));
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void for_GetMessagesList(String ownerJid, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("select b.jid, f.buddy_res, m.stable_id, m.item_type from tig_ma_msgs m inner join tig_ma_jids o on o.jid_id = m.owner_id inner join tig_ma_jids b on b.jid_id = m.buddy_id inner join tig_ua_for f on f.owner_id = m.owner_id and f.stable_id = m.stable_id where o.jid_sha1 = ? and m.offline >= 1");
            preparedStatement.setString(1, StoredProcedures.sha1OfLower((String)ownerJid));
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void for_RemoveMessages(String ownerJid, String msgIds) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)ownerJid);
            Long l = StoredProcedures.getJidId((BareJID)bareJID, (String)StoredProcedures.sha1OfLower((String)ownerJid));
            if (l == null) {
                return;
            }
            Object object = "delete from tig_ua_for where owner_id = ?";
            if (msgIds != null) {
                object = (String)object + " and stable_id in (" + msgIds + ")";
            }
            PreparedStatement preparedStatement = connection.prepareStatement((String)object);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            object = "delete from tig_ma_msgs where offline >= 1 and owner_id = ?";
            if (msgIds != null) {
                object = (String)object + " and stable_id in (" + msgIds + ")";
            }
            preparedStatement = connection.prepareStatement((String)object);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
    }

    public static void for_UnmarkOfflineMessages(String ownerJid, String msgIds) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)ownerJid);
            Long l = StoredProcedures.getJidId((BareJID)bareJID, (String)StoredProcedures.sha1OfLower((String)ownerJid));
            if (l == null) {
                return;
            }
            Object object = "delete from tig_ua_for where owner_id = ?";
            if (msgIds != null) {
                object = (String)object + " and stable_id in (" + msgIds + ")";
            }
            PreparedStatement preparedStatement = connection.prepareStatement((String)object);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            object = "delete from tig_ma_msgs  where offline = 2 and owner_id = ?";
            if (msgIds != null) {
                object = (String)object + " and stable_id in (" + msgIds + ")";
            }
            preparedStatement = connection.prepareStatement((String)object);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            object = "update tig_ma_msgs set offline = 0 where offline = 1 and owner_id = ?";
            if (msgIds != null) {
                object = (String)object + " and stable_id in (" + msgIds + ")";
            }
            preparedStatement = connection.prepareStatement((String)object);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
    }

    public static void getCollections(String ownerJid, String buddyJid, Timestamp from, Timestamp to, String tags, String contains, Integer byType, Integer itemType, Integer offline, Integer limit, Integer offset, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select min(m.ts), b.jid");
            if (byType == 1) {
                stringBuilder.append(", case when m.item_type = 2 then 2 else 0 end as \"type\"");
            } else {
                stringBuilder.append(", 0 as \"type\"");
            }
            stringBuilder.append(" from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                stringBuilder.append(" and b.jid_sha1 = ?");
            }
            stringBuilder.append(" and (m.is_ref = 0 or m.is_ref = 1)");
            if (from != null) {
                stringBuilder.append(" and m.ts >= ?");
            }
            if (to != null) {
                stringBuilder.append(" and m.ts <= ?");
            }
            if (itemType != null) {
                if (itemType == 0) {
                    stringBuilder.append(" and m.item_type IN (?,1,2)");
                } else {
                    stringBuilder.append(" and m.item_type = ?");
                }
            }
            if (offline != null) {
                stringBuilder.append(" and m.offline = ?");
            }
            stringBuilder.append(" and m.offline <> 2");
            StoredProcedures.appendTagsQuery((StringBuilder)stringBuilder, (String)tags);
            StoredProcedures.appendContainsQuery((StringBuilder)stringBuilder, (String)contains);
            if (byType == 1) {
                stringBuilder.append(" group by date(m.ts), m.buddy_id, b.jid, case when m.item_type = 2 then 2 else 0 end");
            } else {
                stringBuilder.append(" group by date(m.ts), m.buddy_id, b.jid");
            }
            stringBuilder.append(" order by min(m.ts), b.jid");
            stringBuilder.append(" offset ? rows fetch next ? rows only");
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 0;
            preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
            if (buddyJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)buddyJid));
            }
            if (from != null) {
                preparedStatement.setTimestamp(++n, from);
            }
            if (to != null) {
                preparedStatement.setTimestamp(++n, to);
            }
            if (itemType != null) {
                preparedStatement.setShort(++n, itemType.shortValue());
            }
            if (offline != null) {
                preparedStatement.setInt(++n, offline);
            }
            preparedStatement.setInt(++n, offset);
            preparedStatement.setInt(++n, limit);
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void getCollectionsCount(String ownerJid, String buddyJid, Timestamp from, Timestamp to, String tags, String contains, Integer byType, Integer itemType, Integer offline, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select count(1) from (select min(m.ts), b.jid");
            if (byType == 1) {
                stringBuilder.append(", case when m.item_type = 2 then 2 else 0 end as \"type\"");
            } else {
                stringBuilder.append(", cast(null as varchar(20)) as \"type\"");
            }
            stringBuilder.append(" from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                stringBuilder.append(" and b.jid_sha1 = ?");
            }
            stringBuilder.append(" and (m.is_ref = 0 or m.is_ref = 1)");
            if (from != null) {
                stringBuilder.append(" and m.ts >= ?");
            }
            if (to != null) {
                stringBuilder.append(" and m.ts <= ?");
            }
            if (itemType != null) {
                if (itemType == 0) {
                    stringBuilder.append(" and m.item_type IN (?,1,2)");
                } else {
                    stringBuilder.append(" and m.item_type = ?");
                }
            }
            if (offline != null) {
                stringBuilder.append(" and m.offline = ?");
            }
            stringBuilder.append(" and m.offline <> 2");
            StoredProcedures.appendTagsQuery((StringBuilder)stringBuilder, (String)tags);
            StoredProcedures.appendContainsQuery((StringBuilder)stringBuilder, (String)contains);
            if (byType == 1) {
                stringBuilder.append(" group by date(m.ts), m.buddy_id, b.jid, case when m.item_type = 2 then 2 else 0 end");
            } else {
                stringBuilder.append(" group by date(m.ts), m.buddy_id, b.jid");
            }
            stringBuilder.append(") x");
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 0;
            preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
            if (buddyJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)buddyJid));
            }
            if (from != null) {
                preparedStatement.setTimestamp(++n, from);
            }
            if (to != null) {
                preparedStatement.setTimestamp(++n, to);
            }
            if (itemType != null) {
                preparedStatement.setShort(++n, itemType.shortValue());
            }
            if (offline != null) {
                preparedStatement.setInt(++n, offline);
            }
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void getItemPosition(String ownerJid, String buddyJid, Timestamp from, Timestamp to, short refType, String tags, String contains, String stableId, Integer itemType, Integer offline, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select m.stable_id, row_number() over () as position from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                stringBuilder.append(" and b.jid_sha1 = ?");
            }
            if (refType == 1) {
                stringBuilder.append(" and (m.is_ref = 0 or m.is_ref = 1)");
            } else {
                stringBuilder.append(" and (m.is_ref = 0)");
            }
            if (from != null) {
                stringBuilder.append(" and m.ts >= ?");
            }
            if (to != null) {
                stringBuilder.append(" and m.ts <= ?");
            }
            if (itemType != null) {
                if (itemType == 0) {
                    stringBuilder.append(" and m.item_type IN (?,1,2)");
                } else {
                    stringBuilder.append(" and m.item_type = ?");
                }
            }
            if (offline != null) {
                stringBuilder.append(" and m.offline = ?");
            }
            stringBuilder.append(" and m.offline <> 2");
            StoredProcedures.appendTagsQuery((StringBuilder)stringBuilder, (String)tags);
            StoredProcedures.appendContainsQuery((StringBuilder)stringBuilder, (String)contains);
            stringBuilder.append(" order by m.ts");
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 0;
            preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
            if (buddyJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)buddyJid));
            }
            if (from != null) {
                preparedStatement.setTimestamp(++n, from);
            }
            if (to != null) {
                preparedStatement.setTimestamp(++n, to);
            }
            if (itemType != null) {
                preparedStatement.setShort(++n, itemType.shortValue());
            }
            if (offline != null) {
                preparedStatement.setInt(++n, offline);
            }
            n = 0;
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (!stableId.equals(resultSet.getString(1))) continue;
                n = resultSet.getInt(2);
                break;
            }
            resultSet.close();
            String string = "select " + n + " as position from SYSIBM.SYSDUMMY1 where " + n + " <> 0";
            data[0] = connection.prepareStatement(string).executeQuery();
        }
    }

    public static void getItems(String ownerJid, String buddyJid, Timestamp from, Timestamp to, short refType, String tags, String contains, Integer itemType, Integer offline, Integer limit, Integer offset, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select m.msg, m.ts, b.jid, m.stable_id, m.ref_stable_id, m.item_type from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                stringBuilder.append(" and b.jid_sha1 = ?");
            }
            if (refType == 1) {
                stringBuilder.append(" and (m.is_ref = 0 or m.is_ref = 1)");
            } else {
                stringBuilder.append(" and (m.is_ref = 0)");
            }
            if (from != null) {
                stringBuilder.append(" and m.ts >= ?");
            }
            if (to != null) {
                stringBuilder.append(" and m.ts <= ?");
            }
            if (itemType != null) {
                if (itemType == 0) {
                    stringBuilder.append(" and m.item_type IN (?,1,2)");
                } else {
                    stringBuilder.append(" and m.item_type = ?");
                }
            }
            if (offline != null) {
                stringBuilder.append(" and m.offline = ?");
            }
            stringBuilder.append(" and m.offline <> 2");
            StoredProcedures.appendTagsQuery((StringBuilder)stringBuilder, (String)tags);
            StoredProcedures.appendContainsQuery((StringBuilder)stringBuilder, (String)contains);
            stringBuilder.append(" order by m.ts");
            stringBuilder.append(" offset ? rows fetch next ? rows only");
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 0;
            preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
            if (buddyJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)buddyJid));
            }
            if (from != null) {
                preparedStatement.setTimestamp(++n, from);
            }
            if (to != null) {
                preparedStatement.setTimestamp(++n, to);
            }
            if (itemType != null) {
                preparedStatement.setShort(++n, itemType.shortValue());
            }
            if (offline != null) {
                preparedStatement.setInt(++n, offline);
            }
            preparedStatement.setInt(++n, offset);
            preparedStatement.setInt(++n, limit);
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void getItemsCount(String ownerJid, String buddyJid, Timestamp from, Timestamp to, short refType, String tags, String contains, Integer itemType, Integer offline, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select count(1) from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                stringBuilder.append(" and b.jid_sha1 = ?");
            }
            if (refType == 1) {
                stringBuilder.append(" and (m.is_ref = 0 or m.is_ref = 1)");
            } else {
                stringBuilder.append(" and (m.is_ref = 0)");
            }
            if (from != null) {
                stringBuilder.append(" and m.ts >= ?");
            }
            if (to != null) {
                stringBuilder.append(" and m.ts <= ?");
            }
            if (itemType != null) {
                if (itemType == 0) {
                    stringBuilder.append(" and m.item_type IN (?,1,2)");
                } else {
                    stringBuilder.append(" and m.item_type = ?");
                }
            }
            if (offline != null) {
                stringBuilder.append(" and m.offline = ?");
            }
            stringBuilder.append(" and m.offline <> 2");
            StoredProcedures.appendTagsQuery((StringBuilder)stringBuilder, (String)tags);
            StoredProcedures.appendContainsQuery((StringBuilder)stringBuilder, (String)contains);
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 0;
            preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
            if (buddyJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)buddyJid));
            }
            if (from != null) {
                preparedStatement.setTimestamp(++n, from);
            }
            if (to != null) {
                preparedStatement.setTimestamp(++n, to);
            }
            if (itemType != null) {
                preparedStatement.setShort(++n, itemType.shortValue());
            }
            if (offline != null) {
                preparedStatement.setInt(++n, offline);
            }
            data[0] = preparedStatement.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryRecent(String ownerJid, Timestamp start, Timestamp end, Integer chat, Integer groupchat, Integer call, Integer call_success, Integer call_missed, Integer call_canceled, Integer limit, Integer offset, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("select b2.jid, m2.ts, m2.msg, m2.item_type,   case  when m2.item_type <> 132 then null    when j2.action='session-accept' or (j2.action='session-terminate' and j2.reason = 'success') then 'success'    when j2.offline = 1     or (j2.action = 'session-terminate' and (      j2.reason = 'busy' or j2.reason = 'timeout'      or j2.reason = 'failed-application'      or (j2.reason = 'cancel' and j2.direction = 1 and ac.stable_id is null)     ))     or j2.action = 'session-initiate' then 'missed'    else 'canceled'   end as condition,   m2.stable_id,   {fn timestampdiff(SQL_TSI_FRAC_SECOND, ac.ts, m2.ts)} as duration from ( select x2.owner_id, x2.stable_id from ( select x1.owner_id, x1.buddy_id, max(x1.ts) as ts from  (select   m1.stable_id, m1.owner_id, m1.buddy_id, m1.ts, m1.item_type,   case    when m1.item_type <> 132 then null    when j1.action='session-accept' or (j1.action='session-terminate' and j1.reason = 'success') then 'success'    when j1.offline = 1     or (j1.action = 'session-terminate' and (      j1.reason = 'busy' or j1.reason = 'timeout'      or j1.reason = 'failed-application'      or (j1.reason = 'cancel' and j1.direction = 1 and      not exists(select 1 from tig_ma_msgs m0 inner join tig_ua_jingle j0 on j0.owner_id = m0.owner_id and j0.stable_id = m0.stable_id where m0.owner_id = m1.owner_id and m0.buddy_id = m1.buddy_id and j0.sid = j1.sid and j0.action = 'session-accept' and m0.ts < m1.ts))     ))     or j1.action = 'session-initiate' then 'missed'    else 'canceled'   end as condition  from tig_ma_msgs m1 left join tig_ua_jingle j1 on j1.owner_id = m1.owner_id and j1.stable_id = m1.stable_id where m1.owner_id = (select jid_id from tig_ma_jids where jid = ?)      and (? is null or ts >= ?)      and (? is null or ts <= ?) \t and m1.offline <> 2  ) as x1 where  (1=? and x1.item_type = 1)  or (1=? and x1.item_type = 2)  or (1=? and x1.item_type = 132 and (   (1=? and x1.condition = 'success')   or (1=? and x1.condition = 'missed')   or (1=? and x1.condition = 'canceled')  ))  group by x1.owner_id, x1.buddy_id ) as x inner join tig_ma_msgs x2 on x2.owner_id = x.owner_id and x2.buddy_id = x.buddy_id and x2.ts = x.ts and not exists (select 1 from tig_ma_msgs x3 where x3.owner_id = x2.owner_id and x3.buddy_id = x2.buddy_id and x3.ts >= x2.ts and x3.stable_id > x2.stable_id) ) as y inner join tig_ma_msgs m2 on m2.owner_id = y.owner_id and m2.stable_id = y.stable_id inner join tig_ma_jids b2 on b2.jid_id = m2.buddy_id left join tig_ua_jingle j2 on j2.owner_id = m2.owner_id and j2.stable_id = m2.stable_id left join tig_ua_jingle acj on acj.owner_id = m2.owner_id and acj.sid = j2.sid and j2.action = 'session-accept' left outer join tig_ma_msgs ac on ac.owner_id = m2.owner_id and ac.stable_id = acj.stable_id and ac.buddy_id = m2.buddy_id order by m2.ts desc offset ? rows fetch next ? rows only");
            preparedStatement.setString(1, ownerJid.toString());
            preparedStatement.setTimestamp(2, start);
            preparedStatement.setTimestamp(3, start);
            preparedStatement.setTimestamp(4, end);
            preparedStatement.setTimestamp(5, end);
            preparedStatement.setInt(6, chat);
            preparedStatement.setInt(7, groupchat);
            preparedStatement.setInt(8, call);
            preparedStatement.setInt(9, call_success);
            preparedStatement.setInt(10, call_missed);
            preparedStatement.setInt(11, call_canceled);
            preparedStatement.setInt(12, offset);
            preparedStatement.setInt(13, limit);
            data[0] = preparedStatement.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryRecentCount(String ownerJid, Timestamp start, Timestamp end, Integer chat, Integer groupchat, Integer call, Integer call_success, Integer call_missed, Integer call_canceled, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("select count(1) from ( select max(x2.ts) as ts from ( select x1.owner_id, x1.buddy_id, max(x1.ts) as ts from  (select   m1.stable_id, m1.owner_id, m1.buddy_id, m1.ts, m1.item_type,   case    when m1.item_type <> 132 then null    when j1.action='session-accept' or (j1.action='session-terminate' and j1.reason = 'success') then 'success'    when j1.offline = 1     or (j1.action = 'session-terminate' and (      j1.reason = 'busy' or j1.reason = 'timeout'      or j1.reason = 'failed-application'      or (j1.reason = 'cancel' and j1.direction = 1 and not exists(select 1 from tig_ma_msgs m0 inner join tig_ua_jingle j0 on j0.owner_id = m0.owner_id and j0.stable_id = m0.stable_id where m0.owner_id = m1.owner_id and m0.buddy_id = m1.buddy_id and j0.sid = j1.sid and j0.action = 'session-accept' and m0.ts < m1.ts))     ))     or j1.action = 'session-initiate' then 'missed'    else 'canceled'   end as condition  from tig_ma_msgs m1 left join tig_ua_jingle j1 on j1.owner_id = m1.owner_id and j1.stable_id = m1.stable_id  where m1.owner_id = (select jid_id from tig_ma_jids where jid = ?)  and (? is null or ts >= ?)  and (? is null or ts <= ?)  and m1.offline <> 2  ) as x1 where  (1=? and x1.item_type = 1)  or (1=? and x1.item_type = 2)  or (1=? and x1.item_type = 132 and (   (1=? and x1.condition = 'success')   or (1=? and x1.condition = 'missed')   or (1=? and x1.condition = 'canceled')  )) group by x1.owner_id, x1.buddy_id ) as x inner join tig_ma_msgs x2 on x2.owner_id = x.owner_id and x2.buddy_id = x.buddy_id and x2.ts = x.ts group by x.owner_id, x.buddy_id ) as y");
            preparedStatement.setString(1, ownerJid.toString());
            preparedStatement.setTimestamp(2, start);
            preparedStatement.setTimestamp(3, start);
            preparedStatement.setTimestamp(4, end);
            preparedStatement.setTimestamp(5, end);
            preparedStatement.setInt(6, chat);
            preparedStatement.setInt(7, groupchat);
            preparedStatement.setInt(8, call);
            preparedStatement.setInt(9, call_success);
            preparedStatement.setInt(10, call_missed);
            preparedStatement.setInt(11, call_canceled);
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void fm_AddItem(String ownerJid, String stableId, String urlHash, String url, String mediaType, String name, String description, Long size) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            long l = StoredProcedures.ensureJid((String)ownerJid);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into tig_ua_file_metadata (owner_id, stable_id, url_hash, url, media_type, name, description, size) values (?, ?, ?, ?, ?, ?, ?, ?)");
            int n = 0;
            preparedStatement.setLong(++n, l);
            preparedStatement.setString(++n, stableId);
            preparedStatement.setString(++n, urlHash);
            preparedStatement.setString(++n, url);
            preparedStatement.setString(++n, mediaType);
            preparedStatement.setString(++n, name);
            preparedStatement.setString(++n, description);
            if (size != null) {
                preparedStatement.setLong(++n, size);
            } else {
                preparedStatement.setNull(++n, -5);
            }
            preparedStatement.executeUpdate();
        }
    }

    public static void fm_QueryItems(String domain, String ownerJid, String buddyJid, Timestamp after, Timestamp before, String contains, String mediaTypeContains, Long smallerThan, Long biggerThan, Integer limit, Integer offset, ResultSet[] results) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder stringBuilder = new StringBuilder("select o.jid, b.jid, m.ts, m.stable_id, fm.url, fm.media_type, fm.name, fm.description, fm.size from tig_ma_msgs m inner join tig_ma_jids o on o.jid_id = m.owner_id inner join tig_ma_jids b on b.jid_id = m.buddy_id inner join tig_ua_file_metadata fm on fm.owner_id = m.owner_id and fm.stable_id = m.stable_id where 1=1");
            if (domain != null) {
                stringBuilder.append(" and o.\"domain\" = ?");
            }
            if (ownerJid != null) {
                stringBuilder.append(" and o.jid_sha1 = ?");
            }
            if (buddyJid != null) {
                stringBuilder.append(" and b.jid_sha1 = ?");
            }
            if (after != null) {
                stringBuilder.append(" and m.ts >= ?");
            }
            if (before != null) {
                stringBuilder.append(" and m.ts <= ?");
            }
            if (smallerThan != null) {
                stringBuilder.append(" and fm.size < ?");
            }
            if (biggerThan != null) {
                stringBuilder.append(" and fm.size > ?");
            }
            if (mediaTypeContains != null) {
                stringBuilder.append(" and fm.media_type like ?");
            }
            if (contains != null) {
                stringBuilder.append(" and (fm.name like ? or fm.description like ? or fm.url like ?)");
            }
            stringBuilder.append(" order by m.ts asc").append(" offset ? rows fetch next ? rows only");
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 0;
            if (domain != null) {
                preparedStatement.setString(++n, domain);
            }
            if (ownerJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
            }
            if (buddyJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)buddyJid));
            }
            if (after != null) {
                preparedStatement.setTimestamp(++n, after);
            }
            if (before != null) {
                preparedStatement.setTimestamp(++n, before);
            }
            if (smallerThan != null) {
                preparedStatement.setLong(++n, smallerThan);
            }
            if (biggerThan != null) {
                preparedStatement.setLong(++n, biggerThan);
            }
            if (mediaTypeContains != null) {
                preparedStatement.setString(++n, "%" + mediaTypeContains + "%");
            }
            if (contains != null) {
                String string = "%" + contains + "%";
                preparedStatement.setString(++n, contains);
                preparedStatement.setString(++n, contains);
                preparedStatement.setString(++n, contains);
            }
            preparedStatement.setInt(++n, offset);
            preparedStatement.setInt(++n, limit);
            results[0] = preparedStatement.executeQuery();
        }
    }

    public static void fm_QueryItemsCount(String domain, String ownerJid, String buddyJid, Timestamp after, Timestamp before, String contains, String mediaTypeContains, Long smallerThan, Long biggerThan, String beforeStableId, ResultSet[] results) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder stringBuilder = new StringBuilder("select count(1) from tig_ma_msgs m inner join tig_ma_jids o on o.jid_id = m.owner_id inner join tig_ma_jids b on b.jid_id = m.buddy_id inner join tig_ua_file_metadata fm on fm.owner_id = m.owner_id and fm.stable_id = m.stable_id where 1=1");
            if (domain != null) {
                stringBuilder.append(" and o.\"domain\" = ?");
            }
            if (ownerJid != null) {
                stringBuilder.append(" and o.jid_sha1 = ?");
            }
            if (buddyJid != null) {
                stringBuilder.append(" and b.jid_sha1 = ?");
            }
            if (after != null) {
                stringBuilder.append(" and m.ts >= ?");
            }
            if (before != null) {
                stringBuilder.append(" and m.ts <= ?");
            }
            if (smallerThan != null) {
                stringBuilder.append(" and fm.size < ?");
            }
            if (biggerThan != null) {
                stringBuilder.append(" and fm.size > ?");
            }
            if (mediaTypeContains != null) {
                stringBuilder.append(" and fm.media_type like ?");
            }
            if (contains != null) {
                stringBuilder.append(" and (fm.name like ? or fm.description like ? or fm.url like ?)");
            }
            if (beforeStableId != null) {
                stringBuilder.append(" and m.ts < (select ts from tig_ma_msgs m1 inner join tig_ma_jids o1 on m1.owner_id = o1.jid_id where 1=1");
                if (ownerJid != null) {
                    stringBuilder.append("and o1.jid_sha1 = ?");
                }
                stringBuilder.append("and m1.stable_id = ?)");
            }
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 0;
            if (domain != null) {
                preparedStatement.setString(++n, domain);
            }
            if (ownerJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
            }
            if (buddyJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)buddyJid));
            }
            if (after != null) {
                preparedStatement.setTimestamp(++n, after);
            }
            if (before != null) {
                preparedStatement.setTimestamp(++n, before);
            }
            if (smallerThan != null) {
                preparedStatement.setLong(++n, smallerThan);
            }
            if (biggerThan != null) {
                preparedStatement.setLong(++n, biggerThan);
            }
            if (mediaTypeContains != null) {
                preparedStatement.setString(++n, "%" + mediaTypeContains + "%");
            }
            if (contains != null) {
                String string = "%" + contains + "%";
                preparedStatement.setString(++n, contains);
                preparedStatement.setString(++n, contains);
                preparedStatement.setString(++n, contains);
            }
            if (beforeStableId != null) {
                if (ownerJid != null) {
                    preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
                }
                preparedStatement.setString(++n, beforeStableId);
            }
            results[0] = preparedStatement.executeQuery();
        }
    }
}

