/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.converter.converters;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import tigase.db.DataRepository;
import tigase.db.converter.Converter;
import tigase.db.converter.converters.UserCredentialsConverter;

class UserDataQueries {
    private static final String SELECT_USERS = "SELECT username, password FROM users";
    private static final String SELECT_NEW_USERS = "SELECT username, server_host, password FROM users";
    private static final String ROSTER_ITEMS = "SELECT username, jid, nick, subscription FROM rosterusers WHERE username = ?";
    private static final String ROSTER_NEW_ITEMS = "SELECT username, server_host, jid, nick, subscription FROM rosterusers WHERE username = ? AND server_host = ?";
    private static final String ROSTER_GROUPS = "SELECT username, jid, grp FROM rostergroups WHERE username = ? AND jid = ?";
    private static final String ROSTER_NEW_GROUPS = "SELECT username, server_host, jid, grp FROM rostergroups WHERE username = ? AND jid = ? AND server_host = ?";
    final Map<String, String> selectedQueries;
    DataRepository.dbTypes dbType;
    Map<String, Map<String, Map<String, String>>> queries = new ConcurrentHashMap<String, Map<String, Map<String, String>>>();
    Converter.SERVER serverType;

    UserDataQueries(Converter.SERVER serverType, DataRepository.dbTypes dbType) {
        this.serverType = serverType;
        this.dbType = dbType;
        Map ejabberdQueries = this.queries.computeIfAbsent(Converter.SERVER.ejabberd.name(), k -> new ConcurrentHashMap());
        ConcurrentHashMap<String, String> ejabberdSqlGeneric = new ConcurrentHashMap<String, String>();
        ejabberdSqlGeneric.put(UserCredentialsConverter.QUERY.users.name(), SELECT_USERS);
        ejabberdSqlGeneric.put(UserCredentialsConverter.QUERY.rosteritems.name(), ROSTER_ITEMS);
        ejabberdSqlGeneric.put(UserCredentialsConverter.QUERY.rostergroups.name(), ROSTER_GROUPS);
        ejabberdQueries.put(DataRepository.dbTypes.sqlserver.name(), ejabberdSqlGeneric);
        ejabberdQueries.put(DataRepository.dbTypes.jtds.name(), ejabberdSqlGeneric);
        ejabberdQueries.put(DataRepository.dbTypes.mysql.name(), ejabberdSqlGeneric);
        ejabberdQueries.put(DataRepository.dbTypes.postgresql.name(), ejabberdSqlGeneric);
        Map ejabberdNewQueries = this.queries.computeIfAbsent(Converter.SERVER.ejabberd_new.name(), k -> new ConcurrentHashMap());
        ConcurrentHashMap<String, String> ejabberdSqlNewGeneric = new ConcurrentHashMap<String, String>();
        ejabberdSqlNewGeneric.put(UserCredentialsConverter.QUERY.users.name(), SELECT_NEW_USERS);
        ejabberdSqlNewGeneric.put(UserCredentialsConverter.QUERY.rosteritems.name(), ROSTER_NEW_ITEMS);
        ejabberdSqlNewGeneric.put(UserCredentialsConverter.QUERY.rostergroups.name(), ROSTER_NEW_GROUPS);
        ejabberdNewQueries.put(DataRepository.dbTypes.mysql.name(), ejabberdSqlNewGeneric);
        ejabberdNewQueries.put(DataRepository.dbTypes.postgresql.name(), ejabberdSqlNewGeneric);
        this.selectedQueries = this.getAllQueriesForServerAndDatabase().orElse(Collections.emptyMap());
    }

    Optional<String> getQuery(String query) {
        return Optional.ofNullable(this.selectedQueries.get(query));
    }

    Optional<Map<String, String>> getAllQueriesForServerAndDatabase() {
        Map orDefault = this.queries.getOrDefault(this.serverType.name(), Collections.emptyMap());
        Map value = (Map)orDefault.get(this.dbType.name());
        return Optional.ofNullable(value);
    }
}

