/*
 * Decompiled with CFR 0.152.
 */
package tigase.cert;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;
import tigase.cert.CertificateGenerator;

public class OldSelfSignedCertificateGenerator
implements CertificateGenerator {
    private static final Logger log = Logger.getLogger(OldSelfSignedCertificateGenerator.class.getCanonicalName());

    private static void appendName(StringBuilder sb, String prefix, String value) {
        log.log(Level.FINE, "appending value: {0} with prefix: {1} to sb: {2}", new Object[]{value, prefix, sb.toString()});
        if (value != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(prefix).append('=').append(value);
        }
    }

    @Override
    public X509Certificate generateSelfSignedCertificate(String email, String domain, String organizationUnit, String organization, String city, String state, String country, KeyPair keyPair) throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        log.log(Level.INFO, "creating self signed cert, email: {0}, domain: {1}, organizationUnit: {2},organization: {3}, city: {4}, state: {5}, country: {6}, keyPair: {7}", new Object[]{email, domain, organizationUnit, organization, city, state, country, keyPair});
        X509CertInfo certInfo = new X509CertInfo();
        CertificateVersion certVersion = new CertificateVersion();
        certInfo.set("version", certVersion);
        Date firstDate = new Date();
        Date lastDate = new Date(firstDate.getTime() + 31536000000L);
        CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
        certInfo.set("validity", interval);
        certInfo.set("serialNumber", new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
        StringBuilder subject = new StringBuilder(1024);
        OldSelfSignedCertificateGenerator.appendName(subject, "CN", domain);
        OldSelfSignedCertificateGenerator.appendName(subject, "EMAILADDRESS", email);
        OldSelfSignedCertificateGenerator.appendName(subject, "OU", organizationUnit);
        OldSelfSignedCertificateGenerator.appendName(subject, "O", organization);
        OldSelfSignedCertificateGenerator.appendName(subject, "L", city);
        OldSelfSignedCertificateGenerator.appendName(subject, "ST", state);
        OldSelfSignedCertificateGenerator.appendName(subject, "C", country);
        X500Name issuerName = new X500Name(subject.toString());
        try {
            certInfo.set("issuer", issuerName);
            certInfo.set("subject", issuerName);
        }
        catch (CertificateException ex) {
            CertificateIssuerName certIssuer = new CertificateIssuerName(issuerName);
            CertificateSubjectName certSubject = new CertificateSubjectName(issuerName);
            certInfo.set("issuer", certIssuer);
            certInfo.set("subject", certSubject);
        }
        AlgorithmId algorithm = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid);
        CertificateAlgorithmId certAlgorithm = new CertificateAlgorithmId(algorithm);
        certInfo.set("algorithmID", certAlgorithm);
        CertificateX509Key certPublicKey = new CertificateX509Key(keyPair.getPublic());
        certInfo.set("key", certPublicKey);
        X509CertImpl newCert = new X509CertImpl(certInfo);
        newCert.sign(keyPair.getPrivate(), "SHA1WithRSA");
        log.log(Level.FINEST, "creating self signed cert, newCert: {0}", newCert);
        return newCert;
    }
}

