/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.ext.presence;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.IPubSubConfig;
import tigase.pubsub.PubSubComponent;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="presencePerNodeExtension", parent=PubSubComponent.class, active=false)
public class PresencePerNodeExtension
extends AbstractPubSubModule
implements Initializable,
UnregisterAware {
    public static final String XMLNS_EXTENSION = "tigase:pubsub:1";
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private final Map<BareJID, Map<String, Set<JID>>> occupants = new ConcurrentHashMap<BareJID, Map<String, Set<JID>>>();
    private final Map<BareJID, Map<String, Map<BareJID, Map<String, Packet>>>> presences = new ConcurrentHashMap<BareJID, Map<String, Map<BareJID, Map<String, Packet>>>>();
    @Inject
    private EventBus eventBus;
    @Inject
    private IPubSubConfig pubsubContext;

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public Collection<JID> getNodeOccupants(BareJID serviceJID, String nodeName) {
        Map<String, Set<JID>> services = this.occupants.get(serviceJID);
        if (services == null) {
            return Collections.emptyList();
        }
        Set<JID> occs = services.get(nodeName);
        if (occs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(occs);
    }

    public Collection<String> getNodes(BareJID serviceJID, JID occupantJID) {
        Map<String, Map<BareJID, Map<String, Packet>>> resources = this.presences.get(occupantJID.getBareJID());
        if (resources == null) {
            return Collections.emptyList();
        }
        Map<BareJID, Map<String, Packet>> x = resources.get(occupantJID.getResource());
        if (x == null) {
            return Collections.emptyList();
        }
        Map<String, Packet> p = x.get(serviceJID);
        return Collections.unmodifiableCollection(p.keySet());
    }

    public Collection<Packet> getPresence(BareJID serviceJID, String nodeName, BareJID occupantJID) {
        Map<String, Map<BareJID, Map<String, Packet>>> resources = this.presences.get(occupantJID);
        if (resources == null) {
            return Collections.emptyList();
        }
        HashSet<Packet> prs = new HashSet<Packet>();
        for (Map<BareJID, Map<String, Packet>> services : resources.values()) {
            Map<String, Packet> nodes = services.get(serviceJID);
            if (nodes == null || !nodes.containsKey(nodeName)) continue;
            prs.add(nodes.get(nodeName));
        }
        return prs;
    }

    public Packet getPresence(BareJID serviceJID, String nodeName, JID occupantJID) {
        Map<String, Map<BareJID, Map<String, Packet>>> resources = this.presences.get(occupantJID.getBareJID());
        if (resources == null) {
            return null;
        }
        Map<BareJID, Map<String, Packet>> services = resources.get(occupantJID.getResource());
        if (services == null) {
            return null;
        }
        Map<String, Packet> nodes = services.get(serviceJID);
        if (nodes == null) {
            return null;
        }
        return nodes.get(nodeName);
    }

    public void initialize() {
        this.eventBus.registerAll((Object)this);
    }

    public void beforeUnregister() {
        this.eventBus.unregisterAll((Object)this);
    }

    void addJidToOccupants(BareJID serviceJID, String nodeName, JID jid) {
        Set<JID> occs;
        Map<String, Set<JID>> services = this.occupants.get(serviceJID);
        if (services == null) {
            services = new ConcurrentHashMap<String, Set<JID>>();
            this.occupants.put(serviceJID, services);
        }
        if ((occs = services.get(nodeName)) == null) {
            occs = new HashSet<JID>();
            services.put(nodeName, occs);
        }
        occs.add(jid);
    }

    void addPresence(BareJID serviceJID, String nodeName, Packet packet) {
        Map<String, Packet> nodesPresence;
        Map<BareJID, Map<String, Packet>> services;
        JID sender = packet.getStanzaFrom();
        Map<String, Map<BareJID, Map<String, Packet>>> resources = this.presences.get(sender.getBareJID());
        if (resources == null) {
            resources = new ConcurrentHashMap<String, Map<BareJID, Map<String, Packet>>>();
            this.presences.put(sender.getBareJID(), resources);
        }
        if ((services = resources.get(sender.getResource())) == null) {
            services = new ConcurrentHashMap<BareJID, Map<String, Packet>>();
            resources.put(sender.getResource(), services);
        }
        if ((nodesPresence = services.get(serviceJID)) == null) {
            nodesPresence = new ConcurrentHashMap<String, Packet>();
            services.put(serviceJID, nodesPresence);
        }
        boolean isUpdate = nodesPresence.containsKey(nodeName);
        nodesPresence.put(nodeName, packet);
        this.addJidToOccupants(serviceJID, nodeName, sender);
        if (isUpdate) {
            this.eventBus.fire((Object)new UpdatePresenceEvent(this.pubsubContext.getComponentName(), serviceJID, nodeName, packet));
        } else {
            this.eventBus.fire((Object)new LoginToNodeEvent(this.pubsubContext.getComponentName(), serviceJID, nodeName, packet));
        }
    }

    void removeJidFromOccupants(BareJID serviceJID, String node, JID jid) {
        Map<String, Set<JID>> services = this.occupants.get(serviceJID);
        if (services != null) {
            Set<JID> occs = services.get(node);
            if (occs != null) {
                occs.remove(jid);
                if (occs.isEmpty()) {
                    this.occupants.remove(node);
                }
            }
            if (services.isEmpty()) {
                this.occupants.remove(serviceJID);
            }
        }
    }

    void removePresence(BareJID serviceJID, String nodeName, JID sender, Packet presenceStanza) {
        if (sender.getResource() == null) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Skip processing presence from BareJID " + sender);
            }
        } else {
            Map<String, Map<BareJID, Map<String, Packet>>> resources = this.presences.get(sender.getBareJID());
            if (resources != null) {
                Map<BareJID, Map<String, Packet>> services = resources.get(sender.getResource());
                if (services != null) {
                    Map<String, Packet> nodes = services.get(serviceJID);
                    if (nodes != null && nodeName != null) {
                        nodes.remove(nodeName);
                        this.removeJidFromOccupants(serviceJID, nodeName, sender);
                        Element event = new Element("LogoffFromNode", new String[]{"xmlns"}, new String[]{"tigase:events:pubsub"});
                        event.addChild((XMLNodeIfc)new Element("service", serviceJID.toString()));
                        event.addChild((XMLNodeIfc)new Element("node", nodeName));
                        event.addChild((XMLNodeIfc)new Element("sender", sender.toString()));
                        event.addChild((XMLNodeIfc)presenceStanza.getElement());
                        this.eventBus.fire((Object)event);
                        if (nodes.isEmpty()) {
                            services.remove(serviceJID);
                        }
                    } else if (nodes != null) {
                        Map<String, Packet> removed = services.remove(serviceJID);
                        this.intProcessLogoffFrom(serviceJID, sender, removed, presenceStanza);
                    }
                    if (services.isEmpty()) {
                        resources.remove(sender.getResource());
                    }
                }
                if (resources.isEmpty()) {
                    this.presences.remove(sender.getBareJID());
                }
            }
        }
    }

    @Override
    public boolean canHandle(Packet packet) {
        if (packet.getStanzaTo() == null || packet.getStanzaTo().getResource() == null) {
            return false;
        }
        if (super.canHandle(packet)) {
            return packet.getType() == null || packet.getType() == StanzaType.available || packet.getType() == StanzaType.unavailable;
        }
        return false;
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet packet) {
        block5: {
            JID stanzaFrom;
            BareJID serviceJID;
            StanzaType type;
            block3: {
                String nodeName;
                block4: {
                    type = packet.getType();
                    serviceJID = packet.getStanzaTo().getBareJID();
                    stanzaFrom = packet.getStanzaFrom();
                    if (stanzaFrom == null) {
                        return;
                    }
                    Element pubsubExtElement = packet.getElement().getChild("pubsub", XMLNS_EXTENSION);
                    if (pubsubExtElement == null) break block3;
                    nodeName = pubsubExtElement.getAttributeStaticStr("node");
                    if (type != null && type != StanzaType.available) break block4;
                    this.addPresence(serviceJID, nodeName, packet);
                    break block5;
                }
                if (StanzaType.unavailable != type) break block5;
                this.removePresence(serviceJID, nodeName, stanzaFrom, packet);
                break block5;
            }
            if (type == StanzaType.unavailable) {
                Collection<String> nds = this.getNodes(serviceJID, stanzaFrom);
                for (String nodeName : nds) {
                    this.removePresence(serviceJID, nodeName, stanzaFrom, packet);
                }
            }
        }
    }

    private void intProcessLogoffFrom(BareJID serviceJID, JID sender, Map<String, Packet> nodes, Packet presenceStanza) {
        if (nodes == null) {
            return;
        }
        for (String node : nodes.keySet()) {
            this.removeJidFromOccupants(serviceJID, node, sender);
            this.eventBus.fire((Object)new LogoffFromNodeEvent(this.pubsubContext.getComponentName(), serviceJID, node, sender, presenceStanza));
        }
    }

    public static class UpdatePresenceEvent {
        public final String componentName;
        public final String node;
        public final JID occupantJID;
        public final Packet presenceStanza;
        public final BareJID serviceJID;

        public UpdatePresenceEvent(String componentName, BareJID serviceJID, String node, Packet presenceStanza) {
            this.componentName = componentName;
            this.occupantJID = presenceStanza.getStanzaFrom();
            this.node = node;
            this.presenceStanza = presenceStanza;
            this.serviceJID = serviceJID;
        }
    }

    public static class LogoffFromNodeEvent {
        public final String componentName;
        public final String node;
        public final JID occupantJID;
        public final Packet presenceStanza;
        public final BareJID serviceJID;

        public LogoffFromNodeEvent(String componentName, BareJID serviceJID, String node, JID occupandJID, Packet presenceStanza) {
            this.componentName = componentName;
            this.occupantJID = occupandJID;
            this.node = node;
            this.presenceStanza = presenceStanza;
            this.serviceJID = serviceJID;
        }
    }

    public static class LoginToNodeEvent {
        public final String componentName;
        public final String node;
        public final JID occupantJID;
        public final Packet presenceStanza;
        public final BareJID serviceJID;

        public LoginToNodeEvent(String componentName, BareJID serviceJID, String node, Packet presenceStanza) {
            this.componentName = componentName;
            this.occupantJID = presenceStanza.getStanzaFrom();
            this.node = node;
            this.presenceStanza = presenceStanza;
            this.serviceJID = serviceJID;
        }
    }
}

