/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.SubscribeNodeModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="pendingSubscriptionModule", parent=PubSubComponent.class, active=true)
public class PendingSubscriptionModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"message").add((Criteria)ElementCriteria.name((String)"x", (String[])new String[]{"xmlns", "type"}, (String[])new String[]{"jabber:x:data", "submit"})).add((Criteria)ElementCriteria.name((String)"field", (String[])new String[]{"var"}, (String[])new String[]{"FORM_TYPE"})).add((Criteria)ElementCriteria.name((String)"value", (String)"http://jabber.org/protocol/pubsub#subscribe_authorization", null, null));

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#get-pending"};
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet message) throws PubSubException {
        try {
            BareJID toJid = message.getStanzaTo().getBareJID();
            Element element = message.getElement();
            Form x = new Form(element.getChild("x", "jabber:x:data"));
            String subId = x.getAsString("pubsub#subid");
            String node = x.getAsString("pubsub#node");
            BareJID subscriberJid = BareJID.bareJIDInstanceNS((String)x.getAsString("pubsub#subscriber_jid"));
            Boolean allow = x.getAsBoolean("pubsub#allow");
            if (allow == null) {
                return;
            }
            JID jid = message.getStanzaFrom();
            this.pubSubLogic.checkPermission(toJid, node, jid, PubSubLogic.Action.manageNode);
            ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, node);
            IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, node);
            String userSubId = nodeSubscriptions.getSubscriptionId(subscriberJid);
            if (subId != null && !subId.equals(userSubId)) {
                throw new PubSubException(element, Authorization.NOT_ACCEPTABLE, PubSubErrorCondition.INVALID_SUBID);
            }
            Subscription subscription = nodeSubscriptions.getSubscription(subscriberJid);
            if (subscription != Subscription.pending) {
                return;
            }
            Affiliation affiliation = nodeAffiliations.getSubscriberAffiliation(jid.getBareJID()).getAffiliation();
            if (allow.booleanValue()) {
                subscription = Subscription.subscribed;
                affiliation = Affiliation.member;
                nodeSubscriptions.changeSubscription(subscriberJid, subscription);
                nodeAffiliations.changeAffiliation(subscriberJid, affiliation);
            } else {
                subscription = Subscription.none;
                nodeSubscriptions.changeSubscription(subscriberJid, subscription);
            }
            this.getRepository().update(toJid, node, nodeSubscriptions);
            this.getRepository().update(toJid, node, nodeAffiliations);
            Packet msg = Message.getMessage((JID)message.getStanzaTo(), (JID)JID.jidInstance((BareJID)subscriberJid), null, null, null, null, (String)Utils.createUID(subscriberJid));
            msg.getElement().addChild((XMLNodeIfc)SubscribeNodeModule.makeSubscription(node, subscriberJid, subscription, null));
            this.packetWriter.write(msg);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing pending subscription packet", e);
            throw new RuntimeException(e);
        }
    }

    public List<Packet> sendAuthorizationRequest(String nodeName, JID fromJid, String subID, BareJID subscriberJid, IAffiliations nodeAffiliations) throws RepositoryException {
        Form x = new Form("form", "PubSub subscriber request", "To approve this entity's subscription request, click the OK button. To deny the request, click the cancel button.");
        x.addField(Field.fieldHidden((String)"FORM_TYPE", (String)"http://jabber.org/protocol/pubsub#subscribe_authorization"));
        x.addField(Field.fieldHidden((String)"pubsub#subid", (String)subID));
        x.addField(Field.fieldTextSingle((String)"pubsub#node", (String)nodeName, (String)"Node ID"));
        x.addField(Field.fieldJidSingle((String)"pubsub#subscriber_jid", (String)subscriberJid.toString(), (String)"UsersSubscription Address"));
        x.addField(Field.fieldBoolean((String)"pubsub#allow", (Boolean)Boolean.FALSE, (String)"Allow this JID to subscribe to this pubsub node?"));
        ArrayList<Packet> result = new ArrayList<Packet>();
        UsersAffiliation[] affiliations = nodeAffiliations.getAffiliations();
        if (affiliations != null) {
            for (UsersAffiliation affiliation : affiliations) {
                if (affiliation.getAffiliation() != Affiliation.owner) continue;
                Packet message = Message.getMessage((JID)fromJid, (JID)JID.jidInstance((BareJID)affiliation.getJid()), null, null, null, null, (String)Utils.createUID(affiliation.getJid()));
                message.getElement().addChild((XMLNodeIfc)x.getElement());
                result.add(message);
            }
        }
        return result;
    }
}

