/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.HashSet;
import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.eventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.IPubSubConfig;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.SendLastPublishedItem;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.AbstractConfigCreateNode;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="nodeConfigModule", parent=PubSubComponent.class, active=true)
public class NodeConfigModule
extends AbstractConfigCreateNode {
    private static final Criteria CRIT_CONFIG = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"configure"));
    @Inject
    private EventBus eventBus;
    @Inject
    private PublishItemModule publishModule;

    protected static String[] diff(String[] a, String[] b) {
        HashSet<String> r = new HashSet<String>();
        for (String $a : a) {
            r.add($a);
        }
        for (String $a : b) {
            r.add($a);
        }
        for (String $a : b) {
            r.remove($a);
        }
        return r.toArray(new String[0]);
    }

    public static void parseConf(AbstractNodeConfig conf, Element configure, IPubSubConfig config) throws PubSubException {
        Element x = configure.getChild("x", "jabber:x:data");
        Form foo = new Form(x);
        if (x != null && "submit".equals(x.getAttributeStaticStr("type"))) {
            for (Field field : conf.getForm().getAllFields()) {
                String var = field.getVar();
                Field cf = foo.get(var);
                if (cf == null) continue;
                if (!config.isSendLastPublishedItemOnPresence() && "pubsub#send_last_published_item".equals(var) && SendLastPublishedItem.on_sub_and_presence.name().equals(cf.getValue())) {
                    throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Requested on_sub_and_presence mode for sending last published item is disabled.");
                }
                field.setValues(cf.getValues());
            }
        }
    }

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#config-node"};
    }

    public Criteria getModuleCriteria() {
        return CRIT_CONFIG;
    }

    public void process(Packet packet) throws PubSubException {
        try {
            BareJID toJid = packet.getStanzaTo().getBareJID();
            Element element = packet.getElement();
            Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
            Element configure = pubSub.getChild("configure");
            String nodeName = configure.getAttributeStaticStr("node");
            StanzaType type = packet.getType();
            String id = element.getAttributeStaticStr("id");
            if (nodeName == null) {
                throw new PubSubException(element, Authorization.BAD_REQUEST, PubSubErrorCondition.NODEID_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
            }
            JID jid = packet.getStanzaFrom();
            this.pubSubLogic.checkPermission(toJid, nodeName, jid, PubSubLogic.Action.manageNode);
            Packet result = packet.okResult((Element)null, 0);
            if (type == StanzaType.get) {
                Element rPubSub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#owner"});
                Element rConfigure = new Element("configure", new String[]{"node"}, new String[]{nodeName});
                if (nodeConfig instanceof CollectionNodeConfig) {
                    ((CollectionNodeConfig)nodeConfig).setChildren(this.getRepository().getChildNodes(toJid, nodeName));
                }
                Element f = nodeConfig.getFormElement();
                rConfigure.addChild((XMLNodeIfc)f);
                rPubSub.addChild((XMLNodeIfc)rConfigure);
                result.getElement().addChild((XMLNodeIfc)rPubSub);
            } else if (type == StanzaType.set) {
                String[] children = nodeConfig instanceof CollectionNodeConfig ? this.getRepository().getChildNodes(toJid, nodeName) : new String[]{};
                String collectionOld = nodeConfig.getCollection() == null ? "" : nodeConfig.getCollection();
                NodeConfigModule.parseConf(nodeConfig, configure, this.config);
                if (!collectionOld.equals(nodeConfig.getCollection())) {
                    AbstractNodeConfig colNodeConfig;
                    if (collectionOld.equals("")) {
                        this.pubSubLogic.checkPermission(toJid, nodeConfig.getCollection(), jid, PubSubLogic.Action.manageNode);
                        colNodeConfig = this.getRepository().getNodeConfig(toJid, nodeConfig.getCollection());
                        if (!(colNodeConfig instanceof CollectionNodeConfig)) {
                            throw new PubSubException(Authorization.NOT_ALLOWED, "(#1) Node '" + nodeConfig.getCollection() + "' is not collection node");
                        }
                        this.getRepository().update(toJid, colNodeConfig.getNodeName(), colNodeConfig);
                        this.getRepository().removeFromRootCollection(toJid, nodeName);
                        Element associateNotification = this.createAssociateNotification(colNodeConfig.getNodeName(), nodeName);
                        this.publishModule.generateNodeNotifications(packet.getStanzaTo().getBareJID(), nodeName, associateNotification, null, false);
                    }
                    if (nodeConfig.getCollection().equals("")) {
                        colNodeConfig = this.getRepository().getNodeConfig(toJid, collectionOld);
                        if (colNodeConfig != null && colNodeConfig instanceof CollectionNodeConfig) {
                            this.getRepository().update(toJid, colNodeConfig.getNodeName(), colNodeConfig);
                        }
                        this.getRepository().addToRootCollection(toJid, nodeName);
                        Element disassociateNotification = this.createDisassociateNotification(collectionOld, nodeName);
                        this.publishModule.generateNodeNotifications(packet.getStanzaTo().getBareJID(), nodeName, disassociateNotification, null, false);
                    }
                }
                if (nodeConfig instanceof CollectionNodeConfig) {
                    AbstractNodeConfig nc;
                    String[] addedChildNodes;
                    String[] newChildren = nodeConfig.getChildren();
                    if (newChildren == null) {
                        newChildren = new String[]{};
                    }
                    String[] removedChildNodes = NodeConfigModule.diff(children, newChildren);
                    for (String ann : addedChildNodes = NodeConfigModule.diff(newChildren, children)) {
                        nc = this.getRepository().getNodeConfig(toJid, ann);
                        if (nc == null) {
                            throw new PubSubException(Authorization.ITEM_NOT_FOUND, "(#2) Node '" + ann + "' doesn't exists");
                        }
                        if (nc.getCollection().equals("")) {
                            this.getRepository().removeFromRootCollection(toJid, nc.getNodeName());
                        }
                        nc.setCollection(nodeName);
                        this.getRepository().update(toJid, nc.getNodeName(), nc);
                        Element associateNotification = this.createAssociateNotification(nodeName, ann);
                        this.publishModule.generateNodeNotifications(packet.getStanzaTo().getBareJID(), nodeName, associateNotification, null, false);
                    }
                    for (String rnn : removedChildNodes) {
                        nc = this.getRepository().getNodeConfig(toJid, rnn);
                        if (nc != null) {
                            nc.setCollection("");
                            this.getRepository().update(toJid, nc.getNodeName(), nc);
                        }
                        if (rnn == null || rnn.length() == 0) continue;
                        Element disassociateNotification = this.createDisassociateNotification(nodeName, rnn);
                        this.publishModule.generateNodeNotifications(packet.getStanzaTo().getBareJID(), nodeName, disassociateNotification, null, false);
                    }
                }
                this.getRepository().update(toJid, nodeName, nodeConfig);
                this.eventBus.fire((Object)new NodeConfigurationChangedEvent(this.config.getComponentName(), toJid, nodeName));
                if (nodeConfig.isNotify_config()) {
                    Element configuration = new Element("configuration", new String[]{"node"}, new String[]{nodeName});
                    this.publishModule.generateNodeNotifications(packet.getStanzaTo().getBareJID(), nodeName, configuration, null, false);
                }
            } else {
                throw new PubSubException(element, Authorization.BAD_REQUEST);
            }
            this.packetWriter.write(result);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing node config packet", e);
            throw new RuntimeException(e);
        }
    }

    protected boolean isIn(String node, String[] children) {
        if (node == null | children == null) {
            return false;
        }
        for (String x : children) {
            if (!x.equals(node)) continue;
            return true;
        }
        return false;
    }

    private Element createAssociateNotification(String collectionNodeName, String associatedNodeName) {
        Element colE = new Element("collection", new String[]{"node"}, new String[]{collectionNodeName});
        colE.addChild((XMLNodeIfc)new Element("associate", new String[]{"node"}, new String[]{associatedNodeName}));
        return colE;
    }

    private Element createDisassociateNotification(String collectionNodeName, String disassociatedNodeName) {
        Element colE = new Element("collection", new String[]{"node"}, new String[]{collectionNodeName});
        colE.addChild((XMLNodeIfc)new Element("disassociate", new String[]{"node"}, new String[]{disassociatedNodeName}));
        return colE;
    }

    public static class NodeConfigurationChangedEvent {
        public final String componentName;
        public final String node;
        public final BareJID serviceJid;

        public NodeConfigurationChangedEvent(String componentName, BareJID serviceJid, String node) {
            this.componentName = componentName;
            this.serviceJid = serviceJid;
            this.node = node;
        }
    }
}

