/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import tigase.component.PacketWriter;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="manageAffiliationsModule", parent=PubSubComponent.class, active=true)
public class ManageAffiliationsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"affiliations"));

    public static Packet createAffiliationNotification(JID fromJid, JID toJid, String nodeName, Affiliation affilation) {
        Packet message = Message.getMessage((JID)fromJid, (JID)toJid, null, null, null, null, null);
        Element pubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        message.getElement().addChild((XMLNodeIfc)pubsub);
        Element affilations = new Element("affiliations", new String[]{"node"}, new String[]{nodeName});
        pubsub.addChild((XMLNodeIfc)affilations);
        affilations.addChild((XMLNodeIfc)new Element("affilation", new String[]{"jid", "affiliation"}, new String[]{toJid.toString(), affilation.name()}));
        return message;
    }

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#modify-affiliations"};
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet packet) throws PubSubException {
        try {
            BareJID toJid = packet.getStanzaTo().getBareJID();
            Element element = packet.getElement();
            Element pubsub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
            Element affiliations = pubsub.getChild("affiliations");
            String nodeName = affiliations.getAttributeStaticStr("node");
            StanzaType type = packet.getType();
            if (type == null || type != StanzaType.get && type != StanzaType.set) {
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODE_REQUIRED);
            }
            JID senderJid = packet.getStanzaFrom();
            this.pubSubLogic.checkPermission(toJid, nodeName, senderJid, PubSubLogic.Action.manageNode);
            IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
            if (type == StanzaType.get) {
                this.processGet(packet, affiliations, nodeName, nodeAffiliations, this.packetWriter);
            } else if (type == StanzaType.set) {
                this.processSet(packet, affiliations, nodeName, nodeAffiliations, this.packetWriter);
            }
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing affiliation packet", e);
            throw new RuntimeException(e);
        }
    }

    private void processGet(Packet packet, Element affiliations, String nodeName, IAffiliations nodeAffiliations, PacketWriter packetWriter) throws RepositoryException {
        Element ps = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#owner"});
        Packet iq = packet.okResult(ps, 0);
        Element afr = new Element("affiliations", new String[]{"node"}, new String[]{nodeName});
        ps.addChild((XMLNodeIfc)afr);
        Object[] affiliationsList = nodeAffiliations.getAffiliations();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Node affiliations: " + nodeName + " / " + Arrays.toString(affiliationsList));
        }
        if (affiliationsList != null) {
            for (Object affi : affiliationsList) {
                if (((UsersAffiliation)affi).getAffiliation() == Affiliation.none) continue;
                Element affiliation = new Element("affiliation", new String[]{"jid", "affiliation"}, new String[]{((UsersAffiliation)affi).getJid().toString(), ((UsersAffiliation)affi).getAffiliation().name()});
                afr.addChild((XMLNodeIfc)affiliation);
            }
        }
        this.getRepository().update(packet.getStanzaTo().getBareJID(), nodeName, nodeAffiliations);
        packetWriter.write(iq);
    }

    private void processSet(Packet packet, Element affiliations, String nodeName, IAffiliations nodeAffiliations, PacketWriter packetWriter) throws PubSubException, RepositoryException {
        AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(packet.getStanzaTo().getBareJID(), nodeName);
        List affs = affiliations.getChildren();
        for (Object a : affs) {
            if ("affiliation".equals(a.getName())) continue;
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        HashMap<JID, Affiliation> changedAffiliations = new HashMap<JID, Affiliation>();
        for (Element element : affs) {
            String strAfiliation = element.getAttributeStaticStr("affiliation");
            String jidStr = element.getAttributeStaticStr("jid");
            JID jid = JID.jidInstanceNS((String)jidStr);
            if (strAfiliation == null) continue;
            Affiliation newAffiliation = Affiliation.valueOf(strAfiliation);
            Affiliation oldAffiliation = nodeAffiliations.getSubscriberAffiliation(jid.getBareJID()).getAffiliation();
            Affiliation affiliation = oldAffiliation = oldAffiliation == null ? Affiliation.none : oldAffiliation;
            if (oldAffiliation == Affiliation.none && newAffiliation != Affiliation.none) {
                nodeAffiliations.addAffiliation(jid.getBareJID(), newAffiliation);
                changedAffiliations.put(jid, newAffiliation);
                continue;
            }
            nodeAffiliations.changeAffiliation(jid.getBareJID(), newAffiliation);
            changedAffiliations.put(jid, newAffiliation);
        }
        this.getRepository().update(packet.getStanzaTo().getBareJID(), nodeName, nodeAffiliations);
        for (Map.Entry entry : changedAffiliations.entrySet()) {
            if (!nodeConfig.isTigaseNotifyChangeSubscriptionAffiliationState()) continue;
            packetWriter.write(ManageAffiliationsModule.createAffiliationNotification(packet.getStanzaTo(), (JID)entry.getKey(), nodeName, (Affiliation)((Object)entry.getValue())));
        }
        Packet iq = packet.okResult((Element)null, 0);
        packetWriter.write(iq);
    }
}

