/*
 * Decompiled with CFR 0.152.
 */
package tigase.auditlog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tigase.auditlog.AuditLogComponent;
import tigase.auditlog.Entry;
import tigase.auditlog.LogRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;

@Bean(name="slf4jRepository", parent=AuditLogComponent.class, active=true)
public class SLF4JRepository
implements LogRepository {
    private static final Logger a = LoggerFactory.getLogger(SLF4JRepository.class);
    @ConfigField(desc="Repository name")
    private String name;

    protected static String escapeJsonString(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("'", "\\'");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void append(Entry entry) {
        String string;
        if (a.isDebugEnabled() && (string = this.toJson(entry)) != null) {
            a.debug(string);
        }
    }

    @Override
    public List<Entry> getCachedEntries(int offset, int limit) {
        return null;
    }

    protected String toJson(Entry entry) {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> map = entry.getValues();
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        stringBuilder.append("{ ");
        boolean bl = true;
        for (String string : arrayList) {
            String string2 = map.get(string);
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            string = SLF4JRepository.escapeJsonString(string);
            string2 = SLF4JRepository.escapeJsonString(string2);
            stringBuilder.append("'").append(string).append("'").append(":");
            if (string2 != null) {
                stringBuilder.append("'").append(string2).append("'");
                continue;
            }
            stringBuilder.append("null");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

