/*
 * Decompiled with CFR 0.152.
 */
package tigase.auditlog;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import tigase.auditlog.AuditLogComponent;
import tigase.auditlog.Entry;
import tigase.auditlog.LogRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;

@Bean(name="memoryRepository", parent=AuditLogComponent.class, active=false)
public class MemoryRepository
implements LogRepository {
    private final LinkedList<Entry> a = new LinkedList();
    @ConfigField(desc="Repository name")
    private String name;
    @ConfigField(desc="Limit of entries kept in repository")
    private int limit = 10000;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void append(Entry entry) {
        this.a.offer(entry);
        if (this.a.size() > this.limit) {
            this.a.poll();
        }
    }

    @Override
    public synchronized List<Entry> getCachedEntries(int offset, int limit) {
        offset = this.a.size() - offset;
        if (offset < 0) {
            offset = 0;
        }
        if (offset - limit < 0) {
            limit = offset;
        }
        return new ArrayList<Entry>(this.a.subList(offset - limit, offset));
    }
}

