/*
 * Decompiled with CFR 0.152.
 */
package tigase.auditlog;

import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

public class Entry {
    private static final TimestampHelper a = new TimestampHelper();
    private final Map<String, String> b;

    public static Entry fromElement(Element elem) {
        if (elem == null || !"entry".equals(elem.getName())) {
            return null;
        }
        Entry entry = new Entry();
        entry.a(elem);
        if (entry.b.isEmpty()) {
            return null;
        }
        return entry;
    }

    private static Element b(Map<String, String> map) {
        Element element = new Element("entry");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            element.addChild((XMLNodeIfc)new Element(entry.getKey(), entry.getValue()));
        }
        return element;
    }

    private Entry() {
        this(new HashMap<String, String>());
    }

    private Entry(Map<String, String> values) {
        this.b = values;
    }

    public String getId() {
        return this.b.get("id");
    }

    public String getSessionId() {
        return this.b.get("sessionId");
    }

    public JID getConnectionId() {
        return JID.jidInstanceNS((String)this.b.get("connectionId"));
    }

    public String getClientIP() {
        return Optional.ofNullable(this.getConnectionId()).map(JID::getResource).map(string -> string.split("_")[2]).orElse(null);
    }

    public String getClusterNode() {
        return this.b.get("clusterNode");
    }

    public String getDomain() {
        return Optional.ofNullable(this.getUserJID()).map(jID -> jID.getDomain()).orElse(null);
    }

    public JID getUserJID() {
        return Optional.ofNullable(this.b.get("user")).map(JID::jidInstanceNS).orElse(null);
    }

    public Date getWhen() {
        String string = this.b.get("when");
        try {
            return a.parseTimestamp(string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException("Could not parse 'when' value = " + string, parseException);
        }
    }

    public String getType() {
        return this.b.get("type");
    }

    public String getSubtype() {
        return this.b.get("subtype");
    }

    public String getStanzaId() {
        return this.b.get("stanzaId");
    }

    public String getConversationId() {
        return this.b.get("conversationId");
    }

    public String getErrorCondition() {
        return this.b.get("errorCondition");
    }

    public String getErrorMessage() {
        return this.b.get("errorMessage");
    }

    public Map<String, String> getValues() {
        return Collections.unmodifiableMap(this.b);
    }

    public Element toElement() {
        return Entry.b(this.b);
    }

    private void a(Element element) {
        List list = element.getChildren();
        if (list != null) {
            for (Element element2 : list) {
                this.b.put(element2.getName(), element2.getCData());
            }
        }
    }

    public static class Builder {
        private final Map<String, String> a = new HashMap<String, String>();

        public Builder() {
            this.a.put("id", UUID.randomUUID().toString());
            String string = a.formatWithMs(new Date());
            this.a.put("when", string);
        }

        public Builder from(JID from) {
            return this.with("from", from);
        }

        public Builder to(JID to) {
            return this.with("to", to);
        }

        public Builder withConversationId(String callId) {
            return this.with("conversationId", callId);
        }

        public Builder withSessionId(String sessionId) {
            return this.with("sessionId", sessionId);
        }

        public Builder withConnectionId(JID connectionId) {
            return this.with("connectionId", connectionId);
        }

        public Builder withError(Element errorEl) {
            if (errorEl == null) {
                return this;
            }
            String string = null;
            String string2 = null;
            List list = errorEl.getChildren();
            if (list != null) {
                for (Element element : list) {
                    if (!element.getName().equals("text")) {
                        if (string != null) continue;
                        string = element.getName();
                        continue;
                    }
                    if (string2 != null) continue;
                    string2 = element.getCData();
                }
            }
            return this.with("errorCondition", string).with("errorCode", errorEl.getAttributeStaticStr("code")).with("errorMessage", string2);
        }

        public Builder withError(Authorization error, String message) {
            return this.with("errorCondition", error.getCondition()).with("errorCode", String.valueOf(error.getErrorCode())).with("errorMessage", message);
        }

        public Builder withStanzaId(String stanzaId) {
            return this.with("stanzaId", stanzaId);
        }

        public Builder withUserJID(JID userJID) {
            return this.with("user", userJID);
        }

        public Builder ofType(String type) {
            return this.with("type", type);
        }

        public Builder ofSubtype(String subtype) {
            return this.with("subtype", subtype);
        }

        public Builder onClusterNode(String node) {
            return this.with("clusterNode", node);
        }

        public Builder with(String name, JID value) {
            if (value != null) {
                this.a.put(name, value.toString());
            }
            return this;
        }

        public Builder with(String name, String value) {
            if (value != null) {
                this.a.put(name, value);
            }
            return this;
        }

        public Entry build() {
            return new Entry(this.a);
        }

        public Packet buildAppendPacket(JID componentJid) {
            Iq iq = new Iq(new Element("iq", new String[]{"type"}, new String[]{"set"}), null, componentJid);
            Element element = new Element("append", new String[]{"xmlns"}, new String[]{"http://tigase.org/protocol/auditlog"});
            element.addChild((XMLNodeIfc)Entry.b(this.a));
            iq.getElement().addChild((XMLNodeIfc)element);
            return iq;
        }
    }
}

