/*
 * Decompiled with CFR 0.152.
 */
package tigase.auditlog;

import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auditlog.Entry;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.dns.DNSResolverFactory;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="audit-log", parent=SessionManager.class, active=false)
public class AuditLogProcessor
extends XMPPProcessor
implements XMPPPacketFilterIfc,
XMPPStopListenerIfc {
    private static final Logger a = Logger.getLogger(AuditLogProcessor.class.getCanonicalName());
    private static final String b = "audit-log";
    public static final String XMLNS = "http://tigase.org/protocol/auditlog";
    private static final String c = "only-user-packets";
    private static final String d = "only-from-user-connection";
    private static final String e = "auth";
    private static final String f = "challenge";
    private static final String g = "response";
    private static final String h = "success";
    private static final String i = "failure";
    private static final String j = "type";
    private static final String k = "from";
    private static final String l = "to";
    private static final String[] m = new String[]{"iq", "jingle"};
    private static final String n = "urn:xmpp:jingle:1";
    private static final String[] o = new String[]{"message", "thread"};
    private static final String[] p = new String[]{"iq", "vCard"};
    private static final String[] q = new String[]{"iq", "VCARD"};
    private static final String r = "vcard-temp";
    private static final String[] s = new String[]{"iq", "vcard"};
    private static final String t = "urn:ietf:params:xml:ns:vcard-4.0";
    private final SimpleDateFormat u = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    @ConfigField(desc="Component JID", alias="component-jid")
    private JID componentJid = null;
    @ConfigField(desc="Logging level", alias="logging-level")
    private LoggingLevel loggingLevel = LoggingLevel.UserPacketsSentByUser;

    public AuditLogProcessor() {
        this.componentJid = JID.jidInstanceNS((String)b, (String)DNSResolverFactory.getInstance().getDefaultHost(), null);
        this.u.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public String id() {
        return b;
    }

    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (packet == null) {
            return;
        }
        if (session == null) {
            return;
        }
        if (!this.shouldLogPacket(packet, session)) {
            return;
        }
        switch (packet.getElemName()) {
            case "auth": 
            case "response": 
            case "challenge": {
                this.a(packet, session, results);
                break;
            }
            default: {
                this.b(packet, session, results);
            }
        }
    }

    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        results.offer(this.a(session, e, null).ofSubtype("disconnected").buildAppendPacket(this.componentJid));
    }

    protected String getEntryTypeFromPacket(Packet packet) {
        String string = packet.getElemName();
        if (string == "presence" && packet.getType() != null) {
            switch (packet.getType()) {
                case subscribe: 
                case subscribed: 
                case unsubscribe: 
                case unsubscribed: {
                    string = "subscribe";
                    break;
                }
            }
        }
        if (packet.isXMLNSStaticStr(p, r) || packet.isXMLNSStaticStr(q, r) || packet.isXMLNSStaticStr(s, t)) {
            string = "vcard";
        } else if (packet.isXMLNSStaticStr(m, n)) {
            string = "jingle";
        }
        return string;
    }

    protected String mapType(String type) {
        return type;
    }

    protected boolean shouldLogPacket(Packet packet, XMPPResourceConnection session) {
        switch (this.loggingLevel) {
            case All: {
                return true;
            }
            case UserPackets: {
                return !session.isServerSession() && this.a(packet, session, false);
            }
            case UserPacketsSentByUser: {
                return !session.isServerSession() && this.a(packet, session, true);
            }
            case Authentication: {
                if (session.isServerSession()) {
                    return false;
                }
                if (session.isAuthorized()) {
                    switch (packet.getElemName()) {
                        case "auth": 
                        case "challenge": 
                        case "response": 
                        case "success": 
                        case "failure": {
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                return this.a(packet, session, true);
            }
        }
        return false;
    }

    private boolean a(Packet packet, XMPPResourceConnection xMPPResourceConnection, boolean bl) {
        try {
            JID jID = xMPPResourceConnection.getConnectionId();
            if (!jID.equals((Object)packet.getPacketFrom()) && packet.getStanzaTo() != null && !xMPPResourceConnection.isUserId(packet.getStanzaTo().getBareJID())) {
                return false;
            }
            if (bl && !jID.equals((Object)packet.getPacketFrom())) {
                return false;
            }
        }
        catch (NoConnectionIdException noConnectionIdException) {
            a.log(Level.FINE, "This should not happen, this is not a server session and still connection id is not set: " + xMPPResourceConnection + ", packet: " + packet, noConnectionIdException);
            return true;
        }
        catch (NotAuthorizedException notAuthorizedException) {
            a.log(Level.FINE, "Packet to a user session which is not yet authenticated: " + xMPPResourceConnection + ", packet: " + packet);
            return true;
        }
        return true;
    }

    private void a(Packet packet, XMPPResourceConnection xMPPResourceConnection, Queue<Packet> queue) {
        String string = null;
        switch (packet.getElemName()) {
            case "auth": {
                string = packet.getAttributeStaticStr("mechanism");
                break;
            }
            case "challenge": {
                string = xMPPResourceConnection != null ? (String)xMPPResourceConnection.getSessionData("audit-log#mechanism") : null;
            }
        }
        ArrayDeque<Packet> arrayDeque = null;
        for (Packet packet2 : queue) {
            switch (packet2.getElemName()) {
                case "failure": {
                    Entry.Builder builder;
                    try {
                        builder = this.a(xMPPResourceConnection, e, null).ofSubtype(packet2.getElemName()).withError(Authorization.NOT_AUTHORIZED, Optional.ofNullable(packet2.getElement().getChild("text")).map(Element::getCData).orElse(null));
                        if (arrayDeque == null) {
                            arrayDeque = new ArrayDeque<Packet>();
                        }
                        arrayDeque.offer(builder.buildAppendPacket(this.componentJid));
                    }
                    catch (Exception exception) {
                        a.log(Level.SEVERE, "exception during creation of auditlog entry", exception);
                    }
                    break;
                }
                case "success": {
                    Entry.Builder builder;
                    try {
                        builder = this.a(xMPPResourceConnection, e, null).ofSubtype(packet2.getElemName());
                        if (arrayDeque == null) {
                            arrayDeque = new ArrayDeque();
                        }
                        arrayDeque.offer(builder.buildAppendPacket(this.componentJid));
                    }
                    catch (Exception exception) {
                        a.log(Level.SEVERE, "exception during creation of auditlog entry", exception);
                    }
                    break;
                }
                case "response": {
                    if (xMPPResourceConnection != null) {
                        xMPPResourceConnection.putSessionData("audit-log#mechanism", (Object)string);
                        break;
                    }
                    a.log(Level.FINE, "authorization packet without session, should not happen: {0}", packet.toString());
                    break;
                }
            }
        }
        if (arrayDeque != null) {
            queue.addAll((Collection<Packet>)arrayDeque);
        }
    }

    private void b(Packet packet, XMPPResourceConnection xMPPResourceConnection, Queue<Packet> queue) {
        if (queue.isEmpty()) {
            return;
        }
        String string = this.getEntryTypeFromPacket(packet);
        Entry.Builder builder = this.a(xMPPResourceConnection, string, packet.getAttributeStaticStr("id")).from(packet.getStanzaFrom()).to(packet.getStanzaTo());
        switch (string) {
            case "message": {
                builder.withConversationId(packet.getElemCDataStaticStr(o));
                break;
            }
            case "jingle": {
                builder.withConversationId(packet.getAttributeStaticStr(m, "sid"));
                break;
            }
        }
        if (packet.getType() != StanzaType.error) {
            for (Packet packet2 : queue) {
                if (!this.a(builder, packet)) continue;
                break;
            }
        }
        queue.offer(builder.buildAppendPacket(this.componentJid));
    }

    private boolean a(Entry.Builder builder, Packet packet) {
        Element element = packet.getElement().getChild("error");
        if (element == null) {
            return false;
        }
        builder.withError(element);
        return true;
    }

    private Entry.Builder a(XMPPResourceConnection xMPPResourceConnection, String string, String string2) {
        Entry.Builder builder = new Entry.Builder();
        if (xMPPResourceConnection != null) {
            try {
                if (xMPPResourceConnection.isAuthorized()) {
                    try {
                        builder.withUserJID(xMPPResourceConnection.getJID());
                    }
                    catch (NotAuthorizedException notAuthorizedException) {
                        a.log(Level.SEVERE, "should not happen", notAuthorizedException);
                    }
                } else {
                    BareJID bareJID = (BareJID)xMPPResourceConnection.getSessionData("authentication-jid");
                    if (bareJID != null) {
                        builder.withUserJID(JID.jidInstance((BareJID)bareJID));
                    }
                }
                builder.withSessionId(xMPPResourceConnection.getSessionId()).withConnectionId(xMPPResourceConnection.getConnectionId());
            }
            catch (NoConnectionIdException noConnectionIdException) {
                a.log(Level.SEVERE, "should not happen", noConnectionIdException);
            }
        }
        return builder.withStanzaId(string2).ofType(this.mapType(string)).onClusterNode(this.componentJid.getDomain());
    }

    public static enum LoggingLevel {
        All,
        UserPackets,
        UserPacketsSentByUser,
        Authentication;

    }
}

