/*
 * Decompiled with CFR 0.152.
 */
package tigase.auditlog;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auditlog.Entry;
import tigase.auditlog.LogRepository;
import tigase.auditlog.LogSearchableRepository;
import tigase.auditlog.SLF4JRepository;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.core.Kernel;
import tigase.licence.LicenceChecker;
import tigase.licence.LicenceCheckerUpdateCallback;
import tigase.licence.LicenceCheckerUpdateCallbackImpl;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;

@Bean(name="audit-log", parent=Kernel.class, active=false)
public class AuditLogComponent
extends AbstractMessageReceiver
implements Initializable,
RegistrarBean {
    protected static final String REPOSITORY_CLASSES_KEY = "repository-classes";
    public static final String COMPONENT_ID = "auditlog";
    private static final Logger a = Logger.getLogger(AuditLogComponent.class.getCanonicalName());
    private static final String[] b = new String[]{SLF4JRepository.class.getCanonicalName()};
    private static final String c = "http://tigase.org/protocol/auditlog";
    private LicenceChecker d;
    @Inject
    private CopyOnWriteArrayList<LogRepository> repos = new CopyOnWriteArrayList();
    @Inject(nullAllowed=true)
    private LogSearchableRepository searchableRepository;

    public int hashCodeForPacket(Packet packet) {
        return packet.hashCode();
    }

    public void initialize() {
        super.initialize();
        LicenceCheckerUpdateCallbackImpl licenceCheckerUpdateCallbackImpl = new LicenceCheckerUpdateCallbackImpl(COMPONENT_ID){

            public String getMissingLicenseWarning() {
                return "\nThis installation contains Tigase Auditlog package, not an open source software.\nThe Tigase Auditlog is only available under a commercial license.\nThe full text of the commercial license agreement is available upon request.\n\nThe Tigase Auditlog component is provided free of charge for testing and\ndevelopment purposes only. Any use of the component on production systems,\neither commercial or not-for-profit, requires the purchase of a license.\n\nIf the Tigase Auditlog component is activated without a valid license, it will\ncontinue to work, including its full set of features, but it will send\ncertain statistical information to Tigase's servers on a regular basis.\nIf the Tigase Auditlog component cannot access our servers to send information,\nit will stop working. Once a valid license is installed, the Tigase Auditlog\ncomponent will stop sending statistical information to Tigase's servers.\n\nBy activating the Tigase Auditlog component without a valid license you agree\nand accept that the component will send certain statistical information\n(such as DNS domain names, vhost names, number of online users, number of\ncluster nodes, etc.) which may be considered confidential and proprietary\nby the user. You accept and confirm that such information, which may be\nconsidered confidential or proprietary, will be transferred to Tigase's\nservers and that you will not pursue any remedy at law as a result of the\ninformation transfer.\nIf the Tigase Auditlog component is installed but not activated, no statistical\ninformation will be sent to Tigase's servers.";
            }
        };
        this.d = LicenceChecker.getLicenceChecker((String)COMPONENT_ID, (LicenceCheckerUpdateCallback)licenceCheckerUpdateCallbackImpl);
    }

    public void processPacket(Packet packet) {
        try {
            boolean bl = false;
            if ("iq" == packet.getElemName()) {
                for (Element element : packet.getElement().getChildren()) {
                    if (c != element.getXMLNS()) continue;
                    try {
                        bl |= this.processAction(packet, element);
                    }
                    catch (XMPPException xMPPException) {
                        Packet packet2 = Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, true);
                        this.addOutPacket(packet2);
                    }
                }
            }
            if (!bl) {
                Packet packet3 = Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, null, true);
                this.addOutPacket(packet3);
            }
        }
        catch (PacketErrorTypeException packetErrorTypeException) {
            a.log(Level.FINEST, "could not send ''error'' result for ''error'' type packet = {0}", packet.toString());
        }
    }

    public void register(Kernel kernel) {
    }

    public void unregister(Kernel kernel) {
    }

    public String getDiscoDescription() {
        return "Audit Log Component";
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map map = super.getDefaults(params);
        map.put(REPOSITORY_CLASSES_KEY, b);
        return map;
    }

    public LogSearchableRepository getSearchableRepository() {
        return this.searchableRepository;
    }

    protected boolean processAction(Packet packet, Element actionEl) throws XMPPException {
        switch (actionEl.getName()) {
            case "append": {
                if (packet.getType() != StanzaType.set) {
                    return false;
                }
                for (Element element : actionEl.getChildren()) {
                    Entry entry = Entry.fromElement(element);
                    if (entry == null) continue;
                    for (LogRepository logRepository : this.repos) {
                        try {
                            logRepository.append(entry);
                        }
                        catch (RepositoryException repositoryException) {
                            if (!a.isLoggable(Level.FINEST)) continue;
                            a.log(Level.FINEST, "failed to append entry to " + logRepository.getName(), repositoryException);
                        }
                    }
                }
                return true;
            }
            case "retrieve": {
                Object object;
                if (packet.getType() != StanzaType.get) {
                    return false;
                }
                if (!this.isAdmin(packet.getStanzaFrom())) {
                    this.addOutPacket(Authorization.FORBIDDEN.getResponseMessage(packet, null, true));
                    return true;
                }
                String string = actionEl.getAttributeStaticStr("offset");
                String string2 = actionEl.getAttributeStaticStr("limit");
                int n = string != null ? Integer.parseInt(string) : 0;
                int n2 = string2 != null ? Integer.parseInt(string2) : Integer.MAX_VALUE;
                Packet packet2 = null;
                List<Entry> list = null;
                Element element = this.repos.iterator();
                while (element.hasNext() && (list = (object = element.next()).getCachedEntries(n, n2)) == null) {
                }
                if (list != null) {
                    element = new Element("entries", new String[]{"xmlns", "offset", "limit"}, new String[]{c, String.valueOf(n), String.valueOf(n2)});
                    for (Entry entry : list) {
                        element.addChild((XMLNodeIfc)entry.toElement());
                    }
                    packet2 = packet.okResult(element, 0);
                } else {
                    packet2 = Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, null, true);
                }
                if (packet != null) {
                    this.addOutPacket(packet2);
                }
                return true;
            }
        }
        return false;
    }

    protected Collection<LogRepository> getRepositories() {
        return Collections.unmodifiableCollection(this.repos);
    }
}

