/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats.collector;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import tigase.stats.collector.DefaultElementSigner$BufferWriter;
import tigase.stats.collector.ElementSigner;
import tigase.stats.collector.SignatureException;
import tigase.stats.collector.a;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class DefaultElementSigner
implements ElementSigner {
    private static final Logger a = Logger.getLogger(DefaultElementSigner.class.toString());
    private final Key b;

    public DefaultElementSigner(byte[] byArray) {
        this(new SecretKeySpec(byArray, "HmacSHA1"));
    }

    public DefaultElementSigner(Key key) {
        this.b = key;
    }

    @Override
    public Element sign(Element element) {
        try {
            String string = "" + System.currentTimeMillis();
            return this.a(element, string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Element verify(Element object) throws SignatureException {
        if (!object.getName().equals("signature")) {
            throw new SignatureException("Unsupported element" + object.toString());
        }
        String string = object.getAttributeStaticStr("ver");
        try {
            if (string != null && "1".equals(string)) {
                string = object;
                object = this;
                Element element = (Element)string.getChild("object", null).getChildren().get(0);
                String string2 = string.getChild("timestamp", null).getCData();
                string = string.getChild("signaturevalue", null).getCData();
                Mac mac = ((DefaultElementSigner)object).getMacInstance();
                mac.init(((DefaultElementSigner)object).b);
                if (!super.a(mac, element, string2).equals(string)) {
                    throw new SignatureException("Invalid MAC!");
                }
                a.log(Level.FINEST, "DefaultElementSigner, object: " + element + ", timestamp: " + string2 + ", signaturevalue: " + string);
                return element;
            }
            throw new SignatureException("Unsupported signature version (" + string + ")");
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (Exception exception) {
            throw new SignatureException("Can't verify signature", exception);
        }
    }

    private String a(Mac mac, Element element, String string) {
        mac.update("timestamp=".getBytes());
        mac.update(string.getBytes());
        mac.update((byte)59);
        this.elementToBuffer(new a(this, mac), element);
        return Base64.encode((byte[])mac.doFinal());
    }

    private Element a(Element element, String string) {
        try {
            Object object = this.getMacInstance();
            ((Mac)object).init(this.b);
            object = this.a((Mac)object, element, string);
            Element element2 = new Element("signature");
            element2.setAttribute("ver", "1");
            Element element3 = new Element("object");
            element3.addChild((XMLNodeIfc)element);
            element = new Element("signaturevalue", (String)object);
            string = new Element("timestamp", string);
            element2.addChild((XMLNodeIfc)string);
            element2.addChild((XMLNodeIfc)element3);
            element2.addChild((XMLNodeIfc)element);
            return element2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected Mac getMacInstance() throws NoSuchAlgorithmException {
        return Mac.getInstance("HmacSHA256");
    }

    protected synchronized void elementToBuffer(DefaultElementSigner$BufferWriter defaultElementSigner$BufferWriter, Element element) {
        Iterator iterator;
        defaultElementSigner$BufferWriter.a("<");
        defaultElementSigner$BufferWriter.a(element.getName());
        if (element.getAttributes() != null) {
            iterator = new ArrayList();
            ((ArrayList)((Object)iterator)).addAll(element.getAttributes().keySet());
            Collections.sort(iterator);
            iterator = ((ArrayList)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                defaultElementSigner$BufferWriter.a(" ");
                defaultElementSigner$BufferWriter.a(string);
                defaultElementSigner$BufferWriter.a("=\"");
                defaultElementSigner$BufferWriter.a((CharSequence)element.getAttributes().get(string));
                defaultElementSigner$BufferWriter.a("\"");
            }
        }
        if ((iterator = element.getChildren()) != null && iterator.size() != 0 || element.getCData() != null) {
            defaultElementSigner$BufferWriter.a(">");
            if (iterator != null) {
                for (String string : element.getChildren()) {
                    this.elementToBuffer(defaultElementSigner$BufferWriter, (Element)string);
                }
            }
            if (element.getCData() != null) {
                defaultElementSigner$BufferWriter.a(element.getCData());
            }
            defaultElementSigner$BufferWriter.a("</");
            defaultElementSigner$BufferWriter.a(element.getName());
            defaultElementSigner$BufferWriter.a(">");
            return;
        }
        defaultElementSigner$BufferWriter.a("/>");
    }

    private Element a(Element object) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Element element = (Element)object.getChild("object", null).getChildren().get(0);
        String string = object.getChild("timestamp", null).getCData();
        object = object.getChild("signaturevalue", null).getCData();
        Mac mac = this.getMacInstance();
        mac.init(this.b);
        if (!this.a(mac, element, string).equals(object)) {
            throw new SignatureException("Invalid MAC!");
        }
        a.log(Level.FINEST, "DefaultElementSigner, object: " + element + ", timestamp: " + string + ", signaturevalue: " + (String)object);
        return element;
    }
}

