/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.cluster.strategy.cmd;

import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.server.Packet;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.server.cluster.strategy.OnlineUsersCachingStrategy;
import tigase.server.cluster.strategy.cmd.TrafficSyncCmdAbstract;
import tigase.xml.Element;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.jid.JID;

public class UserPresenceCmd
extends TrafficSyncCmdAbstract {
    private static final Logger a = Logger.getLogger(UserPresenceCmd.class.getName());

    protected static void updatePresence(OnlineUsersCachingStrategy strategy, ConnectionRecordExt rec, JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) {
        XMPPSession xMPPSession = (XMPPSession)strategy.getSM().getXMPPSessions().get(rec.getUserJid().getBareJID());
        Element element = packets.poll();
        strategy.presenceUpdate(element, rec);
        if (xMPPSession != null) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "User's {0} XMPPSession found: {1}", new Object[]{rec.getUserJid().getBareJID(), xMPPSession});
            }
            for (XMPPResourceConnection xMPPResourceConnection : xMPPSession.getActiveResources()) {
                Element element2 = xMPPResourceConnection.getPresence();
                if (!xMPPResourceConnection.isAuthorized() || !xMPPResourceConnection.isResourceSet() || element2 == null) continue;
                try {
                    Element element3 = element.clone();
                    element3.setAttribute("to", xMPPResourceConnection.getJID().toString());
                    Packet packet = Packet.packetInstance((Element)element3);
                    packet.setPacketTo(xMPPResourceConnection.getConnectionId());
                    strategy.getSM().fastAddOutPacket(packet);
                    if (data == null || !"initial".equals(data.get("pres-type"))) continue;
                    element2.setAttribute("to", String.valueOf(rec.getUserJid()));
                    Packet packet2 = Packet.packetInstance((Element)element2);
                    packet2.setPacketTo(rec.getConnectionId());
                    strategy.getSM().fastAddOutPacket(packet2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            strategy.getSM().processPresenceUpdate(xMPPSession, element);
        } else if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "No user session for presence update: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
        }
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "User presence jid: {0}, fromNode: {1}", new Object[]{rec.getUserJid(), fromNode});
        }
    }

    public UserPresenceCmd(String name, OnlineUsersCachingStrategy strat) {
        super(name, strat);
    }

    public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
        this.incSyncInTraffic();
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
        }
        ConnectionRecordExt connectionRecordExt = this.getConnectionRecord(fromNode, data);
        UserPresenceCmd.updatePresence(this.getStrategy(), connectionRecordExt, fromNode, visitedNodes, data, packets);
    }
}

