/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence.callbacks;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.db.comp.RepositoryItem;
import tigase.licence.Licence;
import tigase.licence.LicenceCheckerUpdateCallbackImpl;
import tigase.licence.LicenceCheckerUpdater;
import tigase.server.XMPPServer;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.stats.MaxDailyCounterQueue;
import tigase.stats.StatisticsCollector;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostManager;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.JID;

public class LicenceCheckerUpdateCallbackImplACS
extends LicenceCheckerUpdateCallbackImpl {
    private static final String a = "sess-man/strategy/OnlineUsersCachingStrategy/Max daily users connections count last month (whole cluster)[C]";
    private static final String b = "sess-man/Open user connections[I]";
    private static final String c = "sess-man/strategy/OnlineUsersCachingStrategy/Cached connections[I]";
    private static final String d = "cl-comp/Max daily cluster nodes count in last month[C]";
    private static final String e = "cl-comp/Known cluster nodes[I]";
    private static final Logger f = Logger.getLogger(LicenceCheckerUpdateCallbackImplACS.class.getName());
    private ClusteringStrategyIfc<ConnectionRecordExt> g;

    public LicenceCheckerUpdateCallbackImplACS(String cmpName, ClusteringStrategyIfc<ConnectionRecordExt> strategy) {
        super(cmpName);
        this.g = strategy;
    }

    public Element getComponentAdditionalData() {
        Element element = super.getComponentAdditionalData();
        try {
            String string = this.a(a).orElseGet(() -> this.b(c).orElse(-1) + this.b(b).orElse(-1)).toString();
            element.addChild((XMLNodeIfc)new Element("activeUsers", string));
            String string2 = this.a(d).orElseGet(() -> this.b(e).orElse(-1)).toString();
            element.addChild((XMLNodeIfc)new Element("clusterNodesCount", string2));
        }
        catch (Exception exception) {
            f.log(Level.SEVERE, "Problem creating StatisticsData", exception);
            element.addChild((XMLNodeIfc)new Element("exception", exception.getMessage()));
        }
        return element;
    }

    public boolean additionalValidation(Licence lic) {
        try {
            boolean bl = this.a(lic, "max-online-users", a);
            f.log(Level.ALL, "dailyLimitSurpassedUsers: {0}", bl);
            if (bl) {
                return false;
            }
            boolean bl2 = this.a(lic, "max-cluster-nodes", d);
            f.log(Level.ALL, "dailyLimitSurpassedCluster: {0}", bl2);
            if (bl2) {
                return false;
            }
            String string = lic.getPropertyAsString("vhost-name");
            if (string != null) {
                JID jID = JID.jidInstanceNS((String)string);
                VHostManager vHostManager = (VHostManager)XMPPServer.getComponent(VHostManager.class);
                List list = vHostManager.getAllVHosts();
                if (!list.contains(jID)) {
                    f.log(Level.WARNING, "Required VHost is not managed by Tigase.");
                    return false;
                }
                VHostItem vHostItem = vHostManager.getVHostItem(jID.getDomain());
                String string2 = vHostManager.getComponentRepository().validateItem((RepositoryItem)vHostItem);
                if (string2 != null) {
                    f.log(Level.WARNING, "Cannot validate vhost " + jID + ": " + string2);
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            f.log(Level.WARNING, "Problem on validating licence", exception);
            return false;
        }
    }

    public String getMissingLicenseWarning() {
        return "\nThis installation contains Tigase ACS package, not an open source software.\nThe Tigase ACS is only available under a commercial license.\nThe full text of the commercial license agreement is available upon request.\n\nMore information about ACS component and licensing can be found here:\nhttp://www.tigase.com/content/tigase-acs-advanced-clustering-strategy\nThe Tigase ACS component is provided free of charge for testing and\ndevelopment purposes only. Any use of the component on production systems,\neither commercial or not-for-profit, requires the purchase of a license.\n\nIf the Tigase ACS component is activated without a valid license, it will\ncontinue to work, including its full set of features, but it will send\ncertain statistical information to Tigase's servers on a regular basis.\nIf the Tigase ACS component cannot access our servers to send information,\nit will stop working. Once a valid license is installed, the Tigase ACS\ncomponent will stop sending statistical information to Tigase's servers.\n\nBy activating the Tigase ACS component without a valid license you agree\nand accept that the component will send certain statistical information\n(such as DNS domain names, vhost names, number of online users, number of\ncluster nodes, etc.) which may be considered confidential and proprietary\nby the user. You accept and confirm that such information, which may be\nconsidered confidential or proprietary, will be transferred to Tigase's\nservers and that you will not pursue any remedy at law as a result of the\ninformation transfer.\nIf the Tigase ACS component is installed but not activated, no statistical\ninformation will be sent to Tigase's servers.";
    }

    public Optional<Map<String, String>> getServerVerifiableMetrics() {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>(2);
        concurrentHashMap.put("online-users-count", this.a(a).orElseGet(() -> this.b(c).orElse(-1) + this.b(b).orElse(-1)).toString());
        concurrentHashMap.put("cluster-nodes-count", this.a(d).orElseGet(() -> this.b(e).orElse(-1)).toString());
        return Optional.of(concurrentHashMap);
    }

    private Optional<Integer> a(String string) {
        block3: {
            try {
                Collection collection;
                Optional optional = LicenceCheckerUpdater.getStats();
                if (optional.isPresent() && (collection = ((StatisticsCollector)optional.get()).getAllStats().getCollectionValue(string)) != null) {
                    MaxDailyCounterQueue maxDailyCounterQueue = (MaxDailyCounterQueue)collection;
                    return maxDailyCounterQueue.getMaxValue();
                }
            }
            catch (Exception exception) {
                String string2 = String.format("Cannot retrieve statistics for: %1$s. Field skipped. (msg: %2$s)", string, exception.getMessage());
                if (!f.isLoggable(Level.FINEST)) break block3;
                f.log(Level.FINEST, string2, exception);
            }
        }
        return Optional.empty();
    }

    private Optional<Integer> b(String string) {
        Integer n;
        block3: {
            n = null;
            try {
                Optional optional = LicenceCheckerUpdater.getStats();
                if (optional.isPresent()) {
                    n = (Integer)((StatisticsCollector)optional.get()).getAllStats().getValue(string);
                }
            }
            catch (Exception exception) {
                String string2 = String.format("Cannot retrieve statistics for: %1$s. Field skipped. (msg:%2$s)", string, exception.getMessage());
                if (!f.isLoggable(Level.FINEST)) break block3;
                f.log(Level.FINEST, string2, exception);
            }
        }
        return Optional.ofNullable(n);
    }

    private boolean a(Licence licence, String string, String string2) {
        Integer n = licence.getPropertyAsInteger(string);
        if (f.isLoggable(Level.FINEST)) {
            f.log(Level.FINEST, "Licence limits for property {0}: {1}", new Object[]{string, n});
        }
        if (n != null) {
            this.a(string2);
            Optional optional = LicenceCheckerUpdater.getStats();
            Collection collection = ((StatisticsCollector)LicenceCheckerUpdater.getStats().get()).getAllStats().getCollectionValue(string2);
            if (collection != null) {
                MaxDailyCounterQueue maxDailyCounterQueue = (MaxDailyCounterQueue)collection;
                boolean bl = maxDailyCounterQueue.isLimitSurpassed((Number)n);
                if (f.isLoggable(Level.FINEST)) {
                    f.log(Level.FINEST, "Limits check result for property {0}: {1} of {2} allowed, surpassed: {3}", new Object[]{string, maxDailyCounterQueue, n, bl});
                }
                if (bl) {
                    f.log(Level.WARNING, "Licence limits exceeded! Max of {0} in last period: {1}, Max allowed users (licence): {2}", new Object[]{string, maxDailyCounterQueue, n});
                    return true;
                }
            }
        }
        return false;
    }
}

