/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import tigase.cert.CertificateEntry;
import tigase.io.CertificateContainerIfc;
import tigase.kernel.beans.config.ConfigField;

public class PEMCertificateContainer
implements CertificateContainerIfc {
    public static final String PEM_PRIVATE_PWD_KEY = "pem-privatekey-password";
    public static final String PEM_PRIVATE_PWD_VAL = "";
    protected static final Logger log = Logger.getLogger(PEMCertificateContainer.class.getName());
    private static final String KEY_MANAGER_ALGORITHM = "SunX509";
    private static final String KEY_STORE_ALGORITHM = "JKS";
    private static final String TRUST_MANAGER_ALGORITHM = "X509";
    @ConfigField(desc="CA certs path", alias="trusted-certs-dir")
    private String caCertsPath = "/etc/ssl/certs";
    private TrustManager[] defTrustManagers = new X509TrustManager[]{new DummyTrustManager()};
    private String defaultHostname = "default";
    @ConfigField(desc="", alias="ssl-def-cert-domain")
    private String domainKeysPath = "";
    private String internalKeystorePassword = "";
    private Map<String, KeyManagerFactory> kmfs = new ConcurrentSkipListMap<String, KeyManagerFactory>();
    @ConfigField(desc="PEM Private Key password", alias="pem-privatekey-password")
    private String privateKeyPassphrase = "";
    private KeyStore trustKeyStore;
    private TrustManagerFactory trustManagerFactory;
    @ConfigField(desc="SSL certificate trust model", alias="ssl-trust-model")
    private TrustModel trustModel = TrustModel.selfsigned;

    public PEMCertificateContainer() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.setTrustModel(TrustModel.trusted);
    }

    public void addCertificates(Map<String, String> map) throws CertificateParsingException {
        this.kmfs.clear();
    }

    public KeyManager[] createCertificate(String s) throws NoSuchAlgorithmException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException, IOException, UnrecoverableKeyException, KeyStoreException {
        return new KeyManager[0];
    }

    public CertificateEntry getCertificateEntry(String hostname) {
        String alias = hostname;
        if (alias == null) {
            alias = this.getDefCertAlias();
        }
        try {
            File[] path = new File[]{new File(new File(this.domainKeysPath).getAbsoluteFile() + File.separator + hostname + ".pem"), new File(new File(this.domainKeysPath).getAbsoluteFile() + File.separator + hostname + ".key"), new File(new File(this.domainKeysPath).getAbsoluteFile() + File.separator + hostname + ".cer")};
            KeyStore keyStore = this.loadFromPEMFile(path, hostname, this.privateKeyPassphrase);
            KeyStore.PrivateKeyEntry e = (KeyStore.PrivateKeyEntry)keyStore.getEntry(hostname, null);
            ArrayList<Certificate> cc = new ArrayList<Certificate>();
            if (e.getCertificate() != null) {
                cc.add(e.getCertificate());
            }
            if (e.getCertificateChain() != null) {
                cc.addAll(Arrays.asList(e.getCertificateChain()));
            }
            CertificateEntry c = new CertificateEntry();
            c.setPrivateKey(e.getPrivateKey());
            c.setCertChain(cc.toArray(new Certificate[0]));
            return c;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not load certificate for domain " + hostname);
        }
    }

    public String getDefCertAlias() {
        return this.defaultHostname;
    }

    public KeyManager[] getKeyManagers(String hostname) {
        KeyManagerFactory kmf = this.kmfs.get(hostname);
        if (kmf != null) {
            return kmf.getKeyManagers();
        }
        try {
            File[] path = new File[]{new File(new File(this.domainKeysPath).getAbsoluteFile() + File.separator + hostname + ".pem"), new File(new File(this.domainKeysPath).getAbsoluteFile() + File.separator + hostname + ".key"), new File(new File(this.domainKeysPath).getAbsoluteFile() + File.separator + hostname + ".cer")};
            KeyStore keyStore = this.loadFromPEMFile(path, hostname, this.privateKeyPassphrase);
            kmf = KeyManagerFactory.getInstance(KEY_MANAGER_ALGORITHM);
            kmf.init(keyStore, this.privateKeyPassphrase.toCharArray());
            this.kmfs.put(hostname, kmf);
            return kmf.getKeyManagers();
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not load certificate for domain " + hostname);
        }
    }

    public TrustManager[] getTrustManagers() {
        return this.defTrustManagers;
    }

    public KeyStore getTrustStore() {
        return this.trustKeyStore;
    }

    public void init(Map<String, Object> params) {
        this.caCertsPath = this.getFromMap(params, "trusted-certs-dir", "/etc/ssl/certs");
        boolean allowInvalidCerts = Boolean.getBoolean(this.getFromMap(params, "allow-invalid-certs", "false"));
        boolean allowSelfSignedCerts = "true".equals(this.getFromMap(params, "allow-self-signed-certs", "true"));
        this.trustModel = allowInvalidCerts ? TrustModel.all : (allowSelfSignedCerts ? TrustModel.selfsigned : TrustModel.trusted);
        this.domainKeysPath = this.getFromMap(params, "ssl-certs-location", "certs/");
        this.privateKeyPassphrase = this.getFromMap(params, PEM_PRIVATE_PWD_KEY, PEM_PRIVATE_PWD_VAL);
        this.defaultHostname = this.getFromMap(params, "ssl-def-cert-domain", "default");
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error on initialization", e);
        }
        this.setTrustModel(this.trustModel);
    }

    public void setTrustModel(TrustModel model) {
        this.trustModel = model;
        switch (this.trustModel) {
            case all: {
                this.defTrustManagers = new TrustManager[]{new DummyTrustManager()};
                break;
            }
            case selfsigned: {
                this.defTrustManagers = new TrustManager[]{new SelfSignedTrustManager(this.trustKeyStore)};
                break;
            }
            case trusted: {
                this.defTrustManagers = this.trustManagerFactory.getTrustManagers();
                break;
            }
            default: {
                throw new RuntimeException("Unknown trust model: " + this.trustModel);
            }
        }
    }

    private String getFromMap(Map<String, Object> params, String key, String defaultVal) {
        if (params.containsKey(key)) {
            return (String)params.get(key);
        }
        params.put(key, defaultVal);
        return defaultVal;
    }

    private void init() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, InvalidAlgorithmParameterException {
        File root = new File(this.caCertsPath);
        File[] files = root.listFiles();
        this.trustKeyStore = KeyStore.getInstance(KEY_STORE_ALGORITHM);
        this.trustKeyStore.load(null, this.internalKeystorePassword.toCharArray());
        log.config("Initializing SSL Context Container with trust model = " + this.trustModel.name());
        log.info("Loading trusted CA certificates from " + root.getAbsolutePath() + "...");
        if (files != null) {
            for (File file : files) {
                try {
                    List<Object> objs = this.readObjectsFromFile(file, null);
                    for (Object object : objs) {
                        if (!(object instanceof X509Certificate)) continue;
                        X509Certificate crt = (X509Certificate)object;
                        String alias = crt.getSubjectDN().getName();
                        this.trustKeyStore.setCertificateEntry(alias, crt);
                        log.finest("Imported cert: " + crt.getSubjectDN().getName());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        log.info("Loaded " + this.trustKeyStore.size() + " trusted CA certificates.");
        this.trustManagerFactory = TrustManagerFactory.getInstance(TRUST_MANAGER_ALGORITHM);
        X509CertSelector selector = new X509CertSelector();
        PKIXBuilderParameters cpp = new PKIXBuilderParameters(this.trustKeyStore, (CertSelector)selector);
        cpp.setRevocationEnabled(false);
        CertPathTrustManagerParameters p = new CertPathTrustManagerParameters(cpp);
        this.trustManagerFactory.init(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadFromPEMFile(File[] fileNames, String alias, final String privateKeyPassphrase) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        PasswordFinder x = new PasswordFinder(){

            public char[] getPassword() {
                if (privateKeyPassphrase != null) {
                    return privateKeyPassphrase.toCharArray();
                }
                return null;
            }
        };
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        Key key = null;
        log.info("Reading private key & certificate chain; alias: '" + alias + "', password: '" + privateKeyPassphrase + "'");
        for (File fileName : fileNames) {
            if (!fileName.exists()) continue;
            log.info("Reading data from file " + fileName);
            try (PEMReader reader = null;){
                reader = new PEMReader((Reader)new FileReader(fileName), x);
                Object pemObject = null;
                while ((pemObject = reader.readObject()) != null) {
                    if (pemObject instanceof Certificate) {
                        certs.add((Certificate)pemObject);
                        continue;
                    }
                    if (pemObject instanceof KeyPair) {
                        key = ((KeyPair)pemObject).getPrivate();
                        continue;
                    }
                    if (!(pemObject instanceof Key)) continue;
                    key = (Key)pemObject;
                }
            }
        }
        if (certs.size() > 0) {
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_ALGORITHM);
            keyStore.load(null, this.internalKeystorePassword.toCharArray());
            keyStore.setKeyEntry(alias, key, this.internalKeystorePassword.toCharArray(), certs.toArray(new Certificate[0]));
            return keyStore;
        }
        return this.loadFromPEMFile(new File[]{new File(new File(this.domainKeysPath).getAbsoluteFile() + File.separator + "default.pem")}, alias, privateKeyPassphrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> readObjectsFromFile(File file, final String password) throws IOException {
        PEMReader reader = null;
        PasswordFinder pfinder = new PasswordFinder(){

            public char[] getPassword() {
                if (password != null) {
                    return password.toCharArray();
                }
                return null;
            }
        };
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            reader = new PEMReader((Reader)new FileReader(file), pfinder);
            Object pemObject = null;
            while ((pemObject = reader.readObject()) != null) {
                result.add(pemObject);
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static class SelfSignedTrustManager
    implements X509TrustManager {
        private CertPathValidator certPathValidator;
        private KeyStore localTrustKeystore;
        private X509Certificate root;

        public SelfSignedTrustManager(KeyStore trustKeystore) {
            try {
                this.localTrustKeystore = KeyStore.getInstance(PEMCertificateContainer.KEY_STORE_ALGORITHM);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                trustKeystore.store(out, PEMCertificateContainer.PEM_PRIVATE_PWD_VAL.toCharArray());
                this.localTrustKeystore.load(new ByteArrayInputStream(out.toByteArray()), PEMCertificateContainer.PEM_PRIVATE_PWD_VAL.toCharArray());
                this.certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error on construct TrustManager", e);
                throw new RuntimeException("Error on construct TrustManager", e);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509Certificate certificate : chain) {
                if (!certificate.getIssuerDN().equals(certificate.getSubjectDN())) continue;
                this.root = certificate;
                break;
            }
            try {
                this.localTrustKeystore.setCertificateEntry("root", this.root);
                X509CertSelector selector = new X509CertSelector();
                PKIXBuilderParameters params = new PKIXBuilderParameters(this.localTrustKeystore, (CertSelector)selector);
                params.setRevocationEnabled(false);
                List<X509Certificate> certList = Arrays.asList(chain);
                CertPath certPath = CertificateFactory.getInstance("X.509").generateCertPath(certList);
                this.certPathValidator.validate(certPath, params);
            }
            catch (Exception e) {
                throw new CertificateException(e);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[]{this.root};
        }
    }

    private static class DummyTrustManager
    implements X509TrustManager {
        private DummyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private static enum TrustModel {
        all,
        selfsigned,
        trusted;

    }
}

