/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.emailconfirm;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AuthRepository;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.extras.AbstractEmailSender;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.util.Token;
import tigase.util.dns.DNSResolverFactory;
import tigase.xmpp.Authorization;
import tigase.xmpp.XMPPProcessorException;
import tigase.xmpp.impl.JabberIqRegister;
import tigase.xmpp.jid.BareJID;

@Bean(name="account-registration-email-validator", parent=Kernel.class, active=false, exportable=true)
public class EmailConfirmationSender
extends AbstractEmailSender
implements JabberIqRegister.AccountValidator,
Initializable,
UnregisterAware {
    public static final String EMAIL_CONFIRMATION_TOKEN_KEY = "email-confirmation-token";
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    @Inject
    private AuthRepository authRepository;
    @Inject
    private EventBus eventBus;
    @ConfigField(desc="URL of token verifier")
    private String tokenVerifierURL = "http://" + DNSResolverFactory.getInstance().getDefaultHost() + ":8080/rest/user/confirm/";
    @Inject
    private UserRepository userRepository;

    public EmailConfirmationSender() {
        super("Email confirmation", "mails/email-confirmation.template");
    }

    public void beforeUnregister() {
        this.eventBus.unregisterAll((Object)this);
    }

    public void initialize() {
        this.eventBus.registerAll((Object)this);
    }

    public void checkRequiredParameters(BareJID jid, Map<String, String> reg_params) throws XMPPProcessorException {
        String email = reg_params.getOrDefault("email", "").trim();
        if (email.isEmpty()) {
            throw new XMPPProcessorException(Authorization.NOT_ACCEPTABLE, "Email address is required");
        }
        try {
            InternetAddress internetAddress = new InternetAddress(email);
            internetAddress.validate();
        }
        catch (AddressException e) {
            throw new XMPPProcessorException(Authorization.NOT_ACCEPTABLE, "Email address '" + email + "' is invalid");
        }
    }

    public boolean sendAccountValidation(BareJID jid, Map<String, String> reg_params) {
        String email = reg_params.get("email");
        this.sendToken(jid, email, reg_params);
        return true;
    }

    public BareJID validateAccount(String encodedToken) {
        try {
            Token token = Token.parse((String)encodedToken);
            String tokenHash = this.userRepository.getData(token.getJid(), EMAIL_CONFIRMATION_TOKEN_KEY);
            this.log.log(Level.FINEST, "Validating token, jid: {0}, tokenHash: {1}, token.getHash(): {2}", new Object[]{token.getJid(), tokenHash, token.getHash()});
            if (tokenHash == null) {
                throw new RuntimeException("Token not found");
            }
            if (!token.getHash().equals(tokenHash)) {
                throw new RuntimeException("Invalid token");
            }
            this.authRepository.setAccountStatus(token.getJid(), AuthRepository.AccountStatus.active);
            this.userRepository.removeData(token.getJid(), EMAIL_CONFIRMATION_TOKEN_KEY);
            return token.getJid();
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Internal Server Error", ex);
        }
    }

    public void sendToken(BareJID bareJID, String email, Map<String, String> req_params) {
        Token token = Token.create((BareJID)bareJID);
        this.log.log(Level.FINEST, "Sending token, jid: {0}, timestamp: {1}, to mail: {2} ", new Object[]{token.getJid(), token.getTimestamp(), email});
        try {
            this.userRepository.setData(bareJID, EMAIL_CONFIRMATION_TOKEN_KEY, token.getHash());
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Cannot store token in database", e);
            throw new RuntimeException("Cannot store token in database", e);
        }
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("jid", bareJID);
        bindings.put("token", token);
        bindings.put("tokenEncoded", token.getEncoded());
        bindings.put("tokenVerifierURL", this.tokenVerifierURL);
        try {
            this.sendMail(email, bindings);
        }
        catch (AddressException e) {
            this.log.log(Level.FINE, "Cannot send confirmation mail", e);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Cannot send confirmation mail", e);
        }
    }
}

