/*
 * Decompiled with CFR 0.152.
 */
package tigase.spam.adhocs;

import java.util.Collection;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.xmppsession.SessionManager;
import tigase.spam.SpamProcessor;
import tigase.spam.filters.KnownSpammersFilter;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="listKnownSpammers", parent=SessionManager.class, active=true)
public class ListKnownSpammers
implements AdHocCommand {
    private static final Logger log = Logger.getLogger(ListKnownSpammers.class.getCanonicalName());
    @Inject
    private AdHocCommandModule.ScriptCommandProcessor scriptCommandProcessor;
    @Inject(nullAllowed=true)
    private SpamProcessor spamProcessor;

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else {
                DataForm.Builder builder = new DataForm.Builder(Command.DataType.form);
                Optional<String> filter = Optional.ofNullable(DataForm.getFieldValue((Element)data, (String)"filter"));
                int limit = Optional.ofNullable(DataForm.getFieldValue((Element)data, (String)"limit")).map(value -> {
                    try {
                        return Integer.parseInt(value);
                    }
                    catch (Throwable ex) {
                        return null;
                    }
                }).orElse(25);
                Optional<Collection> spammers = Optional.ofNullable(this.spamProcessor).map(SpamProcessor::getSpammers);
                if (spammers.isPresent()) {
                    builder.addField(DataForm.FieldType.TextSingle, "filter").setLabel("Filter only spammers which contain").setValue((String)filter.orElse(null)).build();
                    builder.addField(DataForm.FieldType.TextSingle, "limit").setLabel("Max no. of returned entries").setValue(String.valueOf(limit)).build();
                    builder.addField(DataForm.FieldType.JidMulti, "spammers").setLabel("List of known spammers").setValues((String[])spammers.get().stream().map(KnownSpammersFilter.Spammer::getJID).map(BareJID::toString).filter(jid -> filter.isEmpty() || filter.filter(str -> jid.contains((CharSequence)str)).isPresent()).sorted().limit(limit).toArray(String[]::new)).build();
                } else {
                    builder.addField(DataForm.FieldType.Fixed, "note").setLabel("Warning").setValue("Known spammers storage is unavailable.").build();
                }
                response.setNewState(AdHocResponse.State.executing);
                response.getElements().add(builder.build());
                response.completeSession();
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Error during processing command", e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public String getName() {
        return "List known spammers";
    }

    public String getNode() {
        return "list-known-spammers";
    }

    public boolean isAllowedFor(JID jid) {
        return this.scriptCommandProcessor.isAllowed(this.getNode(), jid);
    }
}

