/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.modules;

import java.text.ParseException;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.MessageArchiveComponent;
import tigase.archive.TagsHelper;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.modules.AbstractModule;
import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.kernel.beans.Bean;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="archiving", parent=MessageArchiveComponent.class, active=true)
public class ArchivingModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(ArchivingModule.class.getCanonicalName());
    private final TimestampHelper timestampHelper = new TimestampHelper();

    public String[] getFeatures() {
        return new String[0];
    }

    public Criteria getModuleCriteria() {
        return null;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        String ownerStr = packet.getAttributeStaticStr("owner");
        if (ownerStr != null) {
            BareJID owner;
            MessageArchiveRepository.Direction direction;
            packet.getElement().removeAttribute("owner");
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "for user {0} storing message: {1}", new Object[]{ownerStr, packet.toString()});
            }
            JID buddy = (direction = MessageArchiveRepository.Direction.getDirection(owner = BareJID.bareJIDInstanceNS((String)ownerStr), packet.getStanzaFrom().getBareJID())) == MessageArchiveRepository.Direction.outgoing ? packet.getStanzaTo() : packet.getStanzaFrom();
            Element msg = packet.getElement();
            Date timestamp = null;
            Element delay = msg.findChildStaticStr(Message.MESSAGE_DELAY_PATH);
            if (delay != null) {
                try {
                    String stamp = delay.getAttributeStaticStr("stamp");
                    timestamp = this.timestampHelper.parseTimestamp(stamp);
                }
                catch (ParseException e1) {
                    timestamp = new Date();
                }
            } else {
                timestamp = new Date();
            }
            Set<String> tags = null;
            if (this.config.isTagSupportEnabled()) {
                tags = TagsHelper.extractTags(msg);
            }
            this.msg_repo.archiveMessage(owner, buddy, timestamp, msg, packet.getStableId(), tags);
        } else {
            log.log(Level.INFO, "Owner attribute missing from packet: {0}", packet);
        }
    }

    public boolean canHandle(Packet packet) {
        return "message" == packet.getElemName() || packet.getStanzaTo() != null && !this.config.getComponentId().equals((Object)packet.getStanzaTo()) && packet.getAttributeStaticStr("owner") != null;
    }
}

