/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import java.util.HashMap;
import java.util.Optional;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.util.RepositoryVersionAware;
import tigase.mongodb.MongoDataSource;
import tigase.mongodb.MongoMsgRepository;
import tigase.mongodb.MongoRepository;
import tigase.mongodb.MongoRepositoryVersionAware;
import tigase.mongodb.archive.MongoMessageArchiveRepository;
import tigase.mongodb.muc.MongoHistoryProvider;
import tigase.mongodb.pubsub.PubSubDAOMongo;
import tigase.util.Version;

public class MongoSchemaUpdater {
    public static void main(String[] args) throws Exception {
        String schema = null;
        String uri = null;
        block22: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-schema": {
                    if (args.length <= i + 1) continue block22;
                    schema = args[++i];
                    continue block22;
                }
                case "-uri": {
                    if (args.length <= i + 1) continue block22;
                    uri = args[++i];
                    continue block22;
                }
            }
        }
        if (schema == null || uri == null) {
            String help = "Usage:$ java -cp \"jars/*.jar\" tigase.mongodb.MongoSchemaUpdater\n\t -schema schema type {user, offline-messages, muc, pubsub, message-archive} \n\t -uri uri to connect to MongoDB";
            System.out.println(help);
            return;
        }
        MongoDataSource dataSource = new MongoDataSource();
        dataSource.initRepository(uri, new HashMap<String, String>());
        MongoRepositoryVersionAware repository = null;
        switch (schema) {
            case "user": {
                repository = new MongoRepository();
                break;
            }
            case "offline-messages": {
                repository = new MongoMsgRepository();
                break;
            }
            case "message-archive": {
                repository = new MongoMessageArchiveRepository();
                break;
            }
            case "muc": {
                repository = new MongoHistoryProvider();
                break;
            }
            case "pubsub": {
                repository = new PubSubDAOMongo();
                break;
            }
            default: {
                System.out.println("Unknown schema type '" + schema + "' to upgrade");
                return;
            }
        }
        if (!(repository instanceof DataSourceAware)) {
            System.out.println("Repository do not implement DataSourceAware - can not initialize repository instance for schema update!");
            return;
        }
        if (!(repository instanceof RepositoryVersionAware)) {
            System.out.println("Repository do not implement RepositoryVersionAware - can not update schema for repository which is unware of schema version!");
        }
        ((DataSourceAware)repository).setDataSource((DataSource)dataSource);
        ((RepositoryVersionAware)repository).updateSchema(Optional.of(Version.ZERO), Version.ZERO);
    }
}

